/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.data.CategoryDataset;
import org.jfree.util.BooleanList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private boolean drawShapes;
    private boolean drawLines;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;

    public LineAndShapeRenderer() {
        this(3);
    }

    public LineAndShapeRenderer(int type) {
        if (type == 1) {
            this.drawShapes = true;
        }
        if (type == 2) {
            this.drawLines = true;
        }
        if (type == 3) {
            this.drawShapes = true;
            this.drawLines = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
    }

    public boolean isDrawShapes() {
        return this.drawShapes;
    }

    public void setDrawShapes(boolean draw) {
        if (draw != this.drawShapes) {
            this.drawShapes = draw;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean isDrawLines() {
        return this.drawLines;
    }

    public void setDrawLines(boolean draw) {
        if (draw != this.drawLines) {
            this.drawLines = draw;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getItemShapeFilled(int series, int item) {
        return this.getSeriesShapesFilled(series);
    }

    public boolean getSeriesShapesFilled(int series) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean flag = this.seriesShapesFilled.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.defaultShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean filled) {
        if (filled) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
    }

    public void setSeriesShapesFilled(int series, Boolean filled) {
        this.seriesShapesFilled.setBoolean(series, filled);
    }

    public void setSeriesShapesFilled(int series, boolean filled) {
        this.seriesShapesFilled.setBoolean(series, new Boolean(filled));
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean flag) {
        this.defaultShapesFilled = flag;
    }

    public void setDefaultShapesFilled(boolean flag) {
        this.setDefaultShapesFilled(new Boolean(flag));
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        Number previousValue;
        Number v = dataset.getValue(row, column);
        if (v == null) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double x1 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double value = v.doubleValue();
        double y1 = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        g2.setPaint(this.getItemPaint(row, column));
        g2.setStroke(this.getItemStroke(row, column));
        Shape shape = this.getItemShape(row, column);
        if (orientation == PlotOrientation.HORIZONTAL) {
            shape = this.createTransformedShape(shape, y1, x1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            shape = this.createTransformedShape(shape, x1, y1);
        }
        if (this.isDrawShapes()) {
            if (this.getItemShapeFilled(row, column)) {
                g2.fill(shape);
            } else {
                g2.draw(shape);
            }
        }
        if (this.isDrawLines() && column != 0 && (previousValue = dataset.getValue(row, column - 1)) != null) {
            double previous = previousValue.doubleValue();
            double x0 = domainAxis.getCategoryMiddle(column - 1, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            double y0 = rangeAxis.valueToJava2D(previous, dataArea, plot.getRangeAxisEdge());
            g2.setPaint(this.getItemPaint(row, column));
            g2.setStroke(this.getItemStroke(row, column));
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(y0, x0, y1, x1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(x0, y0, x1, y1);
            }
            g2.draw(line);
        }
        if (this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, orientation, dataset, row, column, x1, y1, value < 0.0);
        }
        if (state.getInfo() != null && (entities = state.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            String tip = null;
            CategoryToolTipGenerator tipster = this.getToolTipGenerator(row, column);
            if (tipster != null) {
                tip = tipster.generateToolTip(dataset, row, column);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity entity = new CategoryItemEntity(shape, tip, url, dataset, row, dataset.getColumnKey(column), column);
            entities.addEntity(entity);
        }
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof LineAndShapeRenderer) {
            LineAndShapeRenderer r = (LineAndShapeRenderer)obj;
            boolean b0 = r.drawLines == this.drawLines;
            boolean b1 = r.drawShapes == this.drawShapes;
            boolean b2 = ObjectUtils.equal((Object)r.shapesFilled, (Object)this.shapesFilled);
            boolean b3 = ObjectUtils.equal((Object)r.seriesShapesFilled, (Object)this.seriesShapesFilled);
            boolean b4 = ObjectUtils.equal((Object)r.defaultShapesFilled, (Object)this.defaultShapesFilled);
            result = result && b0 && b1 && b2 && b3 && b4;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        LineAndShapeRenderer clone = (LineAndShapeRenderer)super.clone();
        clone.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        return clone;
    }
}

