/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class XYShapeAnnotation
implements XYAnnotation,
Serializable {
    private Shape shape;
    private Stroke stroke;
    private Paint paint;

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint) {
        this.shape = shape;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        double m02 = domainAxis.valueToJava2D(0.0, dataArea, domainEdge);
        double m12 = rangeAxis.valueToJava2D(0.0, dataArea, rangeEdge);
        double m00 = domainAxis.valueToJava2D(1.0, dataArea, domainEdge) - m02;
        double m11 = rangeAxis.valueToJava2D(1.0, dataArea, rangeEdge) - m12;
        AffineTransform newTransform = new AffineTransform(m00, 0.0, 0.0, m11, m02, m12);
        Shape newShape = newTransform.createTransformedShape(this.shape);
        g2.setPaint(this.paint);
        g2.setStroke(this.stroke);
        g2.draw(newShape);
    }
}

