/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Common.MDLFile;
import AbinitMp.Common.MOL2File;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.XyzFile;
import AbinitMp.Display.ElectricFieldAssignValue;
import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.ElectricFieldAssignWindow;
import AbinitMp.Viewer.IsosurfaceValueWindow;
import AbinitMp.Viewer.SimpleKeyBehavior;
import AbinitMp.Viewer.TreePanel;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class FileItem {
    public Object file;
    public String filename;
    public String fullname;
    public int type;
    public boolean visible;
    public CoordInfo coordInfo;
    public TransformGroup transformGroup;
    public Switch directionAxisRoot;
    public BranchGroup directionAxisBrRoot;
    public BranchGroup sectionFileRootNode;
    public SimpleKeyBehavior keyBehavior;
    public IsosurfaceValue isosurfaceValue;
    public IsosurfaceValueWindow isosurfaceValueWindow;
    public ElectricFieldAssignValue electricFieldAssignValue;
    public ElectricFieldAssignWindow electricFieldAssignWindow;
    public TreePanel treePanel;

    public FileItem(Object object, String string, int n, boolean bl) {
        String string2 = new String(string);
        this.file = object;
        string2 = string2.replace('\\', '/');
        if (string2.lastIndexOf("/") != -1) {
            string2 = string2.substring(string2.lastIndexOf("/") + 1);
        }
        this.filename = string2;
        this.fullname = new String(string);
        this.type = n;
        this.visible = bl;
    }

    public void setPdbFileInfo(TransformGroup transformGroup, Switch switch_, BranchGroup branchGroup, SimpleKeyBehavior simpleKeyBehavior) {
        this.transformGroup = transformGroup;
        this.directionAxisRoot = switch_;
        this.directionAxisBrRoot = branchGroup;
        this.keyBehavior = simpleKeyBehavior;
    }

    public FileItem(FileItem fileItem) {
        this.filename = fileItem.filename;
        this.fullname = fileItem.fullname;
        this.file = fileItem.file;
        this.type = fileItem.type;
        this.visible = fileItem.visible;
        this.coordInfo = fileItem.coordInfo;
        this.transformGroup = fileItem.transformGroup;
        this.directionAxisRoot = fileItem.directionAxisRoot;
        this.directionAxisBrRoot = fileItem.directionAxisBrRoot;
        this.keyBehavior = fileItem.keyBehavior;
        this.sectionFileRootNode = fileItem.sectionFileRootNode;
        if (fileItem.isosurfaceValue != null) {
            this.isosurfaceValue = new IsosurfaceValue(fileItem.isosurfaceValue);
        }
        if (fileItem.electricFieldAssignValue != null) {
            this.electricFieldAssignValue = new ElectricFieldAssignValue(fileItem.electricFieldAssignValue);
        }
    }

    public void calcNewCoord(AbinitMpViewer abinitMpViewer) {
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D3 = new Transform3D();
        Transform3D transform3D4 = new Transform3D();
        Vector3d vector3d = new Vector3d();
        PdbFile pdbFile = this.getPdbFile();
        CoordInfo coordInfo = abinitMpViewer.getCoordInfo();
        this.transformGroup.getTransform(transform3D);
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = null;
            for (int j = 0; j < 2; ++j) {
                vector2 = j == 0 ? chainData.atomTable : chainData.hemTable;
                for (int k = 0; k < vector2.size(); ++k) {
                    AtomData atomData = (AtomData)vector2.get(k);
                    vector3d.set((double)atomData.coordX, (double)atomData.coordY, (double)atomData.coordZ);
                    transform3D3.setTranslation(vector3d);
                    transform3D4.mul(transform3D, transform3D3);
                    transform3D4.get(matrix4d);
                    atomData.x = (float)matrix4d.m03 + coordInfo.xcenter;
                    atomData.y = (float)matrix4d.m13 + coordInfo.ycenter;
                    atomData.z = (float)matrix4d.m23 + coordInfo.zcenter;
                }
            }
        }
    }

    public PdbFile getPdbFile() {
        PdbFile pdbFile = null;
        if (this.type == 4) {
            pdbFile = (PdbFile)this.file;
        } else if (this.type == 5) {
            pdbFile = ((CheckPointFile)this.file).pdbFile;
        } else if (this.type == 6) {
            pdbFile = ((MOL2File)this.file).pdbFile;
        } else if (this.type == 7) {
            pdbFile = ((MDLFile)this.file).pdbFile;
        } else if (this.type == 8 || this.type == 9 || this.type == 10) {
            pdbFile = ((GaussianCubeFile)this.file).pdbFile;
        } else if (this.type == 11) {
            pdbFile = ((XyzFile)this.file).pdbFile;
        } else if (this.type == 13) {
            TrajectoryFile trajectoryFile = (TrajectoryFile)this.file;
            pdbFile = trajectoryFile.getPdbFile();
        }
        return pdbFile;
    }
}

