/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.ColorData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Viewer.ArrowPreference;
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.vecmath.Color3f;

public class DisplayPreference {
    public static Color backgroundColor;
    public static ColorData[] fragmentColor;
    public static ColorData[] chainColor;
    public static ColorData[] fileColor;
    public static Color3f densityColor;
    public static Color3f moMinusColor;
    public static Color3f moPlusColor;
    public static int LINE_RESOLUTION;
    public static int CA_LINE_RESOLUTION;
    public static float BALL_RADIUS;
    public static float BALL_AND_STICK_RADIUS;
    public static int BALL_RESOLUTION;
    public static float STICK_RADIUS;
    public static int STICK_RESOLUTION;
    public static int CPK_RESOLUTION;
    public static float CA_TUBE_RADIUS;
    public static int CA_TUBE_RESOLUTION;
    public static int ROTATION_SPEED;
    public static float CONNECT_ATOM_SCALE;
    public static int CONNECT_ATOM_RADIUS;
    public static int PROJECTION;
    public static boolean glassless;
    public static ArrowPreference arrow;
    public static boolean stereo;
    public static boolean isNormalLine;
    public static boolean isPoligonLine;

    public static boolean openFile(String string) {
        try {
            ColorData colorData;
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            ROTATION_SPEED = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CONNECT_ATOM_SCALE = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            LINE_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CA_LINE_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            BALL_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            STICK_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CPK_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CA_TUBE_RESOLUTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            BALL_RADIUS = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            BALL_AND_STICK_RADIUS = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            STICK_RADIUS = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CA_TUBE_RADIUS = (float)streamTokenizer.nval;
            backgroundColor = DisplayPreference.getColor(streamTokenizer);
            for (n = 1; n < Constants.ATOM_NAME.length; ++n) {
                colorData = AtomInfoTable.getInfo(Constants.ATOM_NAME[n]);
                colorData.setColor(DisplayPreference.getColor(streamTokenizer));
            }
            for (n = 0; n < Constants.RESIDUE_NAME.length - 1; ++n) {
                colorData = (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[n]);
                if (colorData == null) {
                    colorData = (ColorData)ResidueInfoTable.get("OTHER");
                }
                colorData.setColor(DisplayPreference.getColor(streamTokenizer));
            }
            for (n = 0; n < fragmentColor.length; ++n) {
                fragmentColor[n].setColor(DisplayPreference.getColor(streamTokenizer));
            }
            for (n = 0; n < chainColor.length; ++n) {
                chainColor[n].setColor(DisplayPreference.getColor(streamTokenizer));
            }
            for (n = 0; n < fileColor.length; ++n) {
                fileColor[n].setColor(DisplayPreference.getColor(streamTokenizer));
            }
            for (n = 0; n < Constants.DNA_NAME.length; ++n) {
                colorData = (ColorData)ResidueInfoTable.get(Constants.DNA_NAME[n]);
                colorData.setColor(DisplayPreference.getColor(streamTokenizer));
            }
            densityColor.set(DisplayPreference.getColor(streamTokenizer));
            moMinusColor.set(DisplayPreference.getColor(streamTokenizer));
            moPlusColor.set(DisplayPreference.getColor(streamTokenizer));
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            PROJECTION = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            CONNECT_ATOM_RADIUS = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.display = streamTokenizer.sval.equals("true");
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.length = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.headRadius = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.bodyRadius = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.ratio = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.scale = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.min = (float)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.max = (float)streamTokenizer.nval;
            DisplayPreference.arrow.color = DisplayPreference.getColor(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.mode = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            DisplayPreference.arrow.colorMode = (int)streamTokenizer.nval;
            bufferedReader.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Preference File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
            return false;
        }
        return true;
    }

    private static Color getColor(StreamTokenizer streamTokenizer) throws Exception {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        int n = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        int n2 = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        int n3 = (int)streamTokenizer.nval;
        return new Color(n, n2, n3);
    }

    public static void saveFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            DisplayPreference.debugPrint(printStream);
            printStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Preference File save error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
            return;
        }
    }

    public static void debugPrint(PrintStream printStream) {
        int n;
        ColorData colorData;
        int n2;
        Date date = new Date();
        printStream.print("// Creation by BIO Station Viewer Version 5.01\n");
        printStream.print("// Preference file\n");
        printStream.print("// Date : " + date.toString() + "\n");
        printStream.print("\n// rotaion speed\n");
        printStream.print("ROTATION_SPEED    = " + ROTATION_SPEED + "\n");
        printStream.print("\n// connect atom\n");
        printStream.print("CONNECT_ATOM_SCALE   = " + CONNECT_ATOM_SCALE + "\n");
        printStream.print("\n// resolution\n");
        printStream.print("LINE_RESOLUTION   = " + LINE_RESOLUTION + "\n");
        printStream.print("CA_LINE_RESOLUTION= " + CA_LINE_RESOLUTION + "\n");
        printStream.print("BALL_RESOLUTION   = " + BALL_RESOLUTION + "\n");
        printStream.print("STICK_RESOLUTION  = " + STICK_RESOLUTION + "\n");
        printStream.print("CPK_RESOLUTION    = " + CPK_RESOLUTION + "\n");
        printStream.print("CA_TUBE_RESOLUTION   = " + CA_TUBE_RESOLUTION + "\n");
        printStream.print("\n// radius\n");
        printStream.print("BALL_RADIUS           = " + BALL_RADIUS + "\n");
        printStream.print("BALL_AND_STICK_RADIUS = " + BALL_AND_STICK_RADIUS + "\n");
        printStream.print("STICK_RADIUS          = " + STICK_RADIUS + "\n");
        printStream.print("CA_TUBE_RADIUS        = " + CA_TUBE_RADIUS + "\n");
        printStream.print("\n// backgroung color\n");
        printStream.print("backgroundColor  = ");
        DisplayPreference.printColor(printStream, backgroundColor);
        printStream.print("\n// atom color\n");
        for (n2 = 1; n2 < Constants.ATOM_NAME.length; ++n2) {
            colorData = AtomInfoTable.getInfo(Constants.ATOM_NAME[n2]);
            printStream.print(Constants.ATOM_NAME[n2] + " = ");
            DisplayPreference.printColor(printStream, colorData.color.get());
        }
        printStream.print("\n// residue color\n");
        for (n2 = 0; n2 < Constants.RESIDUE_NAME.length - 2; ++n2) {
            colorData = (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[n2]);
            printStream.print(Constants.RESIDUE_NAME[n2] + " = ");
            DisplayPreference.printColor(printStream, colorData.color.get());
        }
        ColorData colorData2 = (ColorData)ResidueInfoTable.get("OTHER");
        printStream.print(Constants.RESIDUE_NAME[Constants.RESIDUE_NAME.length - 2] + " = ");
        DisplayPreference.printColor(printStream, colorData2.color.get());
        printStream.print("\n// fragment color\n");
        for (n = 0; n < fragmentColor.length; ++n) {
            printStream.print("No" + (n + 1) + " = ");
            DisplayPreference.printColor(printStream, DisplayPreference.fragmentColor[n].color.get());
        }
        printStream.print("\n// chain color\n");
        for (n = 0; n < chainColor.length; ++n) {
            printStream.print("No" + (n + 1) + " = ");
            DisplayPreference.printColor(printStream, DisplayPreference.chainColor[n].color.get());
        }
        printStream.print("\n// file color\n");
        for (n = 0; n < fileColor.length; ++n) {
            printStream.print("No" + (n + 1) + " = ");
            DisplayPreference.printColor(printStream, DisplayPreference.fileColor[n].color.get());
        }
        printStream.print("\n// DNA color\n");
        for (n = 0; n < Constants.DNA_NAME.length; ++n) {
            ColorData colorData3 = (ColorData)ResidueInfoTable.get(Constants.DNA_NAME[n]);
            printStream.print(Constants.DNA_NAME[n] + " = ");
            DisplayPreference.printColor(printStream, colorData3.color.get());
        }
        printStream.print("\n// isosurface color\n");
        printStream.print("Density = ");
        DisplayPreference.printColor(printStream, densityColor.get());
        printStream.print("MoMinus = ");
        DisplayPreference.printColor(printStream, moMinusColor.get());
        printStream.print("MoPlus = ");
        DisplayPreference.printColor(printStream, moPlusColor.get());
        printStream.print("\n// projection\n");
        printStream.print("PROJECTION   = " + PROJECTION + "\n");
        printStream.print("\n// connect radius\n");
        printStream.print("ConnectRadius   = " + CONNECT_ATOM_RADIUS + "\n");
        printStream.print("\n// arrow\n");
        printStream.print("ArrowDisplay   = " + DisplayPreference.arrow.display + "\n");
        printStream.print("ArrowLength    = " + DisplayPreference.arrow.length + "\n");
        printStream.print("ArrowHeadRadius    = " + DisplayPreference.arrow.headRadius + "\n");
        printStream.print("ArrowBodyRadius    = " + DisplayPreference.arrow.bodyRadius + "\n");
        printStream.print("ArrowRatio     = " + DisplayPreference.arrow.ratio + "\n");
        printStream.print("ArrowScale     = " + DisplayPreference.arrow.scale + "\n");
        printStream.print("ArrowMin       = " + DisplayPreference.arrow.min + "\n");
        printStream.print("ArrowMax       = " + DisplayPreference.arrow.max + "\n");
        printStream.print("ArrowColor     = ");
        DisplayPreference.printColor(printStream, DisplayPreference.arrow.color);
        printStream.print("ArrowMode      = " + DisplayPreference.arrow.mode + "\n");
        printStream.print("ArrowColorMode = " + DisplayPreference.arrow.colorMode + "\n");
    }

    private static void printColor(PrintStream printStream, Color color) {
        printStream.print(color.getRed() + " " + color.getGreen() + " " + color.getBlue() + "\n");
    }

    public static void setDefaults() {
        backgroundColor = new Color(0, 0, 0);
        fragmentColor = new ColorData[]{new ColorData(244, 0, 120), new ColorData(102, 102, 255), new ColorData(153, 244, 51), new ColorData(251, 125, 0), new ColorData(0, 204, 204), new ColorData(204, 0, 255), new ColorData(0, 204, 0), new ColorData(169, 133, 24)};
        chainColor = new ColorData[]{new ColorData(244, 0, 120), new ColorData(102, 102, 255), new ColorData(153, 244, 51), new ColorData(251, 125, 0), new ColorData(0, 204, 204), new ColorData(204, 0, 255), new ColorData(0, 204, 0), new ColorData(169, 133, 24)};
        fileColor = new ColorData[]{new ColorData(244, 0, 120), new ColorData(102, 102, 255), new ColorData(153, 244, 51), new ColorData(251, 125, 0), new ColorData(0, 204, 204), new ColorData(204, 0, 255), new ColorData(0, 204, 0), new ColorData(169, 133, 24)};
        densityColor = new Color3f(0.0f, 1.0f, 0.0f);
        moMinusColor = new Color3f(0.19607843f, 0.19607843f, 1.0f);
        moPlusColor = new Color3f(1.0f, 0.19607843f, 0.19607843f);
        CONNECT_ATOM_SCALE = 1.0f;
        CONNECT_ATOM_RADIUS = 0;
        LINE_RESOLUTION = 1;
        CA_LINE_RESOLUTION = 3;
        BALL_RADIUS = 0.36f;
        BALL_AND_STICK_RADIUS = 0.1f;
        BALL_RESOLUTION = 8;
        STICK_RADIUS = 0.15f;
        STICK_RESOLUTION = 8;
        CPK_RESOLUTION = 32;
        CA_TUBE_RADIUS = 0.3f;
        CA_TUBE_RESOLUTION = 16;
        ROTATION_SPEED = 20000;
        PROJECTION = 0;
        glassless = false;
        arrow.setDefaults();
    }

    static {
        arrow = new ArrowPreference();
        stereo = false;
        isNormalLine = false;
        isPoligonLine = false;
        DisplayPreference.setDefaults();
    }
}

