/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.CpfAtomData;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.AtomTableElement;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Common.MDLFile;
import AbinitMp.Common.MOL2File;
import AbinitMp.Common.ResidueData;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Common.SsData;
import AbinitMp.Common.XyzFile;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PdbFile {
    public String filename = null;
    public Vector chains;
    public boolean hasVector = false;

    public PdbFile(String string) {
        this.readFile(string);
    }

    public void readFile(String string) {
        this.initTable();
        this.createAtomTable(string);
        for (int i = 0; i < this.chains.size(); ++i) {
            ChainData chainData = (ChainData)this.chains.get(i);
            this.createResidueTable(chainData.atomTable, chainData.residueTable);
            this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
        }
        this.insideCheck();
    }

    private void initTable() {
        this.filename = null;
        this.chains = new Vector();
    }

    private void createAtomTable(String string) {
        try {
            float f;
            AtomData atomData;
            AtomData atomData2;
            int n;
            int n2;
            int n3;
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = null;
            AtomData atomData3 = null;
            String string4 = "@@@";
            this.chains = new Vector();
            ChainData chainData = new ChainData();
            Vector vector = chainData.atomTable;
            Vector vector2 = chainData.hemTable;
            Vector vector3 = chainData.ssTable;
            Vector<Integer> vector4 = new Vector<Integer>();
            while ((string2 = bufferedReader.readLine()) != null) {
                String string5 = " ";
                String string6 = " ";
                String string7 = " ";
                float f2 = 0.0f;
                float f3 = 0.0f;
                String string8 = "    ";
                String string9 = "  ";
                String string10 = "  ";
                if (string2.length() >= 6 || string2.length() >= 3 && (string2.substring(0, 3).equalsIgnoreCase("TER") || string2.substring(0, 3).equalsIgnoreCase("END"))) {
                    string3 = string2.substring(0, 3).equalsIgnoreCase("TER") || string2.substring(0, 3).equalsIgnoreCase("END") ? string2.substring(0, 3) : string2.substring(0, 6).trim();
                    if (string3.equalsIgnoreCase("ATOM") || string3.equalsIgnoreCase("HETATM")) {
                        int n4;
                        int n5 = Integer.parseInt(string2.substring(6, 11).trim());
                        String string11 = string2.substring(12, 16).trim();
                        if (string11.equalsIgnoreCase("LP")) continue;
                        string5 = string2.substring(16, 17);
                        String string12 = string2.substring(17, 20).trim();
                        string6 = string2.substring(21, 22);
                        try {
                            n4 = Integer.parseInt(string2.substring(22, 26).trim());
                        }
                        catch (Exception exception) {
                            n4 = 1;
                        }
                        string7 = string2.substring(26, 27);
                        float f4 = Float.parseFloat(string2.substring(30, 38));
                        float f5 = Float.parseFloat(string2.substring(38, 46));
                        float f6 = Float.parseFloat(string2.substring(46, 54));
                        int n6 = string2.indexOf("//");
                        if (n6 != -1) {
                            string2 = string2.substring(0, n6);
                        }
                        if ((n6 = string2.length()) >= 60) {
                            if (string2.substring(54, 60).trim().length() != 0) {
                                f2 = Float.parseFloat(string2.substring(54, 60));
                            }
                            if (n6 >= 66) {
                                if (string2.substring(60, 66).trim().length() != 0) {
                                    f3 = Float.parseFloat(string2.substring(60, 66));
                                }
                                if (n6 >= 76) {
                                    string8 = string2.substring(72, 76);
                                    if (n6 >= 78) {
                                        string9 = string2.substring(76, 78);
                                        if (n6 >= 80 && string2.substring(78, 80).trim().length() != 0) {
                                            string10 = string2.substring(78, 80);
                                        }
                                    }
                                }
                            }
                        }
                        if (string5.charAt(0) != ' ' && string5.charAt(0) != 'A') continue;
                        String string13 = this.getAtomName(string11);
                        atomData3 = new AtomData(n5, string13, string11, string5, string12, string6, n4, string7, f4, f5, f6, f2, f3, string8, string9, string10);
                        if (ResidueInfoTable.isHem(string12.toUpperCase())) {
                            vector.add(atomData3);
                            if (!string12.equalsIgnoreCase("CYS") || !string11.equalsIgnoreCase("SG")) continue;
                            vector4.add(new Integer(vector.size() - 1));
                            continue;
                        }
                        vector2.add(atomData3);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("TER")) continue;
                    for (int i = 0; i < vector4.size(); ++i) {
                        for (n3 = i + 1; n3 < vector4.size(); ++n3) {
                            n2 = (Integer)vector4.get(i);
                            n = (Integer)vector4.get(n3);
                            atomData2 = (AtomData)vector.get(n2);
                            atomData = (AtomData)vector.get(n);
                            f = (atomData2.x - atomData.x) * (atomData2.x - atomData.x) + (atomData2.y - atomData.y) * (atomData2.y - atomData.y) + (atomData2.z - atomData.z) * (atomData2.z - atomData.z);
                            if (!(9.0f > f)) continue;
                            vector3.add(new SsData(n2, n, f));
                        }
                    }
                    chainData.id = atomData3.chain;
                    this.chains.add(chainData);
                    string4 = atomData3.chain;
                    chainData = new ChainData();
                    vector = chainData.atomTable;
                    vector2 = chainData.hemTable;
                    vector3 = chainData.ssTable;
                    vector4 = new Vector();
                    continue;
                }
                if (string2.equals("") || string2.trim().equalsIgnoreCase("END")) continue;
                System.out.println("Illegal format pdb file.(" + string2 + ")");
            }
            if (0 != vector.size() || 0 != vector2.size()) {
                for (int i = 0; i < vector4.size(); ++i) {
                    for (n3 = i + 1; n3 < vector4.size(); ++n3) {
                        n2 = (Integer)vector4.get(i);
                        n = (Integer)vector4.get(n3);
                        atomData2 = (AtomData)vector.get(n2);
                        atomData = (AtomData)vector.get(n);
                        f = (atomData2.x - atomData.x) * (atomData2.x - atomData.x) + (atomData2.y - atomData.y) * (atomData2.y - atomData.y) + (atomData2.z - atomData.z) * (atomData2.z - atomData.z);
                        if (!(9.0f > f)) continue;
                        vector3.add(new SsData(n2, n, f));
                    }
                }
                chainData.id = atomData3.chain;
                this.chains.add(chainData);
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Pdb file read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    private void createResidueTable(Vector vector, Vector vector2) {
        if (vector.size() == 0) {
            return;
        }
        int n = -999;
        AtomData atomData = null;
        ResidueData residueData = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            atomData = (AtomData)vector.get(i);
            if (atomData.residueNo != n || string2 != null && !string2.equals(atomData.iCode) || !string.equals(atomData.residueName)) {
                if (residueData != null) {
                    residueData.setEndNo(i - 1);
                    if (residueData.startNo == 0) {
                        residueData.calcNTermCharge(vector);
                    } else {
                        residueData.calcCharge(vector);
                    }
                    vector2.add(residueData);
                }
                residueData = new ResidueData(atomData.residueNo, atomData.residueName, 0.0f, i, 0, atomData, vector);
                n = atomData.residueNo;
                string = atomData.residueName;
                string2 = atomData.iCode;
            }
            atomData.residueData = residueData;
        }
        residueData.setEndNo(vector.size() - 1);
        residueData.calcCTermCharge(vector);
        vector2.add(residueData);
    }

    private String getAtomName(String string) {
        String string2 = new String(string);
        char c = string2.charAt(0);
        if (Character.isDigit(c)) {
            string2 = string2.substring(1);
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (!Character.isDigit(string2.charAt(i))) continue;
            string2 = string2.substring(0, i);
            --i;
        }
        if (null == AtomInfoTable.get(string2)) {
            c = string2.charAt(0);
            string2 = 'H' == c || 'O' == c || 'C' == c || 'N' == c || string2.equalsIgnoreCase("SG") || string2.equalsIgnoreCase("SD") || string2.length() == 1 ? string2.substring(0, 1) : string2.substring(0, 2);
        }
        return string2;
    }

    public PdbFile(CheckPointFile checkPointFile) {
        this.initTable();
        this.filename = checkPointFile.filename;
        ChainData chainData = new ChainData();
        chainData.id = "CPF";
        for (int i = 0; i < checkPointFile.numberOfAtom; ++i) {
            int n;
            CpfAtomData cpfAtomData = (CpfAtomData)checkPointFile.cpfAtomDatas.get(i);
            if (!chainData.id.equals(cpfAtomData.chain)) {
                if (chainData.atomTable.size() != 0 || chainData.hemTable.size() != 0) {
                    this.createResidueTable(chainData.atomTable, chainData.residueTable);
                    this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
                    this.chains.add(chainData);
                }
                chainData = new ChainData();
                chainData.id = cpfAtomData.chain;
            }
            for (n = 0; n < Constants.RESIDUE_NAME.length && !cpfAtomData.residueName.equalsIgnoreCase(Constants.RESIDUE_NAME[n]); ++n) {
            }
            AtomData atomData = new AtomData(cpfAtomData.atomNo, cpfAtomData.atomName, cpfAtomData.atomType, " ", cpfAtomData.residueName, cpfAtomData.chain, cpfAtomData.residueNo, cpfAtomData.iCode, cpfAtomData.x, cpfAtomData.y, cpfAtomData.z, 0.0f, 0.0f, "    ", "  ", "  ", cpfAtomData.fragmentNo, cpfAtomData.mulliken);
            if (n != Constants.RESIDUE_NAME.length) {
                chainData.atomTable.add(atomData);
                continue;
            }
            chainData.hemTable.add(atomData);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
        this.chains.add(chainData);
        this.insideCheck();
    }

    public PdbFile(MDLFile mDLFile) {
        this.initTable();
        this.filename = mDLFile.filename;
        ChainData chainData = new ChainData();
        this.chains.add(chainData);
        chainData.id = "CPF";
        for (int i = 0; i < mDLFile.numberOfAtom; ++i) {
            AtomData atomData = new AtomData(i + 1, mDLFile.atomName[i], this.getAtomName(mDLFile.atomName[i]), " ", "UNK", "CPF", 1, " ", mDLFile.x[i], mDLFile.y[i], mDLFile.z[i], 0.0f, 0.0f, "    ", "  ", "  ");
            chainData.atomTable.add(atomData);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
        this.insideCheck();
    }

    public PdbFile(MOL2File mOL2File) {
        this.initTable();
        this.filename = mOL2File.filename;
        ChainData chainData = new ChainData();
        this.chains.add(chainData);
        chainData.id = "CPF";
        for (int i = 0; i < mOL2File.numberOfAtom; ++i) {
            AtomData atomData = new AtomData(mOL2File.atomNo[i], this.getAtomName(mOL2File.atomName[i]), mOL2File.atomName[i], " ", mOL2File.residueName[i], "CPF", mOL2File.residueNo[i], " ", mOL2File.x[i], mOL2File.y[i], mOL2File.z[i], 0.0f, 0.0f, "    ", "  ", "  ");
            chainData.atomTable.add(atomData);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
        this.insideCheck();
    }

    public PdbFile(XyzFile xyzFile) {
        this.initTable();
        this.filename = xyzFile.filename;
        ChainData chainData = new ChainData();
        this.chains.add(chainData);
        chainData.id = "CPF";
        for (int i = 0; i < xyzFile.no; ++i) {
            AtomData atomData = new AtomData(i + 1, xyzFile.atomName[i], xyzFile.atomName[i], " ", "None", "CPF", 1, " ", xyzFile.x[i], xyzFile.y[i], xyzFile.z[i], 0.0f, 0.0f, "    ", "  ", "  ");
            AtomTableElement atomTableElement = (AtomTableElement)AtomInfoTable.data.get(xyzFile.atomName[i].toUpperCase());
            atomData.atomNo = atomTableElement.no;
            if (xyzFile.hasVector) {
                atomData.setVector(xyzFile.vx[i], xyzFile.vy[i], xyzFile.vz[i], xyzFile.vLength[i]);
            }
            chainData.atomTable.add(atomData);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.insideCheck();
        this.hasVector = xyzFile.hasVector;
    }

    public PdbFile(String string, String[] stringArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.initTable();
        this.filename = string;
        ChainData chainData = new ChainData();
        this.chains.add(chainData);
        chainData.id = "CPF";
        for (int i = 0; i < fArray.length; ++i) {
            AtomData atomData = new AtomData(i + 1, stringArray[i], stringArray[i], " ", "None", "CPF", 1, " ", fArray[i], fArray2[i], fArray3[i], 0.0f, 0.0f, "    ", "  ", "  ");
            AtomTableElement atomTableElement = (AtomTableElement)AtomInfoTable.data.get(stringArray[i].toUpperCase());
            atomData.atomNo = atomTableElement.no;
            chainData.atomTable.add(atomData);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.insideCheck();
    }

    public PdbFile(GaussianCubeFile gaussianCubeFile) {
        this.initTable();
        this.filename = gaussianCubeFile.filename;
        ChainData chainData = new ChainData();
        this.chains.add(chainData);
        int n = gaussianCubeFile.getNumberOfAtom();
        int[] nArray = gaussianCubeFile.getAtomNo();
        float[] fArray = gaussianCubeFile.getCoordX();
        float[] fArray2 = gaussianCubeFile.getCoordY();
        float[] fArray3 = gaussianCubeFile.getCoordZ();
        chainData.id = "CPF";
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            String string = null;
            Object object = AtomInfoTable.data.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                AtomTableElement atomTableElement = (AtomTableElement)AtomInfoTable.data.get(string);
                if (atomTableElement.no != nArray[i]) continue;
            }
            object = new AtomData(i + 1, string, string, " ", "UNK", "CPF", 1, " ", fArray[i], fArray2[i], fArray3[i], 0.0f, 0.0f, "    ", "  ", "  ");
            ((AtomData)object).atomNo = nArray[i];
            chainData.atomTable.add(object);
        }
        this.createResidueTable(chainData.atomTable, chainData.residueTable);
        this.createResidueTable(chainData.hemTable, chainData.hemResidueTable);
        this.insideCheck();
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("PDB file (" + this.filename + ")");
        for (int i = 0; i < this.chains.size(); ++i) {
            ((ChainData)this.chains.get(i)).debugPrint(printStream);
        }
    }

    public void insideCheck() {
        int[] nArray = new int[8];
        for (int i = 0; i < this.chains.size(); ++i) {
            ChainData chainData = (ChainData)this.chains.get(i);
            Vector vector = chainData.atomTable;
            Vector vector2 = chainData.residueTable;
            block1: for (int j = 0; j < vector2.size(); ++j) {
                ResidueData residueData = (ResidueData)vector2.get(j);
                for (int k = residueData.startNo; k < residueData.endNo; ++k) {
                    int n;
                    AtomData atomData = (AtomData)vector.get(k);
                    for (n = 0; n < 8; ++n) {
                        nArray[n] = 0;
                    }
                    for (n = 0; n < this.chains.size() && !residueData.isMolecularSurface; ++n) {
                        ChainData chainData2 = (ChainData)this.chains.get(n);
                        Vector vector3 = chainData2.atomTable;
                        Vector vector4 = chainData2.residueTable;
                        for (int i2 = 0; i2 < vector4.size() && !residueData.isMolecularSurface; ++i2) {
                            AtomData atomData2;
                            AtomData atomData3;
                            ResidueData residueData2 = (ResidueData)vector4.get(i2);
                            if (residueData == residueData2 || !((atomData3 = (AtomData)vector.get(residueData.startNo)).distance2(atomData2 = (AtomData)vector3.get(residueData2.startNo)) < 100.0f)) continue;
                            for (int i3 = residueData2.startNo; i3 < residueData2.endNo; ++i3) {
                                AtomData atomData4 = (AtomData)vector3.get(i3);
                                if (!(atomData.distance2(atomData4) < 49.0f)) continue;
                                nArray[this.direction((AtomData)atomData, (AtomData)atomData4)] = 1;
                            }
                        }
                    }
                    n = 0;
                    for (int i4 = 0; i4 < 8; ++i4) {
                        n += nArray[i4];
                    }
                    if (n > 7) continue;
                    residueData.isMolecularSurface = true;
                    continue block1;
                }
            }
        }
    }

    private int direction(AtomData atomData, AtomData atomData2) {
        float f = atomData.x - atomData2.x;
        float f2 = atomData.y - atomData2.y;
        float f3 = atomData.z - atomData2.z;
        int n = 0;
        n = f > 0.0f ? (f2 > 0.0f ? (f3 > 0.0f ? 3 : 2) : (f3 > 0.0f ? 1 : 0)) : (f2 > 0.0f ? (f3 > 0.0f ? 7 : 6) : (f3 > 0.0f ? 5 : 4));
        return n;
    }

    public static void main(String[] stringArray) {
        PdbFile pdbFile = new PdbFile(stringArray[0]);
        pdbFile.insideCheck();
    }
}

