/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.AbinitMpFile;

import AbinitMp.AbinitMpFile.TrjStringTokenizer;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.XyzFile;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.MySwitchValueInterpolator;
import AbinitMp.Viewer.TrajectoryControlWindow;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Switch;
import javax.swing.JOptionPane;

public class TrajectoryFile {
    public static final int XYZ_FILE = 0;
    public static final int XYZ2_FILE = 1;
    public static final int XYZ_NO_ENERGY_FILE = 2;
    public static final int XYZ2_NO_ENERGY_FILE = 3;
    public static final int PEACH_FILE = 4;
    public String filename = null;
    public int type;
    public Vector files;
    public FileItem structureFile;
    public int stepNum;
    private Switch trajectoryRoot;
    private Alpha alpha;
    private MySwitchValueInterpolator sinterp;
    private TrajectoryControlWindow trajectoryControlWindow;
    public boolean hasVector = false;
    public float[][] data;
    public String[] dataLabel = null;
    public String[] stepLabel = null;
    public int dataNum = 0;
    public int labelIndex = -1;

    public TrajectoryFile(String string, FileItem fileItem) {
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        this.files = new Vector();
        if (string2.equals("trj")) {
            this.type = 0;
            this.readXYZFile(string);
        } else if (string2.equals("tj2") || string2.equals("tr2") || string2.equals("trj2")) {
            this.type = 1;
            this.readXYZ2File(string);
        } else {
            this.structureFile = fileItem;
            this.type = 4;
        }
    }

    public void readXYZFile(String string) {
        int n = 0;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            string2 = this.readLine(bufferedReader);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            n = Integer.parseInt(stringTokenizer.nextToken());
            while ((string2 = this.readLine(bufferedReader)) != null) {
                n2 = 0;
                ++this.stepNum;
                String[] stringArray = new String[n];
                float[] fArray = new float[n];
                float[] fArray2 = new float[n];
                float[] fArray3 = new float[n];
                stringTokenizer = new StringTokenizer(string2);
                vector.add(stringTokenizer.nextToken());
                while (n2 < n) {
                    String string3;
                    string2 = this.readLine(bufferedReader);
                    stringTokenizer = new StringTokenizer(string2);
                    if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken()).equals("//") || string3.equals("#")) continue;
                    stringArray[n2] = string3;
                    fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
                    fArray2[n2] = Float.parseFloat(stringTokenizer.nextToken());
                    fArray3[n2] = Float.parseFloat(stringTokenizer.nextToken());
                    ++n2;
                }
                this.files.add(new PdbFile(string, stringArray, fArray, fArray2, fArray3));
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
            this.dataNum = 1;
            this.dataLabel = new String[this.dataNum];
            this.dataLabel[0] = "Energy";
            this.data = new float[this.stepNum][1];
            for (n2 = 0; n2 < this.stepNum; ++n2) {
                this.data[n2][0] = Float.parseFloat((String)vector.get(n2));
            }
            if (this.data[0][0] == 0.0f && this.data[1][0] == 0.0f) {
                this.type = 2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new Frame(), "Trajectory file read error (" + string + ").\n" + exception.getMessage() + "\n" + string2, "Error message", 0);
        }
    }

    public void readXYZ2File(String string) {
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        float[] fArray5 = null;
        float[] fArray6 = null;
        float[] fArray7 = null;
        int n = 0;
        String string2 = null;
        Vector[] vectorArray = null;
        try {
            int n2;
            int n3;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = this.readLine(bufferedReader)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                n = Integer.parseInt(stringTokenizer.nextToken());
                string2 = this.readLine(bufferedReader);
                if (string2 == null) break;
                n3 = 0;
                ++this.stepNum;
                String[] stringArray = new String[n];
                fArray = new float[n];
                fArray2 = new float[n];
                fArray3 = new float[n];
                TrjStringTokenizer trjStringTokenizer = new TrjStringTokenizer(string2);
                if (this.dataLabel == null) {
                    this.dataNum = trjStringTokenizer.howManyTokens() / 2;
                    if (this.dataNum != 0) {
                        this.dataLabel = new String[this.dataNum];
                        vectorArray = new Vector[this.dataNum];
                        for (n2 = 0; n2 < this.dataNum; ++n2) {
                            vectorArray[n2] = new Vector();
                            this.dataLabel[n2] = trjStringTokenizer.nextToken();
                            if (this.dataLabel[n2].equalsIgnoreCase("label")) {
                                this.labelIndex = n2;
                            }
                            trjStringTokenizer.nextToken();
                        }
                        trjStringTokenizer.rewind();
                    }
                }
                for (n2 = 0; n2 < this.dataNum; ++n2) {
                    trjStringTokenizer.nextToken();
                    vectorArray[n2].add(trjStringTokenizer.nextToken());
                }
                while (n3 < n) {
                    String string3;
                    string2 = this.readLine(bufferedReader);
                    stringTokenizer = new StringTokenizer(string2);
                    if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken()).equals("//") || string3.equals("#")) continue;
                    stringArray[n3] = string3;
                    fArray[n3] = Float.parseFloat(stringTokenizer.nextToken());
                    fArray2[n3] = Float.parseFloat(stringTokenizer.nextToken());
                    fArray3[n3] = Float.parseFloat(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        if (n3 == 0) {
                            fArray4 = new float[n];
                            fArray5 = new float[n];
                            fArray6 = new float[n];
                            fArray7 = new float[n];
                            this.hasVector = true;
                        }
                        fArray4[n3] = Float.parseFloat(stringTokenizer.nextToken());
                        fArray5[n3] = Float.parseFloat(stringTokenizer.nextToken());
                        fArray6[n3] = Float.parseFloat(stringTokenizer.nextToken());
                        fArray7[n3] = (float)Math.sqrt(fArray4[n3] * fArray4[n3] + fArray5[n3] * fArray5[n3] + fArray6[n3] * fArray6[n3]);
                    }
                    ++n3;
                }
                this.files.add(new XyzFile(string, n, stringArray, fArray, fArray2, fArray3, fArray4, fArray5, fArray6, fArray7, this.hasVector));
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
            if (this.dataNum != 0) {
                this.data = new float[this.stepNum][this.dataNum];
                this.stepLabel = new String[this.stepNum];
                for (n3 = 0; n3 < this.stepNum; ++n3) {
                    for (n2 = 0; n2 < this.dataNum; ++n2) {
                        if (n2 != this.labelIndex) {
                            this.data[n3][n2] = Float.parseFloat((String)vectorArray[n2].get(n3));
                            continue;
                        }
                        this.stepLabel[n3] = (String)vectorArray[n2].get(n3);
                    }
                }
                if (this.dataNum == 1 && this.labelIndex != -1) {
                    this.type = 3;
                }
            } else {
                this.type = 3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new Frame(), "Trajectory file(2) read error (" + string + ").\n" + exception.getMessage() + "\n" + string2, "Error message", 0);
        }
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        StringTokenizer stringTokenizer;
        String string;
        String string2;
        while ((string2 = bufferedReader.readLine()) != null && ((string = (stringTokenizer = new StringTokenizer(string2)).nextToken()).equals("//") || string.equals("#"))) {
        }
        return string2;
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("trajectory file (" + this.filename + ")");
        System.out.println("step num " + this.stepNum);
        for (int i = 0; i < this.stepNum; ++i) {
            PdbFile pdbFile = (PdbFile)this.files.get(i);
            System.out.println("energy  " + this.data[i][0]);
            pdbFile.debugPrint(printStream);
        }
    }

    public void debugPrintData(PrintStream printStream) {
        int n;
        printStream.println("trajectory2 file data (" + this.filename + ")");
        System.out.println("step num " + this.stepNum);
        for (n = 0; n < this.dataNum; ++n) {
            System.out.print(this.dataLabel[n] + " ");
        }
        System.out.println(" ");
        for (n = 0; n < this.stepNum; ++n) {
            System.out.print(this.stepLabel[n] + " ");
            for (int i = 0; i < this.dataNum; ++i) {
                System.out.print(this.data[n][i] + " ");
            }
            System.out.println(" ");
        }
    }

    public Switch getTrajectoryRoot() {
        return this.trajectoryRoot;
    }

    public void setTrajectoryRoot(Switch switch_) {
        this.trajectoryRoot = switch_;
    }

    public TrajectoryControlWindow getTrajectoryControlWindow() {
        return this.trajectoryControlWindow;
    }

    public void setTrajectoryControlWindow(TrajectoryControlWindow trajectoryControlWindow) {
        this.trajectoryControlWindow = trajectoryControlWindow;
    }

    public Alpha getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Alpha alpha) {
        this.alpha = alpha;
    }

    public MySwitchValueInterpolator getInterpolator() {
        return this.sinterp;
    }

    public void setInterpolator(MySwitchValueInterpolator mySwitchValueInterpolator) {
        this.sinterp = mySwitchValueInterpolator;
    }

    public PdbFile getPdbFile() {
        PdbFile pdbFile = this.type == 4 ? this.structureFile.getPdbFile() : (this.type == 1 || this.type == 3 ? ((XyzFile)this.files.get((int)0)).pdbFile : (PdbFile)this.files.get(0));
        return pdbFile;
    }

    public PdbFile getPdbFile(int n) {
        PdbFile pdbFile = this.type == 4 ? this.structureFile.getPdbFile() : (this.type == 1 || this.type == 3 ? ((XyzFile)this.files.get((int)n)).pdbFile : (PdbFile)this.files.get(n));
        return pdbFile;
    }

    public static void main(String[] stringArray) {
        TrajectoryFile trajectoryFile = new TrajectoryFile(stringArray[0], null);
        trajectoryFile.debugPrint(System.out);
    }
}

