/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting;

import ciss.phase_viewer.ssh.hosts.HostInfo;
import java.io.File;
import org.apache.log4j.Logger;

public class ScriptWrapper {
    public static Logger logger = Logger.getLogger(ScriptWrapper.class.getName());
    public static String BAT = "bat";
    public static String SH = "sh";
    public static String BSH = "bsh";
    public static String[] REGISTERED_SCRIPT_TYPE = new String[]{BAT, SH, BSH};
    private String file;
    private String scriptType = SH;

    public ScriptWrapper(String file) {
        this.file = file;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.scriptType = BAT;
        }
    }

    public ScriptWrapper(String file, String type) {
        this.file = file;
        this.scriptType = type != null && (type.equals(SH) || type.equals(BSH) || type.equals(BAT)) ? type : (System.getProperty("os.name").toLowerCase().startsWith("windows") ? BAT : SH);
    }

    public String toString() {
        return new File(this.file).getName();
    }

    public String getPath() {
        return this.file;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public static String getTypeFromFile(String file) {
        if (file == null) {
            return null;
        }
        String[] split = file.trim().split("\\.");
        String type = SH;
        if (split != null && split.length >= 2) {
            if (split[split.length - 1].equalsIgnoreCase("bsh")) {
                type = BSH;
            } else if (split[split.length - 1].equalsIgnoreCase("bat")) {
                type = BAT;
            }
        }
        return type;
    }

    public static String[] getValidScriptType(HostInfo hostInfo) {
        if (hostInfo.isLocalHost() && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return new String[]{BAT, BSH};
        }
        return new String[]{SH, BSH};
    }
}

