/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.pub.primitivegui;

import ciss.phase_viewer.pub.primitivegui.JMultiLineToolTip;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import org.apache.log4j.Logger;

class MultiLineToolTipUI
extends BasicToolTipUI {
    private static Logger logger = Logger.getLogger(MultiLineToolTipUI.class.getName());
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    Font smallFont;
    static JToolTip tip;
    protected CellRendererPane rendererPane;
    private static JTextArea textArea;

    public static ComponentUI createUI(JComponent c2) {
        logger.debug("at createUI");
        return sharedInstance;
    }

    public MultiLineToolTipUI() {
        logger.debug("at constructor...");
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        tip = (JToolTip)c2;
        this.rendererPane = new CellRendererPane();
        c2.add(this.rendererPane);
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        c2.remove(this.rendererPane);
        this.rendererPane = null;
    }

    public void paint(Graphics g, JComponent c2) {
        logger.debug("painting: " + textArea.getText());
        Dimension size = c2.getSize();
        textArea.setBackground(c2.getBackground());
        this.rendererPane.paintComponent(g, textArea, c2, 1, 1, size.width - 1, size.height - 1, true);
    }

    public Dimension getPreferredSize(JComponent c2) {
        String tipText = ((JToolTip)c2).getTipText();
        logger.debug("tipText: " + tipText);
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        textArea = new JTextArea(tipText);
        this.rendererPane.removeAll();
        this.rendererPane.add(textArea);
        textArea.setWrapStyleWord(true);
        int width = ((JMultiLineToolTip)c2).getFixedWidth();
        int columns = ((JMultiLineToolTip)c2).getColumns();
        if (columns > 0) {
            textArea.setColumns(columns);
            textArea.setSize(0, 0);
            textArea.setLineWrap(true);
            textArea.setSize(textArea.getPreferredSize());
        } else if (width > 0) {
            textArea.setLineWrap(true);
            Dimension d = textArea.getPreferredSize();
            d.width = width;
            ++d.height;
            textArea.setSize(d);
        } else {
            textArea.setLineWrap(false);
        }
        Dimension dim = textArea.getPreferredSize();
        ++dim.height;
        ++dim.width;
        return dim;
    }

    public Dimension getMinimumSize(JComponent c2) {
        return this.getPreferredSize(c2);
    }

    public Dimension getMaximumSize(JComponent c2) {
        return this.getPreferredSize(c2);
    }
}

