/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.pub.primitivegui;

import ciss.phase_viewer.pub.primitivegui.JInternalWorld;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class JCanvas3DExample
extends JFrame
implements ActionListener {
    private JButton addButton;
    private JCheckBox delayCheckBox;
    private JDesktopPane desktopPane;
    private JCheckBox interactiveCheckBox;
    private JPanel panel;
    private JCheckBox randomCheckBox;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;

    public JCanvas3DExample() {
        this.initComponents();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.scrollPane = new JScrollPane();
        this.panel = new JPanel();
        this.addButton = new JButton();
        this.delayCheckBox = new JCheckBox();
        this.interactiveCheckBox = new JCheckBox();
        this.randomCheckBox = new JCheckBox();
        this.desktopPane = new JDesktopPane();
        this.setDefaultCloseOperation(3);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setDividerSize(8);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.panel.setLayout(new GridBagLayout());
        this.addButton.setText("Create New Frame");
        this.addButton.setToolTipText("Adds a new frame containing an universe into the desktop pane");
        this.addButton.addActionListener(this);
        this.panel.add((Component)this.addButton, new GridBagConstraints());
        this.delayCheckBox.setText("Resize Delayed");
        this.delayCheckBox.setToolTipText("Shows the effect of using a delayed resizing to the internal frames.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.delayCheckBox, gridBagConstraints);
        this.interactiveCheckBox.setSelected(true);
        this.interactiveCheckBox.setText("Interactive Cube");
        this.interactiveCheckBox.setToolTipText("Tests the use of AWT behaviors on the displayed component.");
        this.interactiveCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.interactiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.interactiveCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.interactiveCheckBox, gridBagConstraints);
        this.randomCheckBox.setText("Random start angle");
        this.randomCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.randomCheckBox.setEnabled(false);
        this.randomCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.randomCheckBox, gridBagConstraints);
        this.scrollPane.setViewportView(this.panel);
        this.splitPane.setLeftComponent(this.scrollPane);
        this.desktopPane.setBackground(new Color(153, 153, 201));
        this.desktopPane.setPreferredSize(new Dimension(300, 300));
        this.splitPane.setRightComponent(this.desktopPane);
        this.getContentPane().add((Component)this.splitPane, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 1011) / 2, (screenSize.height - 733) / 2, 1011, 733);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addButton) {
            this.addButtonActionPerformed(evt);
        } else if (evt.getSource() == this.interactiveCheckBox) {
            this.interactiveCheckBoxActionPerformed(evt);
        }
    }

    private void interactiveCheckBoxActionPerformed(ActionEvent evt) {
        this.randomCheckBox.setEnabled(!this.interactiveCheckBox.isSelected());
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JInternalWorld iWorld = new JInternalWorld(this.interactiveCheckBox.isSelected(), this.delayCheckBox.isSelected(), this.randomCheckBox.isSelected());
        iWorld.setSize(256, 256);
        iWorld.setLocation(50, 50);
        iWorld.setResizable(true);
        this.desktopPane.add(iWorld);
        iWorld.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new JCanvas3DExample().setVisible(true);
            }
        });
    }
}

