/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class ExternalProgramExecuter {
    private static Logger logger = Logger.getLogger(ExternalProgramExecuter.class.getName());
    private String programPath = new String();
    private Process process;
    public static final int NORMAL = 0;
    public static final int EXCEPTION = 1;

    public ExternalProgramExecuter() {
    }

    public ExternalProgramExecuter(String programPath) {
        this.programPath = programPath;
    }

    public void addProgramPath(String str) {
        this.programPath = this.programPath + str;
    }

    public void clearProgramPath() {
        this.programPath = new String();
    }

    public String getProgramPath() {
        return this.programPath;
    }

    public void execute() throws Exception {
        this.process = Runtime.getRuntime().exec(this.programPath);
        logger.info("executed: " + this.programPath);
    }

    public Process getProcess() {
        return this.process;
    }

    public static void execute(String str) throws Exception {
        Process p = Runtime.getRuntime().exec(str);
        logger.info("executed: " + str);
        p.waitFor();
    }

    public static BufferedReader[] executeGetBR(String str) throws IOException {
        return ExternalProgramExecuter.executeGetBR(str, null);
    }

    public static BufferedReader[] executeGetBR(String str, File dir) throws IOException {
        BufferedReader[] bin = new BufferedReader[2];
        Process p = Runtime.getRuntime().exec(str, null, dir);
        InputStream ie = p.getErrorStream();
        bin[1] = new BufferedReader(new InputStreamReader(ie));
        InputStream is = p.getInputStream();
        bin[0] = new BufferedReader(new InputStreamReader(is));
        return bin;
    }

    public static BufferedReader[] executeGetBR(String str, File dir, String[] envp) throws IOException {
        BufferedReader[] bin = new BufferedReader[2];
        Process p = Runtime.getRuntime().exec(str, envp, dir);
        InputStream ie = p.getErrorStream();
        bin[1] = new BufferedReader(new InputStreamReader(ie));
        InputStream is = p.getInputStream();
        bin[0] = new BufferedReader(new InputStreamReader(is));
        return bin;
    }

    public static BufferedReader[] executeGetBR(String str, boolean waitFor) throws Exception {
        BufferedReader[] bin = new BufferedReader[2];
        Process p = Runtime.getRuntime().exec(str);
        try {
            BufferedInputStream ie = (BufferedInputStream)p.getErrorStream();
            bin[1] = new BufferedReader(new InputStreamReader(ie));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            BufferedInputStream is = (BufferedInputStream)p.getInputStream();
            bin[0] = new BufferedReader(new InputStreamReader(is));
        }
        catch (Exception ex) {
            logger.error("no output");
        }
        if (waitFor) {
            p.waitFor();
        }
        return bin;
    }

    public static void copy(String str1, String str2) throws IOException {
        String strBuff;
        if (str1.trim().equalsIgnoreCase(str2.trim())) {
            logger.error("can't copy ... same file!");
            return;
        }
        BufferedReader brInFile = new BufferedReader(new FileReader(str1));
        PrintWriter pwOutFile = new PrintWriter(new BufferedWriter(new FileWriter(str2)));
        while ((strBuff = brInFile.readLine()) != null) {
            pwOutFile.println(strBuff);
        }
        brInFile.close();
        pwOutFile.close();
    }

    public static void copyBinary(String binaryFile1, String binaryFile2) throws IOException {
        int indata;
        if (binaryFile1.trim().equalsIgnoreCase(binaryFile2.trim())) {
            logger.debug("can't copy ... same file!");
            return;
        }
        BufferedInputStream bistream = new BufferedInputStream(new FileInputStream(binaryFile1));
        BufferedOutputStream bostream = new BufferedOutputStream(new FileOutputStream(binaryFile2));
        while ((indata = bistream.read()) != -1) {
            bostream.write(indata);
        }
        bostream.flush();
        bistream.close();
        bostream.close();
    }

    public static void remove(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static boolean move(String fileName1, String fileName2) {
        logger.info("moving file " + fileName1 + " to " + fileName2);
        boolean bret = false;
        if (fileName1.trim().equalsIgnoreCase(fileName2.trim())) {
            logger.error("can't move ... same file!");
            return false;
        }
        File file1 = new File(fileName1);
        File file2 = new File(fileName2);
        bret = file1.renameTo(file2);
        return bret;
    }
}

