/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.atomcoord.pmodel.Cif;
import ciss.phase_viewer.atomcoord.pmodel.Pmodel;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.atomcoord.pmodel.SpaceGroup;
import ciss.phase_viewer.mainpanel.Desk;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CIFImporter
implements Importer {
    private Logger logger = Logger.getLogger(CIFImporter.class.getName());
    private int selectedData = 1;
    private int selectedChoice = 0;

    private String[] getCIFBlockTitles(String cifFile) {
        try {
            return Cif.getDataBlockTitle(cifFile);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        int i;
        this.logger.info("parsing cif file... " + fileName);
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.readCIF(fileName, this.selectedData);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            this.logger.error("failed to read CIF : " + fileName);
            return null;
        }
        if (pmodel.getNumSymmetryEquivPosInCif() > 1) {
            try {
                pmodel.makeSpaceGroup();
            }
            catch (PmodelException e) {
                this.logger.error("failed to generate space group from CIF : " + fileName);
                return null;
            }
        } else if (pmodel.getIntTablesNum() > 0) {
            try {
                pmodel.makeSpaceGroup(this.selectedChoice);
            }
            catch (PmodelException e) {
                this.logger.error("failed to generate space group from CIF : " + fileName);
                return null;
            }
        } else {
            this.logger.error("cannot detect symmetry informations");
            return null;
        }
        try {
            pmodel.makeLattice();
        }
        catch (PmodelException e) {
            e.printStackTrace();
            this.logger.error("failed to generate lattice from CIF : " + fileName);
            return null;
        }
        String[] symbols = pmodel.getSymbol();
        boolean hasNumbers = false;
        for (int i2 = 0; i2 < symbols.length; ++i2) {
            if (!symbols[i2].matches(".*\\d+.*")) continue;
            hasNumbers = true;
            break;
        }
        boolean strip = false;
        if (hasNumbers) {
            strip = JOptionPane.showInternalConfirmDialog(Desk.getDesktop().getSelectedFrame(), "strip numbers from symbol?", "strip numbers", 0, 3) == 0;
        }
        AtomCoords coords = new AtomCoords();
        coords.isCart(true);
        coords.setUnit(2);
        AtomList list = coords.getAtomList();
        double[][] cellVec = pmodel.getCellVec();
        double[] av = new double[3];
        double[] bv = new double[3];
        double[] cv = new double[3];
        for (int i3 = 0; i3 < 3; ++i3) {
            av[i3] = cellVec[0][i3];
            bv[i3] = cellVec[1][i3];
            cv[i3] = cellVec[2][i3];
        }
        Cell cellv = new Cell(av, bv, cv);
        coords.setCell(cellv);
        int NumAt = pmodel.getNumberOfAtoms();
        double[][] fposs = pmodel.getInternalPosition();
        for (i = 0; i < fposs.length; ++i) {
            this.logger.debug("fractional pos " + i + " " + fposs[i][0] + ", " + fposs[i][1] + ", " + fposs[i][2]);
        }
        for (i = 0; i < NumAt; ++i) {
            String element = symbols[i];
            if (strip) {
                element = element.split("\\d+")[0].split("\\(")[0];
            }
            this.logger.debug("atom :" + i + " name: " + element);
            double[] cpos = new double[3];
            for (int j = 0; j < 3; ++j) {
                cpos[j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    cpos[j] = cpos[j] + cellVec[k][j] * fposs[i][k];
                }
            }
            Atom at = new Atom(element, cpos);
            list.addAtom(at);
        }
        this.logger.debug(list);
        return new AtomCoords[]{coords};
    }

    public String getType() {
        return "CIF";
    }

    public FileFilter getFileFilter() {
        return new CIFFileFilter();
    }

    public boolean hasOptions() {
        return true;
    }

    public void createOptionsPanel(boolean isheavy, PropertyChangeListener listener, String fileName) {
        int maxChoice;
        Object[] titles = this.getCIFBlockTitles(fileName);
        if (titles == null || titles.length == 0) {
            this.selectedData = 0;
        } else if (titles.length == 1) {
            this.selectedData = 1;
        } else {
            Object ret = JOptionPane.showInternalInputDialog(Desk.getDesktop().getSelectedFrame(), "select data", "select data", 1, null, titles, titles[0]);
            if (ret != null) {
                for (int i = 0; i < titles.length; ++i) {
                    if (titles[i] != ret) continue;
                    this.selectedData = i + 1;
                }
            }
        }
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.readCIF(fileName, this.selectedData);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            listener.propertyChange(null);
            return;
        }
        if (pmodel.getNumSymmetryEquivPosInCif() <= 1 && pmodel.getIntTablesNum() > 0 && (maxChoice = SpaceGroup.getMaxChoice(pmodel.getIntTablesNum())) > 1) {
            Object[] choices = new Integer[maxChoice];
            for (int i = 0; i < maxChoice; ++i) {
                choices[i] = new Integer(i);
            }
            Object ret = JOptionPane.showInternalInputDialog(Desk.getDesktop().getSelectedFrame(), "select choice", "select choice", 1, null, choices, choices[0]);
            if (ret != null) {
                this.selectedChoice = (Integer)ret;
            }
        }
        listener.propertyChange(null);
    }

    public void setOptions(HashMap options) {
    }

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }

    class CIFFileFilter
    extends FileFilter {
        CIFFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fileName = f.getName().toLowerCase();
            if (fileName != null) {
                return fileName.endsWith(".cif");
            }
            return false;
        }

        public String getDescription() {
            return "Crystallographic Information File (*.cif)";
        }
    }
}

