/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;
import hep.aida.util.comparison.AbstractComparisonAlgorithm;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;

public class Chi2ComparisonAlgorithm
extends AbstractComparisonAlgorithm {
    private static final String[] names = new String[]{"chi2", "chiSquared"};
    private static final int dType = 0;
    private static final int eType = 0;

    public Chi2ComparisonAlgorithm() {
        super(0, 0);
    }

    public String[] algorithmNames() {
        return names;
    }

    public double quality(IComparisonData d1, IComparisonData d2) throws RuntimeException {
        if (!this.canCompare(d1, d2)) {
            throw new IllegalArgumentException("Invalid data. The " + names[0] + " cannot compare the given datasets. They MUST be binned with the SAME binning.");
        }
        int n = d1.nPoints();
        double chi2 = 0.0;
        int nDf = 0;
        for (int i = 0; i < n; ++i) {
            double w2;
            double w1 = d1.weight(i);
            double w = w1 + (w2 = d2.weight(i));
            if (!(w > 0.0)) continue;
            double dw = w1 - w2;
            chi2 += dw * dw / w;
            ++nDf;
        }
        ChiSquaredDistribution chi2Distribution = DistributionFactory.newInstance().createChiSquareDistribution((double)nDf);
        double prob = Double.NaN;
        try {
            prob = chi2Distribution.cumulativeProbability(chi2);
        }
        catch (MathException me) {
            throw new RuntimeException("Problems evaluating probability ", me);
        }
        return prob;
    }

    public int nDof(IComparisonData d1, IComparisonData d2) {
        int n = d1.nPoints();
        int nDf = 0;
        for (int i = 0; i < n; ++i) {
            double w2;
            double w1 = d1.weight(i);
            double w = w1 + (w2 = d2.weight(i));
            if (!(w > 0.0)) continue;
            ++nDf;
        }
        return nDf;
    }

    public boolean canCompare(IComparisonData d1, IComparisonData d2) {
        boolean superCanCompare = super.canCompare(d1, d2);
        if (!superCanCompare) {
            return false;
        }
        int nPoints = d1.nPoints();
        if (nPoints != d2.nPoints()) {
            return false;
        }
        for (int i = 0; i < nPoints; ++i) {
            if (d1.value(i) == d2.value(i)) continue;
            return false;
        }
        return true;
    }
}

