/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.AidaUtils;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.JELFunctionCore;
import java.util.StringTokenizer;

public class JELBaseModelFunction
extends BaseModelFunction {
    private JELBaseModelFunction() {
    }

    public JELBaseModelFunction(String treeName, int dim, String valexpr, String parameters, String description, String gradexpr) {
        this.setName(treeName);
        JELFunctionCore f = this.createJELFunctionCore(dim, valexpr, parameters, gradexpr);
        this.init(description, f, f);
    }

    public JELFunctionCore createJELFunctionCore(int dim, String valexpr, String parameters, String gradexpr) {
        JELFunctionCore core = null;
        String[] parNames = null;
        int nPar = 0;
        if (parameters != null && !parameters.equals("")) {
            StringTokenizer st = new StringTokenizer(parameters, ",;");
            nPar = st.countTokens();
            if (nPar > 0) {
                parNames = new String[nPar];
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                this.checkParameterName(token);
                parNames[i] = token;
                ++i;
            }
        }
        String[] gr = null;
        int nGr = 0;
        if (gradexpr != null && !gradexpr.equals("") && !gradexpr.trim().toLowerCase().equals("null")) {
            String[] array = AidaUtils.parseString(gradexpr);
            nGr = array.length;
            if (nGr != nPar) {
                throw new IllegalArgumentException("Dimension of the gradient (" + nGr + ") is not equal to the number of parameters (" + nPar + ")");
            }
            gr = new String[nPar];
            boolean i = false;
            for (int j = 0; j < nGr; ++j) {
                String token;
                gr[j] = token = array[j].trim();
            }
        }
        core = new JELFunctionCore(dim, nPar, valexpr, parNames, gr);
        return core;
    }

    private void checkParameterName(String token) {
        if (token.startsWith("x") || token.startsWith("X")) {
            String tmp = token.substring(1);
            try {
                int i = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                return;
            }
            String mess = "Illegal parameter name: \"" + token + "\".\nNames like x0, x1, x2, ..., are reserved. Please rename this parameter..";
            throw new IllegalArgumentException(mess);
        }
    }
}

