/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitdata;

import hep.aida.ITuple;
import hep.aida.dev.IDevFitDataIterator;

public class FitDataIterator
implements IDevFitDataIterator {
    private ITuple tuple;
    private int valCol;
    private int errCol;
    private int errMinusCol;
    private int nVars;
    private double[] vars;

    public FitDataIterator(ITuple tuple) {
        this.tuple = tuple;
        tuple.start();
        tuple.next();
        this.valCol = tuple.findColumn("value");
        this.errCol = tuple.findColumn("error");
        this.errMinusCol = tuple.findColumn("minusError");
        this.nVars = tuple.columns() - 3;
        this.vars = new double[this.nVars];
    }

    public int entries() {
        return this.tuple.rows();
    }

    public boolean next() {
        return this.tuple.next();
    }

    public void start() {
        this.tuple.start();
    }

    public double value() {
        if (this.valCol != -1) {
            return this.tuple.getDouble(this.valCol);
        }
        return Double.NaN;
    }

    public double error() {
        if (this.errCol != -1) {
            return this.tuple.getDouble(this.errCol);
        }
        return Double.NaN;
    }

    public double minusError() {
        if (this.errMinusCol != -1) {
            return this.tuple.getDouble(this.errMinusCol);
        }
        return this.error();
    }

    public double[] vars() {
        for (int i = 0; i < this.nVars; ++i) {
            this.vars[i] = this.tuple.getDouble(3 + i);
        }
        return this.vars;
    }
}

