/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import org.apache.log4j.Logger;

public class VectorOperations {
    private static final Logger logger = Logger.getLogger(VectorOperations.class.getName());

    public static double calDist(double[] firstVector, double[] secondVector) {
        double dist = 0.0;
        if (firstVector == null || secondVector == null) {
            logger.error("either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = firstVector.length;
        if (ndim > secondVector.length) {
            ndim = secondVector.length;
        }
        if (ndim != secondVector.length) {
            logger.warn("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim);
        }
        for (int i = 0; i < ndim; ++i) {
            dist += Math.pow(firstVector[i] - secondVector[i], 2.0);
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static float calDist(float[] firstVector, float[] secondVector) {
        int i;
        double[] dfv = new double[firstVector.length];
        double[] dsv = new double[secondVector.length];
        for (i = 0; i < dfv.length; ++i) {
            dfv[i] = firstVector[i];
        }
        for (i = 0; i < dsv.length; ++i) {
            dsv[i] = secondVector[i];
        }
        float ret = (float)VectorOperations.calDist(dfv, dsv);
        return ret;
    }

    public static double dotProduct(double[] v1, double[] v2) {
        if (v1 == null || v2 == null) {
            logger.error("either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = v1.length;
        if (ndim > v2.length) {
            ndim = v2.length;
        }
        if (v1.length != v2.length) {
            logger.warn("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim);
        }
        double dot = 0.0;
        for (int i = 0; i < ndim; ++i) {
            dot += v1[i] * v2[i];
        }
        return dot;
    }

    public static float dotProduct(float[] v1, float[] v2) {
        int i;
        double[] d1 = new double[v1.length];
        double[] d2 = new double[v2.length];
        for (i = 0; i < d1.length; ++i) {
            d1[i] = v1[i];
        }
        for (i = 0; i < d2.length; ++i) {
            d2[i] = v2[i];
        }
        float ret = (float)VectorOperations.dotProduct(d1, d2);
        return ret;
    }

    public static double[] crossProduct(double[] v1, double[] v2) {
        double[] ret = null;
        if (v1 != null && v2 != null) {
            ret = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        } else {
            logger.error("either v1 or v2 was null ...");
            logger.error("returning null.");
        }
        return ret;
    }

    public static float[] crossProduct(float[] v1, float[] v2) {
        int i;
        double[] d1 = new double[v1.length];
        double[] d2 = new double[v2.length];
        for (i = 0; i < d1.length; ++i) {
            d1[i] = v1[i];
        }
        for (i = 0; i < d2.length; ++i) {
            d2[i] = v2[i];
        }
        double[] foo = VectorOperations.crossProduct(d1, d2);
        float[] ret = new float[foo.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (float)foo[i2];
        }
        return ret;
    }

    public static double norm(double[] v) {
        double norm = 0.0;
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                norm += v[i] * v[i];
            }
        } else {
            logger.error("v was null ... ");
        }
        return Math.sqrt(norm);
    }

    public static float norm(float[] v) {
        double[] dv = new double[v.length];
        for (int i = 0; i < dv.length; ++i) {
            dv[i] = v[i];
        }
        float ret = (float)VectorOperations.norm(dv);
        return ret;
    }

    public static double[] getNormalVector(double[] firstVector, double[] secondVector) {
        if (firstVector == null || secondVector == null) {
            logger.error("either vector 1 or vector 2 was null...");
            return null;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error("the dimension of the vectors must at least be greater than 3.");
            return null;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn("the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn("truncating higher dimensions...");
        }
        double[] n1 = VectorOperations.crossProduct(firstVector, secondVector);
        double norm1 = VectorOperations.norm(n1);
        for (int i = 0; i < 3; ++i) {
            n1[i] = n1[i] / norm1;
        }
        return n1;
    }

    public static float[] getNormalVector(float[] fv, float[] sv) {
        double[] dfv = new double[fv.length];
        double[] dsv = new double[sv.length];
        for (int i = 0; i < dfv.length; ++i) {
            dfv[i] = fv[i];
            dsv[i] = sv[i];
        }
        double[] ret = VectorOperations.getNormalVector(dfv, dsv);
        float[] retu = new float[ret.length];
        for (int i = 0; i < retu.length; ++i) {
            retu[i] = (float)ret[i];
        }
        return retu;
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin) {
        return VectorOperations.getDistanceFromPlane(point, firstVector, secondVector, origin, false);
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin, boolean orientationToo) {
        if (firstVector == null || secondVector == null) {
            logger.error("either vector 1 or vector 2 was null...");
            return 0.0;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error("the dimension of the vectors must at least be greater than 3.");
            return 0.0;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn("the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn("truncating higher dimensions...");
        }
        double[] referanceVector = new double[3];
        for (int i = 0; i < 3; ++i) {
            referanceVector[i] = point[i] - (firstVector[i] + origin[i]);
        }
        double[] normalVector = VectorOperations.getNormalVector(firstVector, secondVector);
        if (!orientationToo) {
            return Math.abs(VectorOperations.dotProduct(normalVector, referanceVector));
        }
        return VectorOperations.dotProduct(normalVector, referanceVector);
    }

    public static double getDistanceFromPlane(double[] point, double[] normalVector, double[] origin) {
        return VectorOperations.getDistanceFromPlane(point, normalVector, origin, false);
    }

    public static double getDistanceFromPlane(double[] point, double[] normalVector, double[] origin, boolean orientationToo) {
        if (normalVector == null) {
            logger.error("invalid normal...");
            return 0.0;
        }
        if (normalVector.length < 3) {
            logger.error("the dimension of the vectors must at least be greater than 3.");
            return 0.0;
        }
        if (normalVector.length != 3) {
            logger.warn("the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn("truncating higher dimensions...");
        }
        double[] referenceVector = new double[3];
        for (int i = 0; i < 3; ++i) {
            referenceVector[i] = point[i] - origin[i];
        }
        if (!orientationToo) {
            return Math.abs(VectorOperations.dotProduct(normalVector, referenceVector));
        }
        return VectorOperations.dotProduct(normalVector, referenceVector);
    }

    public static float getAngleBetween(float[] vector1, float[] vector2) {
        float verySmall = 1.0E-4f;
        float norm1 = VectorOperations.norm(vector1);
        float norm2 = VectorOperations.norm(vector2);
        float[] vecbuff1 = vector1;
        float[] vecbuff2 = vector2;
        if (norm1 < verySmall || norm2 < verySmall) {
            return 0.0f;
        }
        float cosine = VectorOperations.dotProduct(vecbuff1, vecbuff2) / (norm1 * norm2);
        if (cosine > 1.0f) {
            cosine = 1.0f;
        }
        if (cosine < -1.0f) {
            cosine = -1.0f;
        }
        return (float)Math.acos(cosine);
    }
}

