/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import Jama.Matrix;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.common.BinaryOperator;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VolumetricData
implements BinaryOperator {
    public static int CHARGE_DENSITY = 0;
    public static int MOLECULAR_ORBITAL = 1;
    private int mode = CHARGE_DENSITY;
    private Vector molecularOrbitalIndeces = null;
    private Logger logger = Logger.getLogger(VolumetricData.class.getName());
    private float[] density;
    private float[] density_buff;
    private float[] sortedDensity;
    private int[] ndiv;
    private int[] ndiv_buff;
    private float[][] delta;
    private float[][] delta_buff;
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private int Ntot;
    private float minVal = 10000.0f;
    private float maxVal = -10000.0f;
    private float midVal = 0.0f;
    public static int LOG = 0;
    public static int LINEAR = 1;
    private int interpolationScheme = LOG;
    public static float meaninglessValue = 1000.0f;
    private boolean pbc = true;
    private int nshift0 = 0;
    private int nshift1 = 0;
    private int nshift2 = 0;

    public void add(BinaryOperator bo) {
        if (!(bo instanceof VolumetricData)) {
            return;
        }
        VolumetricData vdata = (VolumetricData)bo;
        if (vdata.density.length != this.density.length) {
            return;
        }
        for (int i = 0; i < this.density.length; ++i) {
            int n = i;
            this.density[n] = this.density[n] + vdata.density[i];
        }
    }

    public void divide(BinaryOperator bo) {
    }

    public void multiply(BinaryOperator bo) {
    }

    public void subtract(BinaryOperator bo) {
        if (!(bo instanceof VolumetricData)) {
            return;
        }
        VolumetricData vdata = (VolumetricData)bo;
        if (vdata.density.length != this.density.length) {
            return;
        }
        for (int i = 0; i < this.density.length; ++i) {
            int n = i;
            this.density[n] = this.density[n] - vdata.density[i];
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.interpolationScheme = LINEAR;
    }

    public int getMode() {
        return this.mode;
    }

    public void addMolecularOrbitalIndex(Object obj) {
        if (this.molecularOrbitalIndeces == null) {
            this.molecularOrbitalIndeces = new Vector();
            this.molecularOrbitalIndeces.add(obj);
        }
    }

    public void removeMolecularOrbitalIndex(Object obj) {
        if (this.molecularOrbitalIndeces != null) {
            this.molecularOrbitalIndeces.remove(obj);
        }
    }

    public Object[] getMolecularOrbitalIndeces() {
        if (this.molecularOrbitalIndeces == null) {
            return null;
        }
        Object[] ob = new Object[this.molecularOrbitalIndeces.size()];
        this.molecularOrbitalIndeces.copyInto(ob);
        return ob;
    }

    public VolumetricData(float[] density, int[] ndiv, float[][] delta, float[] origin) {
        if (!this.pbc) {
            this.density = density;
            this.ndiv = ndiv;
            this.delta = delta;
            this.origin = origin;
            this.Ntot = ndiv[0] * ndiv[1] * ndiv[2];
            this.init(density, ndiv);
        } else {
            this.delta = delta;
            this.origin = origin;
            this.density = density;
            this.ndiv = ndiv;
            this.Ntot = ndiv[0] * ndiv[1] * ndiv[2];
            this.doPBC(density, ndiv);
            this.init(density, ndiv);
        }
    }

    public void save() {
        int i;
        this.density_buff = new float[this.density.length];
        for (i = 0; i < this.density.length; ++i) {
            this.density_buff[i] = this.density[i];
        }
        this.ndiv_buff = new int[3];
        for (i = 0; i < this.ndiv.length; ++i) {
            this.ndiv_buff[i] = this.ndiv[i];
        }
        this.delta_buff = new float[3][3];
        for (i = 0; i < this.delta.length; ++i) {
            for (int j = 0; j < this.delta[i].length; ++j) {
                this.delta_buff[i][j] = this.delta[i][j];
            }
        }
    }

    public void restore() {
        this.density = this.density_buff;
        this.ndiv = this.ndiv_buff;
        this.delta = this.delta_buff;
        this.logger.debug("restored data ");
        this.logger.debug("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]);
        for (int i = 0; i < 3; ++i) {
            this.logger.debug("delta " + i + ": " + this.delta[i][0] + ", " + this.delta[i][1] + ", " + this.delta[i][2]);
        }
    }

    public void stripPBC() {
        if (!this.pbc) {
            return;
        }
        int[] ndiv_tmp = new int[3];
        for (int i = 0; i < 3; ++i) {
            ndiv_tmp[i] = this.ndiv[i] - 1;
        }
        int Ntot_tmp = ndiv_tmp[0] * ndiv_tmp[1] * ndiv_tmp[2];
        float[] density_tmp = new float[Ntot_tmp];
        for (int i = 0; i < ndiv_tmp[0]; ++i) {
            for (int j = 0; j < ndiv_tmp[1]; ++j) {
                for (int k = 0; k < ndiv_tmp[2]; ++k) {
                    int index = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    int newind = i * ndiv_tmp[1] * ndiv_tmp[2] + j * ndiv_tmp[2] + k;
                    density_tmp[newind] = this.density[index];
                }
            }
        }
        this.density = density_tmp;
        this.ndiv = ndiv_tmp;
        this.Ntot = Ntot_tmp;
    }

    public void doPBC(float[] den, int[] ndi) {
        int ind;
        int j;
        int i;
        this.ndiv = new int[3];
        this.ndiv[0] = ndi[0] + 1;
        this.ndiv[1] = ndi[1] + 1;
        this.ndiv[2] = ndi[2] + 1;
        this.Ntot = this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
        this.density = new float[this.Ntot];
        for (i = 0; i < ndi[0]; ++i) {
            for (j = 0; j < ndi[1]; ++j) {
                for (int k = 0; k < ndi[2]; ++k) {
                    int index = i * ndi[1] * ndi[2] + j * ndi[2] + k;
                    int newind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    this.density[newind] = den[index];
                }
            }
        }
        for (i = 0; i < this.ndiv[0]; ++i) {
            for (j = 0; j < this.ndiv[1]; ++j) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2];
                this.density[ind + this.ndiv[2] - 1] = this.density[ind];
            }
        }
        for (i = 0; i < this.ndiv[0]; ++i) {
            for (j = 0; j < this.ndiv[2]; ++j) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j;
                this.density[ind + this.ndiv[2] * (this.ndiv[1] - 1)] = this.density[ind];
            }
        }
        for (i = 0; i < this.ndiv[1]; ++i) {
            for (j = 0; j < this.ndiv[2]; ++j) {
                ind = i * this.ndiv[2] + j;
                this.density[this.ndiv[2] * this.ndiv[1] * (this.ndiv[0] - 1) + ind] = this.density[ind];
            }
        }
    }

    private float[] doPBC(float[] den) {
        int ind;
        int j;
        int i;
        int[] ndi = new int[3];
        for (int i2 = 0; i2 < ndi.length; ++i2) {
            ndi[i2] = this.ndiv[i2] - 1;
        }
        float[] tmpden = new float[this.Ntot];
        for (i = 0; i < ndi[0]; ++i) {
            for (j = 0; j < ndi[1]; ++j) {
                for (int k = 0; k < ndi[2]; ++k) {
                    int index = i * ndi[1] * ndi[2] + j * ndi[2] + k;
                    int newind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    tmpden[newind] = den[index];
                }
            }
        }
        for (i = 0; i < this.ndiv[0]; ++i) {
            for (j = 0; j < this.ndiv[1]; ++j) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2];
                tmpden[ind + this.ndiv[2] - 1] = tmpden[ind];
            }
        }
        for (i = 0; i < this.ndiv[0]; ++i) {
            for (j = 0; j < this.ndiv[2]; ++j) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j;
                tmpden[ind + this.ndiv[2] * (this.ndiv[1] - 1)] = tmpden[ind];
            }
        }
        for (i = 0; i < this.ndiv[1]; ++i) {
            for (j = 0; j < this.ndiv[2]; ++j) {
                ind = i * this.ndiv[2] + j;
                tmpden[this.ndiv[2] * this.ndiv[1] * (this.ndiv[0] - 1) + ind] = tmpden[ind];
            }
        }
        return tmpden;
    }

    public void setShift(int n1, int n2, int n3) {
        if (n1 > this.ndiv[0] || n2 > this.ndiv[1] || n3 > this.ndiv[2]) {
            this.logger.error("can't shift that much!");
            return;
        }
        this.nshift0 = n1;
        this.nshift1 = n2;
        this.nshift2 = n3;
    }

    public void setShiftOld(double d1, double d2, double d3) {
        double cell0 = this.delta[0][0] * (float)this.ndiv[0] + this.delta[0][1] * (float)this.ndiv[1] + this.delta[0][2] * (float)this.ndiv[2];
        double cell1 = this.delta[1][0] * (float)this.ndiv[0] + this.delta[1][1] * (float)this.ndiv[1] + this.delta[1][2] * (float)this.ndiv[2];
        double cell2 = this.delta[2][0] * (float)this.ndiv[0] + this.delta[2][1] * (float)this.ndiv[1] + this.delta[2][2] * (float)this.ndiv[2];
        double[][] cell = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                cell[i][j] = this.delta[i][j] * (float)this.ndiv[j];
            }
        }
        double[][] shift = new double[3][1];
        shift[0][0] = d1;
        shift[1][0] = d2;
        shift[2][0] = d3;
        Matrix A = new Matrix(cell);
        Matrix B = new Matrix(shift);
        Matrix N = A.solve(B);
        this.nshift0 = (int)Math.round(N.get(0, 0) * (double)this.ndiv[0]);
        this.nshift1 = (int)Math.round(N.get(1, 0) * (double)this.ndiv[1]);
        this.nshift2 = (int)Math.round(N.get(2, 0) * (double)this.ndiv[2]);
        this.logger.debug("set shift : " + this.nshift0 + ", " + this.nshift1 + ", " + this.nshift2 + " from float: " + d1 + ", " + d2 + ", " + d3);
    }

    public void setShift(double d1, double d2, double d3) {
        this.logger.debug("d1, d2, d3: " + d1 + ", " + d2 + ", " + d3);
        this.nshift0 = (int)Math.round(d1 * (double)this.ndiv[0]);
        this.nshift1 = (int)Math.round(d2 * (double)this.ndiv[1]);
        this.nshift2 = (int)Math.round(d3 * (double)this.ndiv[2]);
        this.logger.debug("nshift: " + this.nshift0 + ", " + this.nshift1 + ", " + this.nshift2);
    }

    public void setDiffShift(double d1, double d2, double d3) {
        this.nshift0 += (int)Math.round(d1 * (double)this.ndiv[0]);
        this.nshift1 += (int)Math.round(d2 * (double)this.ndiv[1]);
        this.nshift2 += (int)Math.round(d3 * (double)this.ndiv[2]);
    }

    public void enlarge(int n1, int n2, int n3) {
        try {
            int j;
            int i;
            int nnew;
            int NtotOld = this.ndiv_buff[0] * this.ndiv_buff[1] * this.ndiv_buff[2];
            this.ndiv = new int[this.ndiv.length];
            this.ndiv[0] = this.ndiv_buff[0] * n1;
            this.ndiv[1] = this.ndiv_buff[1] * n2;
            this.ndiv[2] = this.ndiv_buff[2] * n3;
            this.Ntot = this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
            float[] density_tmp = new float[this.ndiv[2] * this.ndiv_buff[1] * this.ndiv_buff[0]];
            boolean ntmp1 = false;
            boolean ntmp2 = false;
            boolean ntmp3 = false;
            boolean nbase = false;
            for (int i2 = 0; i2 < this.ndiv_buff[0] * this.ndiv_buff[1]; ++i2) {
                for (int j2 = 0; j2 < this.ndiv_buff[2]; ++j2) {
                    int nold = i2 * this.ndiv_buff[2] + j2;
                    for (int k = 0; k < n3; ++k) {
                        int tmp = k * this.ndiv_buff[2];
                        nnew = i2 * this.ndiv[2] + j2 + tmp;
                        density_tmp[nnew] = this.density_buff[nold];
                    }
                }
            }
            float[] density_tmp2 = new float[this.ndiv[2] * this.ndiv[1] * this.ndiv_buff[0]];
            for (i = 0; i < this.ndiv_buff[0]; ++i) {
                for (j = 0; j < n3 * this.ndiv_buff[2] * this.ndiv_buff[1]; ++j) {
                    int nold = i * n3 * this.ndiv_buff[2] * this.ndiv_buff[1] + j;
                    for (int k = 0; k < n2; ++k) {
                        int tmp = k * this.ndiv_buff[1] * this.ndiv[2];
                        int nnew2 = i * this.ndiv[1] * this.ndiv[2] + j + tmp;
                        density_tmp2[nnew2] = density_tmp[nold];
                    }
                }
            }
            if (!this.pbc) {
                this.density = new float[this.Ntot];
                for (i = 0; i < density_tmp2.length; ++i) {
                    for (j = 0; j < n1; ++j) {
                        int nnew3 = j * density_tmp2.length + i;
                        this.density[nnew3] = density_tmp2[i];
                    }
                }
            } else {
                float[] den = new float[this.Ntot];
                int[] ndi = new int[]{this.ndiv[0], this.ndiv[1], this.ndiv[2]};
                for (int i3 = 0; i3 < density_tmp2.length; ++i3) {
                    for (int j3 = 0; j3 < n1; ++j3) {
                        nnew = j3 * density_tmp2.length + i3;
                        den[nnew] = density_tmp2[i3];
                    }
                }
                this.doPBC(den, ndi);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setInterpolationScheme(int interpolationScheme) {
        this.interpolationScheme = interpolationScheme;
    }

    public int binarySearch(float value) {
        Arrays.sort(this.sortedDensity);
        int ret = Arrays.binarySearch(this.sortedDensity, value);
        if (ret < 0) {
            ret *= -1;
        }
        return ret;
    }

    public float[] getOrigDensity() {
        return this.density_buff;
    }

    public float[] getOrigin() {
        return this.origin;
    }

    public void createBuffer(float[] den, int[] ndi) {
        this.init(den, ndi);
    }

    private void init(float[] den, int[] ndi) {
        int i;
        if (den != null) {
            for (i = 0; i < den.length; ++i) {
                if (den[i] == meaninglessValue) continue;
                if (den[i] < this.minVal) {
                    this.minVal = den[i];
                    continue;
                }
                if (!(den[i] > this.maxVal)) continue;
                this.maxVal = den[i];
            }
            this.sortedDensity = new float[den.length];
            this.density_buff = new float[den.length];
            for (i = 0; i < this.sortedDensity.length; ++i) {
                this.sortedDensity[i] = den[i];
                this.density_buff[i] = den[i];
            }
            if (this.interpolationScheme == LOG) {
                this.midVal = (float)BaseColorMap.getValueFromLogScaledValue(this.minVal, this.maxVal, 0.5);
            } else if (this.interpolationScheme == LINEAR) {
                this.midVal = (float)BaseColorMap.getValueFromLinearScaledValue(this.minVal, this.maxVal, 0.5);
            }
        }
        if (this.ndiv != null) {
            this.ndiv_buff = new int[ndi.length];
            for (i = 0; i < this.ndiv_buff.length; ++i) {
                this.ndiv_buff[i] = ndi[i];
            }
        }
        if (this.delta != null) {
            this.delta_buff = new float[3][3];
            for (i = 0; i < this.delta.length; ++i) {
                for (int j = 0; j < this.delta[i].length; ++j) {
                    this.delta_buff[i][j] = this.delta[i][j];
                }
            }
        }
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public int[] getNumDiv() {
        return this.ndiv;
    }

    public int getNtot() {
        if (this.ndiv == null || this.ndiv.length < 3) {
            return -1;
        }
        return this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
    }

    public float getMidVal() {
        return this.midVal;
    }

    private float[] getShiftedDensity() {
        int i;
        this.stripPBC();
        float[] den_tmp = new float[this.density.length];
        for (i = 0; i < den_tmp.length; ++i) {
            den_tmp[i] = this.density[i];
        }
        for (i = 0; i < this.ndiv[2]; ++i) {
            for (int j = 0; j < this.ndiv[1]; ++j) {
                for (int k = 0; k < this.ndiv[0]; ++k) {
                    int itmp = i + this.nshift2;
                    int jtmp = j + this.nshift1;
                    int ktmp = k + this.nshift0;
                    if (itmp >= this.ndiv[2]) {
                        itmp -= this.ndiv[2];
                    } else if (itmp < 0) {
                        itmp += this.ndiv[2];
                    }
                    if (jtmp >= this.ndiv[1]) {
                        jtmp -= this.ndiv[1];
                    } else if (jtmp < 0) {
                        jtmp += this.ndiv[1];
                    }
                    if (ktmp >= this.ndiv[0]) {
                        ktmp -= this.ndiv[0];
                    } else if (ktmp < 0) {
                        ktmp += this.ndiv[0];
                    }
                    int ind1 = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                    int ind2 = itmp + jtmp * this.ndiv[2] + ktmp * this.ndiv[2] * this.ndiv[1];
                    den_tmp[ind2] = this.density[ind1];
                }
            }
        }
        this.doPBC(this.density, this.ndiv);
        den_tmp = this.doPBC(den_tmp);
        return den_tmp;
    }

    public float[] getDensity() {
        if (this.nshift0 == 0 && this.nshift1 == 0 && this.nshift2 == 0) {
            return this.density;
        }
        return this.getShiftedDensity();
    }

    public float[][][][] getCoordinates_explicitIndeces() {
        float[][][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]][3];
        for (int i = 0; i < this.ndiv[2]; ++i) {
            for (int j = 0; j < this.ndiv[1]; ++j) {
                for (int k = 0; k < this.ndiv[0]; ++k) {
                    ret[i][j][k][0] = (float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0];
                    ret[i][j][k][1] = (float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1];
                    ret[i][j][k][2] = (float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2];
                }
            }
        }
        return ret;
    }

    public float[][][][] getCoordinates_explicitIndeces(float lenmax, float[] jusin) {
        float[][][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]][3];
        for (int i = 0; i < this.ndiv[2]; ++i) {
            for (int j = 0; j < this.ndiv[1]; ++j) {
                for (int k = 0; k < this.ndiv[0]; ++k) {
                    ret[i][j][k][0] = ((float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0] - jusin[0]) / lenmax;
                    ret[i][j][k][1] = ((float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1] - jusin[1]) / lenmax;
                    ret[i][j][k][2] = ((float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2] - jusin[2]) / lenmax;
                }
            }
        }
        return ret;
    }

    public float[][][] getValue_explicitIndeces() {
        float[][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]];
        if (this.nshift0 == 0 && this.nshift1 == 0 && this.nshift2 == 0) {
            for (int i = 0; i < this.ndiv[2]; ++i) {
                for (int j = 0; j < this.ndiv[1]; ++j) {
                    for (int k = 0; k < this.ndiv[0]; ++k) {
                        int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                        ret[i][j][k] = this.density[n];
                    }
                }
            }
        } else {
            float[] den = this.getShiftedDensity();
            for (int i = 0; i < this.ndiv[2]; ++i) {
                for (int j = 0; j < this.ndiv[1]; ++j) {
                    for (int k = 0; k < this.ndiv[0]; ++k) {
                        int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                        ret[i][j][k] = den[n];
                    }
                }
            }
        }
        return ret;
    }

    public float[][] getCoordinates() {
        float[][] ret = new float[3][this.Ntot];
        for (int i = 0; i < this.ndiv[2]; ++i) {
            for (int j = 0; j < this.ndiv[1]; ++j) {
                for (int k = 0; k < this.ndiv[0]; ++k) {
                    int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                    ret[0][n] = (float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0];
                    ret[1][n] = (float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1];
                    ret[2][n] = (float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2];
                }
            }
        }
        return ret;
    }

    private int[] get3DIndexFrom1DIndex(int index1d) {
        int nz = index1d % this.ndiv[2];
        int ny = (index1d - nz) / this.ndiv[2] % this.ndiv[1];
        int nx = ((index1d - nz) / this.ndiv[2] - ny) / this.ndiv[1];
        return new int[]{nx, ny, nz};
    }

    private float[] getCoordinatesFrom(int[] index) {
        float[] ret = new float[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = 0.0f;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                ret[n] = ret[n] + (float)index[j] * this.delta[j][i];
            }
            int n = i;
            ret[n] = ret[n] + this.origin[i];
        }
        return ret;
    }

    private float[] getCoordinatesFrom(int index) {
        return this.getCoordinatesFrom(this.get3DIndexFrom1DIndex(index));
    }

    public int getInterpolationScheme() {
        return this.interpolationScheme;
    }

    public String toString() {
        String ret = "min: " + String.valueOf(this.minVal) + ", max: " + String.valueOf(this.maxVal);
        return ret;
    }

    public float[][] getDelta() {
        return this.delta;
    }

    public void setDelta(float[][] delta) {
        this.delta = delta;
    }

    public void setDensity(float[] density) {
        this.density = density;
    }
}

