/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.DataSource;
import jas.hist.HasDataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.hist.util.ObserverAdapter;
import java.util.Observable;

public class MemoryDataSource
extends ObserverAdapter
implements HasDataSource,
Rebinnable1DHistogramData,
HasStyle {
    private static final HistogramUpdate hdr = new HistogramUpdate(2, true);
    private static final int SECONDS = 60;
    private static MemoryThread t = new MemoryThread();

    public MemoryDataSource() {
        super(t);
    }

    public DataSource getDataSource(String string) {
        return this;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[] dArray = t.getSnapshot();
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public double getMin() {
        return -60.0;
    }

    public double getMax() {
        return 0.0;
    }

    public int getBins() {
        return 60;
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return 4;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public Statistics getStatistics() {
        return null;
    }

    public String getTitle() {
        return "Java Memory Usage";
    }

    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle jASHist1DHistogramStyle = new JASHist1DHistogramStyle();
        jASHist1DHistogramStyle.setShowErrorBars(false);
        jASHist1DHistogramStyle.setShowDataPoints(true);
        jASHist1DHistogramStyle.setShowLinesBetweenPoints(true);
        jASHist1DHistogramStyle.setShowHistogramBars(false);
        return jASHist1DHistogramStyle;
    }

    private static class MemoryThread
    extends Observable
    implements Runnable {
        private Thread thread;
        private int index = 0;
        private double[] bins = new double[60];

        MemoryThread() {
            for (int i = 0; i < 60; ++i) {
                this.bins[i] = Double.NaN;
            }
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runtime runtime = Runtime.getRuntime();
                while (true) {
                    MemoryThread memoryThread = this;
                    synchronized (memoryThread) {
                        this.bins[this.index++] = (double)(runtime.totalMemory() - runtime.freeMemory()) / 1000000.0;
                        if (this.index >= 60) {
                            this.index = 0;
                        }
                    }
                    this.setChanged();
                    this.notifyObservers(hdr);
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        synchronized double[] getSnapshot() {
            int n;
            double[] dArray = new double[60];
            int n2 = 0;
            for (n = this.index; n < 60; ++n) {
                dArray[n2++] = this.bins[n];
            }
            for (n = 0; n < this.index; ++n) {
                dArray[n2++] = this.bins[n];
            }
            return dArray;
        }
    }
}

