/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class ColorInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFColor keyValueField;
    private SFColor valueField;

    public ColorInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.COLORINTERP);
        this.keyValueField = new MFColor();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFColor(0.0f, 0.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public ColorInterpolatorNode(ColorInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFColor getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFColor)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] color) {
        this.getKeyValueField().addValue(color);
    }

    public void addKeyValue(float r, float g, float b2) {
        this.getKeyValueField().addValue(r, g, b2);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] color) {
        this.getKeyValueField().set1Value(index, color);
    }

    public void setKeyValue(int index, float r, float g, float b2) {
        this.getKeyValueField().set1Value(index, r, g, b2);
    }

    public void setKeyValues(String color) {
        this.getKeyValueField().setValues(color);
    }

    public void setKeyValues(String[] color) {
        this.getKeyValueField().setValues(color);
    }

    public void getKeyValue(int index, float[] color) {
        this.getKeyValueField().get1Value(index, color);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[3];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFColor getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFColor)this.getEventOut("value");
    }

    public void setValue(float[] color) {
        this.getValueField().setValue(color);
    }

    public void setValue(String color) {
        this.getValueField().setValue(color);
    }

    public void getValue(float[] color) {
        this.getValueField().getValue(color);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        for (int n = 0; n < this.getNKeys() - 1; ++n) {
            if (!(this.getKey(n) <= fraction) || !(fraction <= this.getKey(n + 1))) continue;
            index = n;
            break;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] color1 = new float[3];
        float[] color2 = new float[3];
        float[] colorOut = new float[3];
        this.getKeyValue(index, color1);
        this.getKeyValue(index + 1, color2);
        for (int n = 0; n < 3; ++n) {
            colorOut[n] = color1[n] + (color2[n] - color1[n]) * scale;
        }
        this.setValue(colorOut);
        this.sendEvent(this.getValueField());
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(indentString + "\tkey [");
        for (int n = 0; n < this.getNKeys(); ++n) {
            if (n < this.getNKeys() - 1) {
                printStream.println(indentString + "\t\t" + this.getKey(n));
                continue;
            }
            printStream.println(indentString + "\t\t" + this.getKey(n));
        }
        printStream.println(indentString + "\t]");
        float[] color = new float[3];
        printStream.println(indentString + "\tkeyValue [");
        for (int n = 0; n < this.getNKeyValues(); ++n) {
            this.getKeyValue(n, color);
            if (n < this.getNKeyValues() - 1) {
                printStream.println(indentString + "\t\t" + color[0] + " " + color[1] + " " + color[2] + ",");
                continue;
            }
            printStream.println(indentString + "\t\t" + color[0] + " " + color[1] + " " + color[2]);
        }
        printStream.println(indentString + "\t]");
    }
}

