/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserObject;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ProjectDirBrowserNode
extends DefaultMutableTreeNode
implements Serializable,
TreeSelectionListener {
    private static Logger logger = Logger.getLogger(ProjectDirBrowserNode.class.getName());
    private ProjectInfo info;
    private Vector listeners = new Vector();
    private Element proj;
    private ProjectDirBrowser parent;
    private ProjectBrowser panel;
    private boolean bselected = false;
    private boolean bexpanded = false;
    private boolean readProjectPropertyDoc = false;

    public ProjectDirBrowserNode(Element proj, ProjectDirBrowser parent, boolean readProjectPropertyDoc) {
        this.proj = proj;
        this.parent = parent;
        this.readProjectPropertyDoc = readProjectPropertyDoc;
        String hasSub = proj.getAttributeValue("hassub");
        boolean bhasSub = false;
        if (hasSub != null) {
            bhasSub = new Boolean(hasSub);
        }
        this.info = new ProjectInfo(proj, readProjectPropertyDoc);
        ProjectDirBrowserObject o2 = new ProjectDirBrowserObject(this.info);
        super.setUserObject(o2);
        String isExpanded = proj.getAttributeValue("shouldbevisible");
        this.bexpanded = false;
        if (isExpanded != null) {
            this.bexpanded = new Boolean(isExpanded);
        }
        String isSelected = proj.getAttributeValue("selected");
        this.bselected = false;
        if (isSelected != null) {
            this.bselected = new Boolean(isSelected);
        }
    }

    public Object clone() {
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode((Element)this.proj.clone(), this.parent, this.readProjectPropertyDoc);
        nd.addProjectDirBrowserNodeChangeListener(this.parent);
        int child = this.getChildCount();
        return nd;
    }

    public boolean isSelected() {
        return this.bselected;
    }

    public boolean isExpanded() {
        return this.bexpanded;
    }

    public ProjectInfo getProjectInfo() {
        return this.info;
    }

    public Element getProjectElement() {
        return this.proj;
    }

    public void addProjectDirBrowserNodeChangeListener(ProjectDirBrowserNodeChangeListener listener) {
        this.listeners.addElement(listener);
    }

    public void selectMe() {
        try {
            this.bselected = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener)this.listeners.elementAt(i);
                listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
            }
            if (this.panel != null) {
                this.panel.setSelected(true);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public ProjectBrowser getProjectBrowser() {
        return this.panel;
    }

    public void setProjectBrowser(ProjectBrowser panel) {
        this.panel = panel;
    }

    public ProjectDirBrowser getDirBrowser() {
        return this.parent;
    }

    public void valueChanged(TreeSelectionEvent e) {
        logger.debug("button 1 pressed.");
        logger.debug(this.info);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener)this.listeners.elementAt(i);
            listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
        }
    }

    public String toString() {
        String ret = "";
        ret = ret + "name: " + this.getProjectInfo().getProjectName() + System.getProperty("line.separator");
        ret = ret + "date: " + this.getProjectInfo().getDate() + System.getProperty("line.separator");
        ret = ret + "dir: " + this.getProjectInfo().getProjectDirectory();
        String comment = this.getProjectInfo().getComment();
        if (comment != null) {
            ret = ret + System.getProperty("line.separator") + "comment: " + comment;
        }
        return ret;
    }
}

