/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class ChaseFileInfoSpec {
    private Logger logger = Logger.getLogger(ChaseFileInfoSpec.class.getName());
    private Element chaseFileInfo;
    public static String TYPE = "type";
    public static String TYPE_CHOOSABLE = "choosable";
    public static String TYPE_STR = "string";
    public static String TYPE_PATH_STR = "path_string";
    public static String TYPE_REG_STR = "regexped_string";
    public static String EDITOR = "editor";
    public static String EDITOR_COMBO = "combobox";
    public static String EDITOR_TEXTFIELD = "textfield";
    public static String EDITOR_CHECKBOX = "checkbox";
    public static String REG_HAS_REG = "hasregexp";
    public static String REG_REP_STR = "replace_string";
    public static String DEFAULT = "default";
    public static String SAVE_TO_DISK = "save_to_disk";
    private String name = "";
    private boolean save_to_disk = false;
    private String[] choices;
    private String type = TYPE_STR;
    private String editor = EDITOR_TEXTFIELD;
    private boolean editable = false;
    private String defaultValue = "";
    public static String TRUE = "true";
    public static String FALSE = "false";
    public static String NEVER = "never";
    public static String ALWAYS = "always";

    public String getName() {
        return this.name;
    }

    public boolean saveToDisk() {
        return this.save_to_disk;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String getType() {
        return this.type;
    }

    public String getEditor() {
        return this.editor;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ChaseFileInfoSpec(Element chaseFileInfo) {
        Element elemDefault;
        Element elemEditor;
        Element elemType;
        this.chaseFileInfo = chaseFileInfo;
        this.name = chaseFileInfo.getName();
        Attribute attrsave = chaseFileInfo.getAttribute("save_to_disk");
        if (attrsave != null && attrsave.getValue().equals(TRUE)) {
            this.save_to_disk = true;
        }
        if ((elemType = chaseFileInfo.getChild(TYPE)) != null) {
            this.type = elemType.getTextTrim();
            Attribute attrchoi = elemType.getAttribute("choices");
            if (attrchoi != null) {
                String ch = attrchoi.getValue();
                this.choices = ch.split(",");
            }
        }
        if ((elemEditor = chaseFileInfo.getChild(EDITOR)) != null) {
            this.editor = elemEditor.getTextTrim();
            Attribute attredi = elemEditor.getAttribute("editable");
            if (attredi != null && attredi.getValue().equals(TRUE)) {
                this.editable = true;
            }
        }
        if ((elemDefault = chaseFileInfo.getChild(DEFAULT)) != null) {
            this.defaultValue = elemDefault.getTextTrim();
        }
    }
}

