/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomEditorEditors;
import ciss.phase_viewer.atomcoord.AtomEditors;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomListener;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class AtomEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(AtomEditor.class.getName());
    protected InputInterfaceTableColumns[] columns;
    private Vector atomListeners;
    protected Atom atom;
    protected int atomIndex;
    protected boolean newAtom = false;
    private String element = "element";
    private String rx = "rx";
    private String ry = "ry";
    private String rz = "rz";
    private Vector editors = new Vector();

    public AtomEditor(InputInterfaceTableColumns[] columns, String title, Dimension dimension) {
        super(title, dimension);
        this.columns = columns;
        this.atomIndex = -1;
        this.init();
        this.setVisible(true);
    }

    public AtomEditor(InputInterfaceTableColumns[] columns, Atom atom, boolean newAtom, int atomIndex, String title, Dimension dimension) {
        super(title, dimension);
        this.columns = columns;
        this.atom = atom;
        this.atomIndex = atomIndex;
        this.newAtom = newAtom;
        this.init();
        this.setVisible(true);
    }

    public void addAtomListener(AtomListener atomListener) {
        if (this.atomListeners == null) {
            this.atomListeners = new Vector();
        }
        this.atomListeners.addElement(atomListener);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JScrollPane scr = new JScrollPane();
        int compCount = 0;
        JPanel p = null;
        int ign = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].ignoreOnSave()) continue;
            ++ign;
        }
        int foo = this.columns.length % 4;
        int dummy = 4 - foo + ign;
        if (foo - ign == 0) {
            dummy = 0;
        }
        for (int i = 0; i < this.columns.length + dummy; ++i) {
            if (compCount == 0) {
                p = new JPanel();
                p.setLayout(new GridLayout(1, 4));
            }
            if (i < this.columns.length) {
                if (this.columns[i].ignoreOnSave()) continue;
                this.logger.debug("creating gui for: " + this.columns[i].getName());
                p.add(this.createPanelFrom(this.columns[i]));
            } else {
                p.add(new JPanel());
            }
            if (++compCount != 4) continue;
            compCount = 0;
            container.add(p);
        }
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        JButton btnok = new JButton("apply");
        JButton rmv = new JButton("remove selected");
        JButton btnclose = new JButton("close");
        btnpanel.add(btnok);
        btnpanel.add(rmv);
        btnpanel.add(btnclose);
        btnok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomEditor.this.doIt();
            }
        });
        rmv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AtomEditor.this.removeSelected();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomEditor.this.dispose();
            }
        });
        container.add(btnpanel);
    }

    protected void removeSelected() {
    }

    private JPanel createPanelFrom(InputInterfaceTableColumns column) {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(column.getName()));
        AtomEditorEditors editor = AtomEditors.getInstance(column, this.atom, this);
        panel.add((JComponent)((Object)editor));
        panel.setToolTipText(column.getToolTip());
        this.editors.addElement(editor);
        return panel;
    }

    protected void setValue(Atom newAtom) {
        if (this.editors == null) {
            return;
        }
        for (int i = 0; i < this.editors.size(); ++i) {
            AtomEditorEditors edi = (AtomEditorEditors)this.editors.elementAt(i);
            edi.removeListeners();
            AtomEditors.setValue(edi, edi.getIdentifiers(), newAtom);
            edi.restoreListeners();
            this.logger.debug("atom: " + newAtom);
        }
    }

    protected void doIt() {
        if (this.atomListeners == null) {
            return;
        }
        String elem = "";
        String[] pos = new String[3];
        Vector<TaggedString> auxvec = new Vector<TaggedString>();
        for (int i = 0; i < this.editors.size(); ++i) {
            AtomEditorEditors editor = (AtomEditorEditors)this.editors.elementAt(i);
            String ident = editor.getIdentifiers();
            if (ident.equals(this.element)) {
                elem = editor.getValue();
                continue;
            }
            if (ident.equals(this.rx)) {
                pos[0] = editor.getValue();
                continue;
            }
            if (ident.equals(this.ry)) {
                pos[1] = editor.getValue();
                continue;
            }
            if (ident.equals(this.rz)) {
                pos[2] = editor.getValue();
                continue;
            }
            TaggedString aux = new TaggedString(ident, editor.getValue());
            auxvec.addElement(aux);
        }
        this.atom = new Atom(elem, pos, auxvec);
        this.logger.debug("the atom object you've created : " + this.atom);
        int ind = this.atomIndex;
        if (this.newAtom) {
            ind = -1;
        }
        AtomEvent event = new AtomEvent(this.atom, ind);
        for (int i = 0; i < this.atomListeners.size(); ++i) {
            ((AtomListener)this.atomListeners.elementAt(i)).atomStateChanged(event);
        }
        this.post();
    }

    protected void post() {
    }
}

