/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.geom;

import ciss.phase_viewer.common.VectorOperations;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class Plane
extends BranchGroup
implements Comparable {
    private Logger logger = Logger.getLogger(Plane.class.getName());
    protected Point3f origin = new Point3f(0.0f, 0.0f, 0.0f);
    protected Point3f normal = new Point3f(0.0f, 0.0f, 1.0f);
    protected Point3f origin_buff = new Point3f(this.origin);
    protected Point3f normal_buff = new Point3f(this.normal);

    public Plane() {
    }

    public Plane(Point3f normal) {
        this.normal = new Point3f(normal);
        this.normalizeNorm();
    }

    public Plane(Point3f normal, Point3f origin) {
        this.normal = new Point3f(normal);
        this.origin = new Point3f(origin);
        this.normalizeNorm();
    }

    public void normalizeNorm() {
        double[] test2 = new double[]{this.normal.x, this.normal.y, this.normal.z};
        double res = VectorOperations.norm(test2);
        if (res == 0.0) {
            this.normal.x = 0.0f;
            this.normal.y = 0.0f;
            this.normal.z = 1.0f;
            return;
        }
        this.normal.x /= (float)res;
        this.normal.y /= (float)res;
        this.normal.z /= (float)res;
    }

    public float getDistanceFrom(Point3f from) {
        double[] foo = new double[]{from.x, from.y, from.z};
        double[] normd = new double[]{this.normal.x, this.normal.y, this.normal.z};
        double[] origd = new double[]{this.origin.x, this.origin.y, this.origin.z};
        return (float)VectorOperations.getDistanceFromPlane(foo, normd, origd, true);
    }

    public Point3f getNormalVector() {
        return this.normal;
    }

    public Point3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point3f origin) {
        this.origin = origin;
    }

    public void setNormalVector(Point3f normal) {
        this.normal = normal;
        this.normalizeNorm();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Plane)) {
            return -1;
        }
        Plane pl = (Plane)o;
        Point3f orig = pl.getOrigin();
        float disto = orig.distance(new Point3f());
        float distthis = this.origin.distance(new Point3f());
        if (distthis - disto < 0.0f) {
            return -1;
        }
        if (disto == distthis) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        float distthis;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Plane)) {
            return false;
        }
        Plane pl = (Plane)obj;
        Point3f orig = pl.getOrigin();
        float disto = orig.distance(new Point3f());
        return disto == (distthis = this.origin.distance(new Point3f()));
    }
}

