/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.fbz.FBZUtils;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointBG;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class SymmetryPoint
extends Sphere {
    private Logger logger = Logger.getLogger(SymmetryPoint.class.getName());
    private Appearance appearance;
    private Material material;
    private Color3f selectedColor = new Color3f(1.0f, 0.8f, 0.4f);
    private Color3f unselectedColor = new Color3f(0.0f, 0.2f, 0.6f);
    private WignerSeitzAttributes wsattrs;
    private SymmetryPointBG parent;
    private boolean selected = false;

    public SymmetryPoint(float rad, WignerSeitzAttributes wsattrs) {
        super(rad);
        if (wsattrs != null) {
            this.unselectedColor = wsattrs.symmetricPointColor;
            this.selectedColor = wsattrs.selectedSymmetricPointColor;
        }
        this.appearance = new Appearance();
        this.material = new Material();
        this.material.setCapability(1);
        this.material.setCapability(0);
        this.material.setDiffuseColor(this.unselectedColor);
        this.appearance.setMaterial(this.material);
        this.appearance.setCapability(1);
        this.setAppearance(this.appearance);
        this.getShape().setCapability(15);
        this.getShape().setCapability(16);
        this.getShape().setCapability(17);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(15);
    }

    void setBG(SymmetryPointBG parent) {
        this.parent = parent;
    }

    public SymmetryPointBG getParentBG() {
        return this.parent;
    }

    public void toggleSelected() {
        this.selected = !this.selected;
        this.doSelection();
    }

    private void doSelection() {
        if (this.selected) {
            this.material.setDiffuseColor(this.selectedColor);
        } else {
            this.material.setDiffuseColor(this.unselectedColor);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.doSelection();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        Vector3f v3f = this.parent.getPos();
        int[] xbunsu = FBZUtils.getBunsu(v3f.x);
        int[] ybunsu = FBZUtils.getBunsu(v3f.y);
        int[] zbunsu = FBZUtils.getBunsu(v3f.z);
        String str = "pos: " + xbunsu[1] + "/" + xbunsu[2] + ", " + ybunsu[1] + "/" + ybunsu[2] + ", " + zbunsu[1] + "/" + zbunsu[2];
        return str;
    }
}

