/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.atomcoord.VolumetricData;
import org.apache.log4j.Logger;

public class FBZTransform
extends ChaseTransformGroup {
    private Logger logger = Logger.getLogger(FBZTransform.class.getName());
    private FBZ fbz;

    public FBZTransform(FBZ fbz) {
        this.fbz = fbz;
    }

    public float[][] getEffectiveBounds() {
        float[][] rl = this.fbz.getReciprocalLatticeVector();
        float[][] ret = new float[3][3];
        VolumetricData[] data = this.fbz.getAssociatedVolumetricData();
        if (data == null || data.length == 0) {
            return null;
        }
        float[] orig = data[0].getOrigin();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ret[i][j] = rl[i][j] * 0.5f + orig[j];
            }
        }
        return ret;
    }
}

