/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.Vector;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.Cell;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.TableForNonTabularData;
import jp.advancesoft.chase.phase.TableModelForNonTabularData;
import org.apache.log4j.Logger;

class TableModelForCellPanel
extends TableModelForNonTabularData {
    private static Logger logger = Logger.getLogger(TableModelForCellPanel.class.getName());
    private AtomCoords coords;

    protected TableModelForCellPanel(TableForNonTabularData table, Object[][] rowData, Object[] columnNames, AtomCoords coords) {
        super(table, rowData, columnNames);
        this.coords = coords;
    }

    public void post(String[] columnNames, Vector entries) {
        int size = entries.size();
        String[][] cellstr1 = new String[3][3];
        String[] cellstr2 = new String[6];
        int icellscheme = -1;
        for (int i = 0; i < size; ++i) {
            InputInterfacePrimitiveEntry entry = (InputInterfacePrimitiveEntry)entries.get(i);
            String value = entry.getValue();
            String[] values = value.split("\\s+");
            if (values == null) continue;
            if (values.length >= 3) {
                cellstr1[i][0] = values[0].trim();
                cellstr1[i][1] = values[1].trim();
                cellstr1[i][2] = values[2].trim();
                icellscheme = 0;
                continue;
            }
            if (values.length != 1) continue;
            cellstr2[i] = values[0].trim();
            icellscheme = 1;
        }
        if (icellscheme == 0) {
            Cell cell1 = new Cell(cellstr1[0], cellstr1[1], cellstr1[2]);
            this.coords.setCell(cell1);
            this.coords.debug();
        } else if (icellscheme == 1) {
            Cell cell2 = new Cell(cellstr2[0], cellstr2[1], cellstr2[2], cellstr2[3], cellstr2[4], cellstr2[5]);
            this.coords.setCell(cell2);
            this.coords.debug();
        }
    }
}

