/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import jp.advancesoft.chase.mainpanel.ChaseDesktop;
import jp.advancesoft.chase.mainpanel.ChaseFrame;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public abstract class AbstractInternalFrameChase
extends JInternalFrame
implements ChaseFrame {
    private int location = 0;
    private static Logger logger = Logger.getLogger(AbstractInternalFrameChase.class.getName());
    protected GlobalProperties props = PropertiesManager.getGlobalProperties(0);
    private boolean initVisible = true;
    private boolean deiconfiedBySelect = false;
    private String ident;

    public AbstractInternalFrameChase() {
        super("");
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(Dimension size) {
        super("");
        this.initIFC();
        this.setSize(size);
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title) {
        super(title);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1) {
        super(title, b1);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2) {
        super(title, b1, b2);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3) {
        super(title, b1, b2, b3);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4) {
        super(title, b1, b2, b3, b4);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4, Dimension size) {
        super(title, b1, b2, b3, b4);
        this.setSize(size);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4, Dimension size, boolean initVisible) {
        super(title, b1, b2, b3, b4);
        this.location = this.location;
        this.initVisible = initVisible;
        this.setSize(size);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4, int location) {
        super(title, b1, b2, b3, b4);
        this.location = location;
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4, Dimension size, int location) {
        super(title, b1, b2, b3, b4);
        this.location = location;
        this.setSize(size);
        this.initIFC();
        this.addListeners();
    }

    public AbstractInternalFrameChase(String title, boolean b1, boolean b2, boolean b3, boolean b4, Dimension size, int location, boolean initVisible) {
        super(title, b1, b2, b3, b4);
        this.location = location;
        this.initVisible = initVisible;
        this.setSize(size);
        this.initIFC();
        this.addListeners();
    }

    private void initIFC() {
        Desktop.getDesktop().add(this);
        this.ident = AbstractInternalFrameChase.class.getName() + "." + this.getTitle();
        String winx = this.ident + ".window_size_x";
        String winy = this.ident + ".window_size_y";
        GlobalProperties props = PropertiesManager.getGlobalProperties(6);
        try {
            int sizex = Integer.parseInt(props.getProperty(winx));
            int sizey = Integer.parseInt(props.getProperty(winy));
            this.setSize(sizex, sizey);
        }
        catch (Exception exc) {
            // empty catch block
        }
        String listen = props.getProperty("listen_to_component");
        if (listen == null || !listen.trim().equals("false")) {
            super.addComponentListener(new ComponentListenerChase(this));
        }
        ((ChaseDesktop)((Object)Desktop.getDesktop())).initialLocation(this, this.location);
        if (this.initVisible) {
            this.setVisible(true);
        }
        JPanel dummy = new JPanel();
        this.getContentPane().add(dummy);
    }

    abstract void addListeners();

    public ChaseDesktop getDesktop() {
        return (ChaseDesktop)((Object)Desktop.getDesktop());
    }

    public void selected() {
        this.selected(false);
    }

    public void selected(boolean initialize) {
        if (this.isIcon()) {
            try {
                this.setIcon(false);
                this.deiconfiedBySelect = true;
            }
            catch (PropertyVetoException ex) {
                logger.warn("failed to select frame: " + this.getTitle());
            }
        }
        try {
            if (!this.isSelected()) {
                this.setSelected(true);
            }
        }
        catch (PropertyVetoException ex) {
            logger.warn("failed to select frame: " + this.getTitle());
        }
        if (initialize) {
            this.deiconfiedBySelect = false;
        }
        this.checkBounds(((Desktop)Desktop.getDesktop()).getScrollPane().getViewport());
    }

    public void unselect() {
        try {
            this.setSelected(false);
            if (this.deiconfiedBySelect) {
                try {
                    this.setIcon(true);
                    this.deiconfiedBySelect = false;
                }
                catch (PropertyVetoException ex) {
                    logger.warn("couldn't iconfy frame: " + this.getTitle());
                    System.out.println("couldn't iconfy frame: " + this.getTitle());
                    this.deiconfiedBySelect = false;
                }
            }
        }
        catch (PropertyVetoException ex) {
            logger.warn("failed to 'un' select frame: " + this.getTitle());
        }
    }

    protected void checkBounds(JViewport viewport) {
        String check = PropertiesManager.getGlobalProperties(0).getProperty("check_bounds_internal_frame");
        if (check != null && check.trim().equals("false")) {
            return;
        }
        int viewxmin = viewport.getViewPosition().x;
        int viewymin = viewport.getViewPosition().y;
        int viewxmax = viewxmin + viewport.getExtentSize().width;
        int viewymax = viewymin + viewport.getExtentSize().height;
        int framexmin = this.getLocation().x;
        int frameymin = this.getLocation().y;
        int framexmax = framexmin + this.getWidth();
        int frameymax = frameymin + this.getHeight();
        logger.debug("bounding box of viewport: " + viewxmin + " " + viewymin + " " + viewxmax + " " + viewymax);
        logger.debug("bounding box of frame: " + framexmin + " " + frameymin + " " + framexmax + " " + frameymax);
        if (framexmin >= viewxmin && frameymin >= viewymin && framexmax <= viewxmax && frameymax <= viewymax) {
            logger.debug("frame is not out of bounds.");
            return;
        }
        logger.debug("frame is out of bounds.");
        int posx = viewxmin;
        int posy = viewymin;
        if (framexmax > viewxmax) {
            posx = posx + framexmax - viewxmax;
        }
        if (frameymax > viewymax) {
            posy = posy + frameymax - viewymax;
        }
        if (framexmin < viewxmin) {
            posx = posx + framexmin - viewxmin;
        }
        if (frameymin < viewymin) {
            posy = posy + frameymin - viewymin;
        }
        logger.debug("setting view position at: " + posx + " " + posy);
        logger.debug("framemax: " + framexmax + " " + frameymax);
        viewport.setViewPosition(new Point(posx, posy));
        Desktop.getDesktop().revalidate();
    }

    public void saveState() {
    }

    class ComponentListenerChase
    implements ComponentListener {
        private Logger logger = Logger.getLogger(ComponentListenerChase.class.getName());
        private ChaseDesktop desktop;

        public ComponentListenerChase(ChaseFrame parent) {
            this.desktop = parent.getDesktop();
        }

        public void componentHidden(ComponentEvent e) {
            this.desktop.componentHidden();
        }

        public void componentMoved(ComponentEvent e) {
            this.desktop.componentMoved();
            this.checkBounds(e);
        }

        public void componentResized(ComponentEvent e) {
            this.desktop.componentResized();
            Dimension dim = e.getComponent().getSize();
            this.logger.debug("size of component: " + dim.width + ", " + dim.height);
            this.checkBounds(e);
            String winx = AbstractInternalFrameChase.this.ident + ".window_size_x";
            String winy = AbstractInternalFrameChase.this.ident + ".window_size_y";
            GlobalProperties props = PropertiesManager.getGlobalProperties(6);
            props.setProperty(winx, String.valueOf(AbstractInternalFrameChase.this.getSize().width));
            props.setProperty(winy, String.valueOf(AbstractInternalFrameChase.this.getSize().height));
            props.storeProperty();
        }

        public void componentShown(ComponentEvent e) {
            this.desktop.componentShown();
            this.checkBounds(e);
        }

        private void checkBounds(ComponentEvent e) {
            ChaseFrame fr = (ChaseFrame)e.getSource();
            fr.selected();
        }
    }
}

