/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ColorChooser;
import jas.util.ColorEvent;
import jas.util.ColorListener;
import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.Color;

class ColorFieldBinding
extends FieldBinding
implements ColorListener {
    private Color m_oldVal = Color.black;
    private ColorChooser m_field;

    ColorFieldBinding(ColorChooser colorChooser) {
        this.m_field = colorChooser;
        colorChooser.addColorListener(this);
    }

    void set(Object object) throws UnsupportedType {
        if (!(object instanceof Color)) {
            throw new UnsupportedType(this.m_field, object.getClass());
        }
        Color color = (Color)object;
        if (!this.m_oldVal.equals(color)) {
            this.m_field.setColor(color);
            this.m_oldVal = color;
        }
    }

    Object get(Class clazz) throws UnsupportedType {
        Color color = this.m_field.getColor();
        if (!clazz.isInstance(color)) {
            throw new UnsupportedType(this.m_field, clazz);
        }
        return color;
    }

    public void colorChanged(ColorEvent colorEvent) {
        Color color = this.m_field.getColor();
        if (color != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getColor();
    }
}

