/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.util.Hashtable;

public final class ColorConverter {
    private Hashtable stringToColor = new Hashtable();
    private Hashtable colorToString = new Hashtable();
    private static ColorConverter cc = new ColorConverter();

    static final Color hexToColor(String string) throws ColorConversionException {
        try {
            return Color.decode("0x" + string.substring(1));
        }
        catch (Throwable throwable) {
            throw new ColorConversionException(string);
        }
    }

    static final Color rgbToColor(String string) throws ColorConversionException {
        int n = string.indexOf(",");
        int n2 = string.indexOf(",", n + 1);
        if (n < 2 || n2 < n + 2 || string.length() < n + 2) {
            throw new ColorConversionException(string);
        }
        try {
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1, string.length() - 1);
            int n3 = Integer.parseInt(string2);
            int n4 = Integer.parseInt(string3);
            int n5 = Integer.parseInt(string4);
            return new Color(n3, n4, n5);
        }
        catch (Throwable throwable) {
            throw new ColorConversionException(string);
        }
    }

    public static Color stringToHTMLColor(String string) throws ColorConversionException {
        if (string == null || string.equals("") || string.equals("default")) {
            return null;
        }
        if (string.charAt(0) == '#') {
            return ColorConverter.hexToColor(string);
        }
        if (string.charAt(0) == '(') {
            return ColorConverter.rgbToColor(string);
        }
        Color color = (Color)ColorConverter.cc.stringToColor.get(string.toLowerCase());
        if (color == null) {
            throw new ColorConversionException(string);
        }
        return color;
    }

    public static String colorToString(Color color) {
        if (color == null) {
            return "default";
        }
        String string = (String)ColorConverter.cc.colorToString.get(color);
        if (string != null) {
            return string;
        }
        return "(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private ColorConverter() {
        this.addEntry(Color.black, "Black");
        this.addEntry(Color.blue, "Blue");
        this.addEntry(Color.cyan, "Cyan");
        this.addEntry(Color.darkGray, "Dark Gray");
        this.addEntry(Color.gray, "Gray");
        this.addEntry(Color.green, "Green");
        this.addEntry(Color.lightGray, "Light Gray");
        this.addEntry(Color.magenta, "Magenta");
        this.addEntry(Color.orange, "Orange");
        this.addEntry(Color.pink, "Pink");
        this.addEntry(Color.red, "Red");
        this.addEntry(Color.white, "White");
        this.addEntry(Color.yellow, "Yellow");
        this.addEntry(new Color(0, 0, 0), "Black");
        this.addEntry(new Color(192, 192, 192), "Silver");
        this.addEntry(new Color(128, 128, 128), "Gray");
        this.addEntry(new Color(255, 255, 255), "White");
        this.addEntry(new Color(128, 0, 0), "Maroon");
        this.addEntry(new Color(255, 0, 0), "Red");
        this.addEntry(new Color(128, 0, 128), "Purple");
        this.addEntry(new Color(255, 0, 255), "Fuchsia");
        this.addEntry(new Color(0, 128, 0), "Green");
        this.addEntry(new Color(0, 255, 0), "Lime");
        this.addEntry(new Color(128, 128, 0), "Olive");
        this.addEntry(new Color(255, 255, 0), "Yellow");
        this.addEntry(new Color(0, 0, 128), "Navy");
        this.addEntry(new Color(0, 0, 255), "Blue");
        this.addEntry(new Color(0, 128, 128), "Teal");
        this.addEntry(new Color(0, 255, 255), "Aqua");
        this.addEntry(new Color(0.1f, 0.1f, 0.1f), "Gray 10%");
        this.addEntry(new Color(0.2f, 0.2f, 0.2f), "Gray 20%");
        this.addEntry(new Color(0.3f, 0.3f, 0.3f), "Gray 30%");
        this.addEntry(new Color(0.4f, 0.4f, 0.4f), "Gray 40%");
        this.addEntry(new Color(0.5f, 0.5f, 0.5f), "Gray 50%");
        this.addEntry(new Color(0.6f, 0.6f, 0.6f), "Gray 60%");
        this.addEntry(new Color(0.7f, 0.7f, 0.7f), "Gray 70%");
        this.addEntry(new Color(0.8f, 0.8f, 0.8f), "Gray 80%");
        this.addEntry(new Color(0.9f, 0.9f, 0.9f), "Gray 90%");
        this.addEntry(new Color(255, 136, 28), "Orange");
        this.addEntry(new Color(120, 62, 27), "Brown");
        this.addEntry(new Color(0, 125, 32), "Forest Green");
        this.addEntry(new Color(11, 157, 150), "Turquoise");
        this.addEntry(new Color(109, 0, 168), "Purple");
        this.addEntry(new Color(168, 0, 126), "Magenta");
        this.addEntry(new Color(164, 207, 255), "Sky Blue");
        this.addEntry(new Color(225, 170, 255), "Violet");
        this.addEntry(new Color(255, 170, 210), "Light Magenta");
    }

    private void addEntry(Color color, String string) {
        this.stringToColor.put(string.toLowerCase(), color);
        this.colorToString.put(color, string);
    }

    public static class ColorConversionException
    extends Exception {
        ColorConversionException(String string) {
            super("Cannot convert " + string + " to Color");
        }
    }
}

