/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CheckBoxBorderPanel
extends JPanel
implements ItemListener {
    private JCheckBox checkbox;

    public CheckBoxBorderPanel(String string) {
        this(string, null, null);
    }

    public CheckBoxBorderPanel(String string, Border border) {
        this(string, border, null);
    }

    public CheckBoxBorderPanel(String string, LayoutManager layoutManager) {
        this(string, null, layoutManager);
    }

    public CheckBoxBorderPanel(String string, Border border, LayoutManager layoutManager) {
        if (layoutManager == null) {
            layoutManager = new FlowLayout();
        }
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        this.checkbox = new JCheckBox(string);
        this.setLayout(layoutManager);
        this.setBorder(border);
        this.add((Component)this.checkbox, 0);
        this.checkbox.addItemListener(this);
    }

    public void doLayout() {
        this.setEnabled();
        this.checkbox.setVisible(false);
        super.doLayout();
        this.checkbox.setVisible(true);
        Dimension dimension = this.checkbox.getPreferredSize();
        this.checkbox.setSize(dimension);
        this.checkbox.setLocation(20, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setEnabled();
    }

    private void setEnabled() {
        boolean bl = this.checkbox.isSelected();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this.checkbox) continue;
            componentArray[i].setEnabled(bl);
        }
    }

    public void setBorder(Border border) {
        super.setBorder(border == null ? null : new CBBorder(border));
    }

    public JCheckBox getCheckBox() {
        return this.checkbox;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        CheckBoxBorderPanel checkBoxBorderPanel = new CheckBoxBorderPanel("test");
        checkBoxBorderPanel.add(new JButton("Test"));
        jFrame.setContentPane(checkBoxBorderPanel);
        jFrame.setSize(200, 200);
        jFrame.show();
    }

    private class CBBorder
    implements Border {
        private Border child;

        CBBorder(Border border) {
            this.child = border;
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = (Insets)this.child.getBorderInsets(component).clone();
            insets.top = ((CheckBoxBorderPanel)CheckBoxBorderPanel.this).checkbox.getPreferredSize().height;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = ((CheckBoxBorderPanel)CheckBoxBorderPanel.this).checkbox.getPreferredSize().height / 2;
            this.child.paintBorder(component, graphics, n, n2 += n5, n3, n4 -= n5);
        }
    }
}

