/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserTransformation;

class InitialGradientCalculator {
    private MnFcn theFcn;
    private MnUserTransformation theTransformation;
    private MnStrategy theStrategy;

    InitialGradientCalculator(MnFcn fcn, MnUserTransformation par, MnStrategy stra) {
        this.theFcn = fcn;
        this.theTransformation = par;
        this.theStrategy = stra;
    }

    FunctionGradient gradient(MinimumParameters par) {
        if (!par.isValid()) {
            throw new IllegalArgumentException("Parameters are invalid");
        }
        int n = this.trafo().variableParameters();
        if (n != par.vec().size()) {
            throw new IllegalArgumentException("Parameters have invalid size");
        }
        MnAlgebraicVector gr = new MnAlgebraicVector(n);
        MnAlgebraicVector gr2 = new MnAlgebraicVector(n);
        MnAlgebraicVector gst = new MnAlgebraicVector(n);
        for (int i = 0; i < n; ++i) {
            int exOfIn = this.trafo().extOfInt(i);
            double var = par.vec().get(i);
            double werr = this.trafo().parameter(exOfIn).error();
            double sav = this.trafo().int2ext(i, var);
            double sav2 = sav + werr;
            if (this.trafo().parameter(exOfIn).hasLimits() && this.trafo().parameter(exOfIn).hasUpperLimit() && sav2 > this.trafo().parameter(exOfIn).upperLimit()) {
                sav2 = this.trafo().parameter(exOfIn).upperLimit();
            }
            double var2 = this.trafo().ext2int(exOfIn, sav2);
            double vplu = var2 - var;
            sav2 = sav - werr;
            if (this.trafo().parameter(exOfIn).hasLimits() && this.trafo().parameter(exOfIn).hasLowerLimit() && sav2 < this.trafo().parameter(exOfIn).lowerLimit()) {
                sav2 = this.trafo().parameter(exOfIn).lowerLimit();
            }
            var2 = this.trafo().ext2int(exOfIn, sav2);
            double vmin = var2 - var;
            double dirin = 0.5 * (Math.abs(vplu) + Math.abs(vmin));
            double g2 = 2.0 * this.theFcn.errorDef() / (dirin * dirin);
            double gsmin = 8.0 * this.precision().eps2() * (Math.abs(var) + this.precision().eps2());
            double gstep = Math.max(gsmin, 0.1 * dirin);
            double grd = g2 * dirin;
            if (this.trafo().parameter(exOfIn).hasLimits() && gstep > 0.5) {
                gstep = 0.5;
            }
            gr.set(i, grd);
            gr2.set(i, g2);
            gst.set(i, gstep);
        }
        return new FunctionGradient(gr, gr2, gst);
    }

    FunctionGradient gradient(MinimumParameters par, FunctionGradient gra) {
        return this.gradient(par);
    }

    MnFcn fcn() {
        return this.theFcn;
    }

    MnUserTransformation trafo() {
        return this.theTransformation;
    }

    MnMachinePrecision precision() {
        return this.theTransformation.precision();
    }

    MnStrategy strategy() {
        return this.theStrategy;
    }

    int ncycle() {
        return this.strategy().gradientNCycles();
    }

    double stepTolerance() {
        return this.strategy().gradientStepTolerance();
    }

    double gradTolerance() {
        return this.strategy().gradientTolerance();
    }
}

