/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumBuilder;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.SimplexMinimizer;
import org.freehep.math.minuit.VariableMetricMinimizer;

class CombinedMinimumBuilder
implements MinimumBuilder {
    private VariableMetricMinimizer theVMMinimizer = new VariableMetricMinimizer();
    private SimplexMinimizer theSimplexMinimizer = new SimplexMinimizer();

    CombinedMinimumBuilder() {
    }

    public FunctionMinimum minimum(MnFcn fcn, GradientCalculator gc, MinimumSeed seed, MnStrategy strategy, int maxfcn, double toler) {
        FunctionMinimum min = this.theVMMinimizer.minimize(fcn, gc, seed, strategy, maxfcn, toler);
        if (!min.isValid()) {
            System.err.println("CombinedMinimumBuilder: migrad method fails, will try with simplex method first.");
            MnStrategy str = new MnStrategy(2);
            FunctionMinimum min1 = this.theSimplexMinimizer.minimize(fcn, gc, seed, str, maxfcn, toler);
            if (!min1.isValid()) {
                System.err.println("CombinedMinimumBuilder: both migrad and simplex method fail.");
                return min1;
            }
            MinimumSeed seed1 = this.theVMMinimizer.seedGenerator().generate(fcn, gc, min1.userState(), str);
            FunctionMinimum min2 = this.theVMMinimizer.minimize(fcn, gc, seed1, str, maxfcn, toler);
            if (!min2.isValid()) {
                System.err.println("CombinedMinimumBuilder: both migrad and method fails also at 2nd attempt.");
                System.err.println("CombinedMinimumBuilder: return simplex minimum.");
                return min1;
            }
            return min2;
        }
        return min;
    }
}

