/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MnMachinePrecision;

class SqrtUpParameterTransformation {
    SqrtUpParameterTransformation() {
    }

    double int2ext(double value, double upper) {
        return upper + 1.0 - Math.sqrt(value * value + 1.0);
    }

    double ext2int(double value, double upper, MnMachinePrecision prec) {
        double yy = upper - value + 1.0;
        double yy2 = yy * yy;
        if (yy2 < 1.0 + prec.eps2()) {
            return 8.0 * Math.sqrt(prec.eps2());
        }
        return Math.sqrt(yy2 - 1.0);
    }

    double dInt2Ext(double value, double upper) {
        return -value / Math.sqrt(value * value + 1.0);
    }
}

