/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MnCross;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnMigrad;
import org.freehep.math.minuit.MnParabola;
import org.freehep.math.minuit.MnParabolaFactory;
import org.freehep.math.minuit.MnParabolaPoint;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;

class MnFunctionCross {
    private FCNBase theFCN;
    private MnUserParameterState theState;
    private double theFval;
    private MnStrategy theStrategy;
    private double theErrorDef;

    MnFunctionCross(FCNBase fcn, MnUserParameterState state, double fval, MnStrategy stra, double errorDef) {
        this.theFCN = fcn;
        this.theState = state;
        this.theFval = fval;
        this.theStrategy = stra;
        this.theErrorDef = errorDef;
    }

    MnCross cross(int[] par, double[] pmid, double[] pdir, double tlr, int maxcalls) {
        int npar = par.length;
        int nfcn = 0;
        MnMachinePrecision prec = this.theState.precision();
        double tlf = tlr * this.theErrorDef;
        double tla = tlr;
        int maxitr = 15;
        int ipt = 0;
        double aminsv = this.theFval;
        double aim = aminsv + this.theErrorDef;
        double aopt = 0.0;
        boolean limset = false;
        double[] alsb = new double[3];
        double[] flsb = new double[3];
        double up = this.theErrorDef;
        double aulim = 100.0;
        for (int i = 0; i < par.length; ++i) {
            double zlim;
            int kex = par[i];
            if (!this.theState.parameter(kex).hasLimits()) continue;
            double zmid = pmid[i];
            double zdir = pdir[i];
            if (Math.abs(zdir) < this.theState.precision().eps()) continue;
            if (zdir > 0.0 && this.theState.parameter(kex).hasUpperLimit()) {
                zlim = this.theState.parameter(kex).upperLimit();
                aulim = Math.min(aulim, (zlim - zmid) / zdir);
                continue;
            }
            if (!(zdir < 0.0) || !this.theState.parameter(kex).hasLowerLimit()) continue;
            zlim = this.theState.parameter(kex).lowerLimit();
            aulim = Math.min(aulim, (zlim - zmid) / zdir);
        }
        if (aulim < aopt + tla) {
            limset = true;
        }
        MnMigrad migrad = new MnMigrad(this.theFCN, this.theState, new MnStrategy(Math.max(0, this.theStrategy.strategy() - 1)));
        for (int i = 0; i < npar; ++i) {
            migrad.setValue(par[i], pmid[i]);
        }
        FunctionMinimum min0 = migrad.minimize(maxcalls, tlr);
        nfcn += min0.nfcn();
        if (min0.hasReachedCallLimit()) {
            return new MnCross(min0.userState(), nfcn, new MnCross.CrossFcnLimit());
        }
        if (!min0.isValid()) {
            return new MnCross(nfcn);
        }
        if (limset && min0.fval() < aim) {
            return new MnCross(min0.userState(), nfcn, new MnCross.CrossParLimit());
        }
        ++ipt;
        alsb[0] = 0.0;
        flsb[0] = min0.fval();
        flsb[0] = Math.max(flsb[0], aminsv + 0.1 * up);
        aopt = Math.sqrt(up / (flsb[0] - aminsv)) - 1.0;
        if (Math.abs(flsb[0] - aim) < tlf) {
            return new MnCross(aopt, min0.userState(), nfcn);
        }
        if (aopt > 1.0) {
            aopt = 1.0;
        }
        if (aopt < -0.5) {
            aopt = -0.5;
        }
        limset = false;
        if (aopt > aulim) {
            aopt = aulim;
            limset = true;
        }
        for (int i = 0; i < npar; ++i) {
            migrad.setValue(par[i], pmid[i] + aopt * pdir[i]);
        }
        FunctionMinimum min1 = migrad.minimize(maxcalls, tlr);
        nfcn += min1.nfcn();
        if (min1.hasReachedCallLimit()) {
            return new MnCross(min1.userState(), nfcn, new MnCross.CrossFcnLimit());
        }
        if (!min1.isValid()) {
            return new MnCross(nfcn);
        }
        if (limset && min1.fval() < aim) {
            return new MnCross(min1.userState(), nfcn, new MnCross.CrossParLimit());
        }
        ++ipt;
        alsb[1] = aopt;
        flsb[1] = min1.fval();
        double dfda = (flsb[1] - flsb[0]) / (alsb[1] - alsb[0]);
        double ecarmn = 0.0;
        double ecarmx = 0.0;
        int ibest = 0;
        int iworst = 0;
        int noless = 0;
        FunctionMinimum min2 = null;
        block3: while (true) {
            if (dfda < 0.0) {
                int maxlk = maxitr - ipt;
                for (int it = 0; it < maxlk; ++it) {
                    alsb[0] = alsb[1];
                    flsb[0] = flsb[1];
                    aopt = alsb[0] + 0.2 * (double)it;
                    limset = false;
                    if (aopt > aulim) {
                        aopt = aulim;
                        limset = true;
                    }
                    for (int i = 0; i < npar; ++i) {
                        migrad.setValue(par[i], pmid[i] + aopt * pdir[i]);
                    }
                    min1 = migrad.minimize(maxcalls, tlr);
                    nfcn += min1.nfcn();
                    if (min1.hasReachedCallLimit()) {
                        return new MnCross(min1.userState(), nfcn, new MnCross.CrossFcnLimit());
                    }
                    if (!min1.isValid()) {
                        return new MnCross(nfcn);
                    }
                    if (limset && min1.fval() < aim) {
                        return new MnCross(min1.userState(), nfcn, new MnCross.CrossParLimit());
                    }
                    ++ipt;
                    alsb[1] = aopt;
                    flsb[1] = min1.fval();
                    dfda = (flsb[1] - flsb[0]) / (alsb[1] - alsb[0]);
                    if (dfda > 0.0) break;
                }
                if (ipt > maxitr) {
                    return new MnCross(nfcn);
                }
            }
            while (true) {
                int i;
                double bmax;
                aopt = alsb[1] + (aim - flsb[1]) / dfda;
                double fdist = Math.min(Math.abs(aim - flsb[0]), Math.abs(aim - flsb[1]));
                double adist = Math.min(Math.abs(aopt - alsb[0]), Math.abs(aopt - alsb[1]));
                tla = tlr;
                if (Math.abs(aopt) > 1.0) {
                    tla = tlr * Math.abs(aopt);
                }
                if (adist < tla && fdist < tlf) {
                    return new MnCross(aopt, min1.userState(), nfcn);
                }
                if (ipt > maxitr) {
                    return new MnCross(nfcn);
                }
                double bmin = Math.min(alsb[0], alsb[1]) - 1.0;
                if (aopt < bmin) {
                    aopt = bmin;
                }
                if (aopt > (bmax = Math.max(alsb[0], alsb[1]) + 1.0)) {
                    aopt = bmax;
                }
                limset = false;
                if (aopt > aulim) {
                    aopt = aulim;
                    limset = true;
                }
                for (i = 0; i < npar; ++i) {
                    migrad.setValue(par[i], pmid[i] + aopt * pdir[i]);
                }
                min2 = migrad.minimize(maxcalls, tlr);
                nfcn += min2.nfcn();
                if (min2.hasReachedCallLimit()) {
                    return new MnCross(min2.userState(), nfcn, new MnCross.CrossFcnLimit());
                }
                if (!min2.isValid()) {
                    return new MnCross(nfcn);
                }
                if (limset && min2.fval() < aim) {
                    return new MnCross(min2.userState(), nfcn, new MnCross.CrossParLimit());
                }
                ++ipt;
                alsb[2] = aopt;
                flsb[2] = min2.fval();
                ecarmn = Math.abs(flsb[2] - aim);
                ecarmx = 0.0;
                ibest = 2;
                iworst = 0;
                noless = 0;
                for (i = 0; i < 3; ++i) {
                    double ecart = Math.abs(flsb[i] - aim);
                    if (ecart > ecarmx) {
                        ecarmx = ecart;
                        iworst = i;
                    }
                    if (ecart < ecarmn) {
                        ecarmn = ecart;
                        ibest = i;
                    }
                    if (!(flsb[i] < aim)) continue;
                    ++noless;
                }
                if (noless == true || noless == 2) break block3;
                if (noless == 0 && ibest != 2) {
                    return new MnCross(nfcn);
                }
                if (noless == 3 && ibest != 2) {
                    alsb[1] = alsb[2];
                    flsb[1] = flsb[2];
                    continue block3;
                }
                flsb[iworst] = flsb[2];
                alsb[iworst] = alsb[2];
                dfda = (flsb[1] - flsb[0]) / (alsb[1] - alsb[0]);
            }
            break;
        }
        do {
            double smalla;
            double x2;
            double s2;
            double coeff3;
            MnParabola parbol = MnParabolaFactory.create(new MnParabolaPoint(alsb[0], flsb[0]), new MnParabolaPoint(alsb[1], flsb[1]), new MnParabolaPoint(alsb[2], flsb[2]));
            double coeff1 = parbol.c();
            double coeff2 = parbol.b();
            double determ = coeff2 * coeff2 - 4.0 * (coeff3 = parbol.a()) * (coeff1 - aim);
            if (determ < prec.eps()) {
                return new MnCross(nfcn);
            }
            double rt = Math.sqrt(determ);
            double x1 = (-coeff2 + rt) / (2.0 * coeff3);
            double s1 = coeff2 + 2.0 * x1 * coeff3;
            if (s1 * (s2 = coeff2 + 2.0 * (x2 = (-coeff2 - rt) / (2.0 * coeff3)) * coeff3) > 0.0) {
                System.err.println("MnFunctionCross problem 1");
            }
            aopt = x1;
            double slope = s1;
            if (s2 > 0.0) {
                aopt = x2;
                slope = s2;
            }
            tla = tlr;
            if (Math.abs(aopt) > 1.0) {
                tla = tlr * Math.abs(aopt);
            }
            if (Math.abs(aopt - alsb[ibest]) < tla && Math.abs(flsb[ibest] - aim) < tlf) {
                return new MnCross(aopt, min2.userState(), nfcn);
            }
            int ileft = 3;
            int iright = 3;
            int iout = 3;
            ibest = 0;
            ecarmx = 0.0;
            ecarmn = Math.abs(aim - flsb[0]);
            for (int i = 0; i < 3; ++i) {
                double ecart = Math.abs(flsb[i] - aim);
                if (ecart < ecarmn) {
                    ecarmn = ecart;
                    ibest = i;
                }
                if (ecart > ecarmx) {
                    ecarmx = ecart;
                }
                if (flsb[i] > aim) {
                    if (iright == 3) {
                        iright = i;
                        continue;
                    }
                    if (flsb[i] > flsb[iright]) {
                        iout = i;
                        continue;
                    }
                    iout = iright;
                    iright = i;
                    continue;
                }
                if (ileft == 3) {
                    ileft = i;
                    continue;
                }
                if (flsb[i] < flsb[ileft]) {
                    iout = i;
                    continue;
                }
                iout = ileft;
                ileft = i;
            }
            if (ecarmx > 10.0 * Math.abs(flsb[iout] - aim)) {
                aopt = 0.5 * (aopt + 0.5 * (alsb[iright] + alsb[ileft]));
            }
            if (slope * (smalla = 0.1 * tla) > tlf) {
                smalla = tlf / slope;
            }
            double aleft = alsb[ileft] + smalla;
            double aright = alsb[iright] - smalla;
            if (aopt < aleft) {
                aopt = aleft;
            }
            if (aopt > aright) {
                aopt = aright;
            }
            if (aleft > aright) {
                aopt = 0.5 * (aleft + aright);
            }
            limset = false;
            if (aopt > aulim) {
                aopt = aulim;
                limset = true;
            }
            for (int i = 0; i < npar; ++i) {
                migrad.setValue(par[i], pmid[i] + aopt * pdir[i]);
            }
            min2 = migrad.minimize(maxcalls, tlr);
            nfcn += min2.nfcn();
            if (min2.hasReachedCallLimit()) {
                return new MnCross(min2.userState(), nfcn, new MnCross.CrossFcnLimit());
            }
            if (!min2.isValid()) {
                return new MnCross(nfcn);
            }
            if (limset && min2.fval() < aim) {
                return new MnCross(min2.userState(), nfcn, new MnCross.CrossParLimit());
            }
            alsb[iout] = aopt;
            flsb[iout] = min2.fval();
            ibest = iout;
        } while (++ipt < maxitr);
        return new MnCross(nfcn);
    }
}

