/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Tool.MathFunc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;

public class EnergyGraphPanel
extends JComponent {
    private int graphYPitch = 300;
    private final int markWidth = 5;
    private final int xPitch = 10;
    private final int xMargine = 80;
    private final int yMargine = 20;
    private final int paneHeight = 230;
    private int widthMode = 0;
    private TrajectoryFile trajectoryFile;
    private int currentStepNo = 0;
    private float widthOpt = 1.0f;
    private int[][] posx;
    private int[][] posy;
    private float[] graphMin;
    private float[] min;
    private float[] max;
    private float[] yPitch;
    private float[] interval;
    private JScrollBar scrollBar;

    public EnergyGraphPanel(TrajectoryFile trajectoryFile) {
        int n;
        this.trajectoryFile = trajectoryFile;
        this.posx = new int[trajectoryFile.stepNum][trajectoryFile.dataNum];
        this.posy = new int[trajectoryFile.stepNum][trajectoryFile.dataNum];
        this.graphMin = new float[trajectoryFile.dataNum];
        this.min = new float[trajectoryFile.dataNum];
        this.max = new float[trajectoryFile.dataNum];
        this.yPitch = new float[trajectoryFile.dataNum];
        this.interval = new float[trajectoryFile.dataNum];
        for (n = 0; n < trajectoryFile.dataNum; ++n) {
            int n2;
            if (trajectoryFile.labelIndex == n) continue;
            float f = trajectoryFile.data[0][n];
            float f2 = trajectoryFile.data[0][n];
            for (int i = 1; i < trajectoryFile.stepNum; ++i) {
                if (f > trajectoryFile.data[i][n]) {
                    f = trajectoryFile.data[i][n];
                }
                if (!(f2 < trajectoryFile.data[i][n])) continue;
                f2 = trajectoryFile.data[i][n];
            }
            this.min[n] = f;
            this.max[n] = f2;
            float f3 = this.max[n] - this.min[n];
            int n3 = (int)MathFunc.log10(f3);
            if (f3 < 1.0f) {
                --n3;
            }
            this.interval[n] = (n2 = (int)(f3 / (float)Math.pow(10.0, n3))) < 3 ? 0.5f * (float)Math.pow(10.0, n3) : (3 <= n2 && n2 < 6 ? 1.0f * (float)Math.pow(10.0, n3) : 2.0f * (float)Math.pow(10.0, n3));
            int n4 = (int)(this.min[n] / this.interval[n]);
            if (this.min[n] < 0.0f) {
                --n4;
            }
            this.graphMin[n] = (float)n4 * this.interval[n];
            this.yPitch[n] = 230.0f / (this.max[n] - this.graphMin[n]);
            for (int i = 0; i < trajectoryFile.stepNum; ++i) {
                this.posx[i][n] = i * 10;
                this.posy[i][n] = 250 - (int)((trajectoryFile.data[i][n] - this.graphMin[n]) * this.yPitch[n]);
            }
        }
        n = 80 + trajectoryFile.stepNum * 10 + 30;
        int n5 = trajectoryFile.labelIndex == -1 ? trajectoryFile.dataNum * this.graphYPitch : (trajectoryFile.dataNum - 1) * this.graphYPitch;
        if (n < 300) {
            n = 300;
        }
        this.setPreferredSize(new Dimension(n, n5));
    }

    public void paint(Graphics graphics) {
        this.drawGraph((Graphics2D)graphics);
    }

    public void setCurrentStep(int n) {
        this.currentStepNo = n;
        this.repaint();
        if (this.widthMode == 0) {
            if (this.trajectoryFile.labelIndex == 0) {
                this.scrollBar.setValue(this.posx[this.currentStepNo][1] - 2 - this.scrollBar.getVisibleAmount() / 2);
            } else {
                this.scrollBar.setValue(this.posx[this.currentStepNo][0] - 2 - this.scrollBar.getVisibleAmount() / 2);
            }
        }
    }

    public BufferedImage createImage() {
        int n = 80 + (int)((float)(this.trajectoryFile.stepNum * 10) * this.widthOpt) + 30;
        BufferedImage bufferedImage = new BufferedImage(n, this.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.drawGraph(graphics2D);
        return bufferedImage;
    }

    public void drawGraph(Graphics2D graphics2D) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.widthOpt = this.widthMode == 1 ? (float)(this.scrollBar.getVisibleAmount() - 80 - 30) / (float)this.trajectoryFile.stepNum / 10.0f : 1.0f;
        int n = -1;
        for (int i = 0; i < this.trajectoryFile.dataNum; ++i) {
            String string;
            int n2;
            int n3;
            int n4;
            if (this.trajectoryFile.labelIndex == i) continue;
            int n5 = this.graphYPitch * ++n;
            for (n4 = 0; n4 < this.trajectoryFile.stepNum; ++n4) {
                graphics2D.setColor(Color.black);
                graphics2D.fillRect((int)((float)this.posx[n4][i] * this.widthOpt) - 2 + 80, this.posy[n4][i] - 2 + n5, 5, 5);
            }
            for (n4 = 0; n4 < this.trajectoryFile.stepNum - 1; ++n4) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine((int)((float)this.posx[n4][i] * this.widthOpt) + 80, this.posy[n4][i] + n5, (int)((float)this.posx[n4 + 1][i] * this.widthOpt) + 80, this.posy[n4 + 1][i] + n5);
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(80, 20 + n5, 80, 250 + n5);
            graphics2D.drawLine(80, 250 + n5, 80 + (int)((float)(this.trajectoryFile.stepNum * 10) * this.widthOpt) + 25, 250 + n5);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            DecimalFormat decimalFormat = MathFunc.log10(this.interval[i]) < 0.0f ? new DecimalFormat("0.0E00") : new DecimalFormat("0.0");
            for (n3 = 0; n3 < (int)((this.max[i] - this.graphMin[i]) / this.interval[i] + 1.0f); ++n3) {
                n2 = 250 - (int)((float)n3 * this.yPitch[i] * this.interval[i]) + n5;
                string = decimalFormat.format(this.graphMin[i] + (float)n3 * this.interval[i]);
                graphics2D.drawString(string, 73 - fontMetrics.stringWidth(string), n2 + 5);
                graphics2D.drawLine(80, n2, 75, n2);
            }
            n3 = (int)(5.0f / this.widthOpt) / 5 * 5;
            if (n3 == 0) {
                n3 = 5;
            }
            for (n2 = n3; n2 < this.trajectoryFile.stepNum + 1; n2 += n3) {
                string = Integer.toString(n2);
                int n6 = (int)((float)(10 * n2) * this.widthOpt) + 80;
                int n7 = 250 + n5;
                graphics2D.drawString(string, n6 - fontMetrics.stringWidth(string) / 2, n7 + 15);
                graphics2D.drawLine(n6, n7, n6, n7 - 5);
            }
            graphics2D.drawString("Step", 130, 280 + n5);
            graphics2D.rotate(-1.5707963267948966, 0.0, 0.0);
            graphics2D.drawString(this.trajectoryFile.dataLabel[i], -(165 + n5), 20);
            graphics2D.rotate(1.5707963267948966, 0.0, 0.0);
            graphics2D.setColor(Color.red);
            graphics2D.fillRect((int)((float)this.posx[this.currentStepNo][i] * this.widthOpt - 2.0f - 1.0f + 80.0f), this.posy[this.currentStepNo][i] - 2 - 1 + n5, 7, 7);
        }
    }

    public void outputPsFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Date date = new Date();
            int n = 80 + (int)((float)(this.trajectoryFile.stepNum * 10) * this.widthOpt) + 30;
            if (n < 300) {
                n = 300;
            }
            int n2 = this.getHeight();
            float f = 1.0f;
            if (n2 > 800) {
                f = 800.0f / (float)n2;
            }
            printStream.print("%!PS-Adobe-2.0 EPSF-2.0\n");
            printStream.print("%%Creator: BioStationViewer Version 5.01\n");
            printStream.print("%%CreationData: " + date.toString() + "\n");
            printStream.print("%%BoundingBox:0 0 " + (int)((float)n * f) + " " + (int)((float)n2 * f) + "\n");
            printStream.print("%%EndComments\n");
            printStream.print("%%BeginProlog\n");
            printStream.print("/s {stroke} def /l {lineto} def /m {moveto} def /t {translate} def\n");
            printStream.print("/sw {stringwidth} def /r {rotate} def /rl {roll}  def /R {repeat} def\n");
            printStream.print("/d {rlineto} def /rm {rmoveto} def /gr {grestore} def /f {eofill} def\n");
            printStream.print("/c {setrgbcolor} def /lw {setlinewidth} def /sd {setdash} def\n");
            printStream.print("/cl {closepath} def /sf {scalefont setfont} def /black {0 setgray} def\n");
            printStream.print("/Helvetica findfont 10 scalefont setfont\n");
            printStream.print("%%EndProlog\n");
            printStream.print("%%Page: number 1\n");
            printStream.print(f + " " + f + " scale\n");
            int n3 = -1;
            for (int i = 0; i < this.trajectoryFile.dataNum; ++i) {
                String string2;
                int n4;
                int n5;
                int n6;
                if (this.trajectoryFile.labelIndex == i) continue;
                int n7 = this.graphYPitch * ++n3;
                for (n6 = 0; n6 < this.trajectoryFile.stepNum; ++n6) {
                    this.psfillRect((int)((float)this.posx[n6][i] * this.widthOpt) - 2 + 80, this.posy[n6][i] - 2 + n7, 5, 5, printStream);
                }
                for (n6 = 0; n6 < this.trajectoryFile.stepNum - 1; ++n6) {
                    this.psdrawLine((int)((float)this.posx[n6][i] * this.widthOpt) + 80, this.posy[n6][i] + n7, (int)((float)this.posx[n6 + 1][i] * this.widthOpt) + 80, this.posy[n6 + 1][i] + n7, printStream);
                }
                this.psdrawLine(80, 20 + n7, 80, 250 + n7, printStream);
                this.psdrawLine(80, 250 + n7, 80 + (int)((float)(this.trajectoryFile.stepNum * 10) * this.widthOpt) + 25, 250 + n7, printStream);
                DecimalFormat decimalFormat = MathFunc.log10(this.interval[i]) < 0.0f ? new DecimalFormat("0.0E00") : new DecimalFormat("0.0");
                for (n5 = 0; n5 < (int)((this.max[i] - this.graphMin[i]) / this.interval[i] + 1.0f); ++n5) {
                    n4 = 250 - (int)((float)n5 * this.yPitch[i] * this.interval[i]) + n7;
                    string2 = decimalFormat.format(this.graphMin[i] + (float)n5 * this.interval[i]);
                    this.psdrawString(string2, 73 - string2.length() * 5, n4 + 5, printStream);
                    this.psdrawLine(80, n4, 75, n4, printStream);
                }
                n5 = (int)(5.0f / this.widthOpt) / 5 * 5;
                if (n5 == 0) {
                    n5 = 5;
                }
                for (n4 = n5; n4 < this.trajectoryFile.stepNum + 1; n4 += n5) {
                    string2 = Integer.toString(n4);
                    int n8 = (int)((float)(10 * n4) * this.widthOpt) + 80;
                    int n9 = 250 + n7;
                    this.psdrawString(string2, n8 - string2.length() * 5 / 2, n9 + 15, printStream);
                    this.psdrawLine(n8, n9, n8, n9 - 5, printStream);
                }
                this.psdrawString("Step", 130, 280 + n7, printStream);
                this.psdrawString90(this.trajectoryFile.dataLabel[i], -(165 + n7), 20, printStream);
            }
            printStream.print("showpage\n");
            printStream.print("%%Trailer\n");
            printStream.print("%%Pages:  1\n");
            printStream.print("%%EOF\n");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "PS File output error.", "Error message", 0);
            return;
        }
    }

    private void psfillRect(int n, int n2, int n3, int n4, PrintStream printStream) {
        printStream.print("gsave\n" + n + " " + (this.getHeight() - n2) + " moveto " + n3 + " 0 d 0 " + -n4 + " d " + -n3 + " 0 d fill stroke cl gr\n");
    }

    private void psdrawString(String string, int n, int n2, PrintStream printStream) {
        printStream.print("gsave\n" + n + " " + (this.getHeight() - n2) + " m (" + string + ") show gr\n");
    }

    private void psdrawString90(String string, int n, int n2, PrintStream printStream) {
        printStream.print("gsave\n" + n2 + " " + (this.getHeight() + n) + " m 90 r (" + string + ") show gr\n");
    }

    private void psdrawLine(int n, int n2, int n3, int n4, PrintStream printStream) {
        printStream.print("gsave\n" + n + " " + (this.getHeight() - n2) + " moveto " + (n3 - n) + " " + (n2 - n4) + " d stroke cl gr\n");
    }

    public void setWidthMode(int n) {
        this.widthMode = n;
        this.repaint();
        int n2 = 80 + (int)((float)(this.trajectoryFile.stepNum * 10) * this.widthOpt) + 30;
        if (n2 < 300) {
            n2 = 300;
        }
        this.setPreferredSize(new Dimension(n2, this.getHeight()));
    }

    public void setScrollBar(JScrollBar jScrollBar) {
        this.scrollBar = jScrollBar;
    }
}

