/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.ssh.hosts.HostSelector;
import jp.advancesoft.chase.ssh.hosts.HostSelectorCombo;
import jp.advancesoft.chase.ssh.remotehostexecuter.BatchFileTransferer;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileHolder;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeManager;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemePanel;
import org.apache.log4j.Logger;

public abstract class FileTransferPanel
extends JPanel
implements ChaseFileHolder {
    private Logger logger = Logger.getLogger(FileTransferPanel.class.getName());
    protected HostSelectorCombo hosts;
    protected String baseDir;
    protected ProjectInfo projectInfo;

    public FileTransferPanel(ProjectInfo projectInfo) {
        this.baseDir = projectInfo.getProjectDirectory() + System.getProperty("file.separator");
        this.projectInfo = projectInfo;
        this.setBorder(new TitledBorder("file transfer"));
        this.add(this.createTransferPanel());
    }

    private JPanel createTransferPanel() {
        JPanel ptransfer = new JPanel();
        this.hosts = new HostSelectorCombo();
        JButton editftscheme = new JButton("edit file transfer scheme");
        editftscheme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTransferPanel.this.bootFileTransferEditPanel();
            }
        });
        JButton btnupload = new JButton("batch upload");
        btnupload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTransferPanel.this.bootBatchFileUpload();
            }
        });
        JButton btndownload = new JButton("batch download");
        btndownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTransferPanel.this.bootBatchFileDownload();
            }
        });
        ptransfer.add(this.hosts);
        ptransfer.add(editftscheme);
        ptransfer.add(btnupload);
        ptransfer.add(btndownload);
        return ptransfer;
    }

    private void bootFileTransferEditPanel() {
        if (this.hosts.getSelectedHost().getName().equals("localhost")) {
            this.logger.info("no need to edit file transfer scheme for host 'localhost'.");
            return;
        }
        FileTransferSchemePanel editor = new FileTransferSchemePanel(new FileTransferSchemeManager(this.hosts.getSelectedHost(), this));
    }

    private void bootBatchFileUpload() {
        if (this.hosts.getSelectedHost().getName().equals("localhost")) {
            this.logger.info("no need to transfer file for host 'localhost'.");
            return;
        }
        BatchFileTransferer bft = new BatchFileTransferer(this.baseDir, this.hosts.getSelectedHost(), this);
        bft.upload();
    }

    private void bootBatchFileDownload() {
        if (this.hosts.getSelectedHost().getName().equals("localhost")) {
            this.logger.info("no need to transfer file for host 'localhost'.");
            return;
        }
        BatchFileTransferer bft = new BatchFileTransferer(this.baseDir, this.hosts.getSelectedHost(), this);
        bft.download();
    }

    public HostSelector getHosts() {
        return this.hosts;
    }
}

