/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectdirbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.advancesoft.chase.projectbrowser.ProjectBrowser;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserObject;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ProjectDirBrowserNode
extends DefaultMutableTreeNode {
    private static Logger logger = Logger.getLogger(ProjectDirBrowserNode.class.getName());
    private ProjectInfo info;
    private Vector listeners = new Vector();
    private Element proj;
    private ProjectDirBrowser parent;
    private ProjectBrowser panel;
    private boolean bselected = false;
    private boolean bexpanded = false;

    public ProjectDirBrowserNode(Element proj, ProjectDirBrowser parent) {
        this.proj = proj;
        this.parent = parent;
        String hasSub = proj.getAttributeValue("hassub");
        boolean bhasSub = false;
        if (hasSub != null) {
            bhasSub = new Boolean(hasSub);
        }
        this.info = new ProjectInfo(proj);
        ProjectDirBrowserObject o2 = new ProjectDirBrowserObject(this.info);
        super.setUserObject(o2);
        String isExpanded = proj.getAttributeValue("shouldbevisible");
        this.bexpanded = false;
        if (isExpanded != null) {
            this.bexpanded = new Boolean(isExpanded);
        }
        String isSelected = proj.getAttributeValue("selected");
        this.bselected = false;
        if (isSelected != null) {
            this.bselected = new Boolean(isSelected);
        }
    }

    public boolean isSelected() {
        return this.bselected;
    }

    public boolean isExpanded() {
        return this.bexpanded;
    }

    public ProjectInfo getProjectInfo() {
        return this.info;
    }

    public Element getProjectElement() {
        return this.proj;
    }

    public void addProjectDirBrowserNodeChangeListener(ProjectDirBrowserNodeChangeListener listener) {
        this.listeners.addElement(listener);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            logger.debug("button 1 pressed.");
            logger.debug(this.info);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener)this.listeners.elementAt(i);
                listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
            }
        } else if (e.getButton() == 2) {
            logger.debug("button 2 pressed.");
            logger.debug(this.info);
        } else if (e.getButton() == 3) {
            this.showMenu(e);
        }
    }

    public void selectMe() {
        this.bselected = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener)this.listeners.elementAt(i);
            listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
        }
        try {
            this.panel.setSelected(true);
        }
        catch (PropertyVetoException pve) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem[] items = this.getItems();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                popup.add(items[i]);
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JMenuItem[] getItems() {
        JMenuItem create;
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        if (this.info.getProjectType().equals("root")) {
            create = new JMenuItem("create project");
            items.addElement(create);
            create.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserNode.this.parent.bootProjectCreator();
                }
            });
        } else if (this.info.getInfoType() == 1 && !this.info.getProjectType().equals("root")) {
            create = new JMenuItem("create project");
            items.addElement(create);
            JMenuItem sub = new JMenuItem("create sub project");
            items.addElement(sub);
            JMenuItem remove = new JMenuItem("remove project");
            items.addElement(remove);
            create.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserNode.this.parent.bootProjectCreator();
                }
            });
            sub.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserNode.this.parent.bootSubProjectCreator();
                }
            });
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserNode.this.parent.bootProjectRemover();
                }
            });
        } else if (this.info.getInfoType() == 2) {
            JMenuItem remove = new JMenuItem("remove sub project");
            items.addElement(remove);
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDirBrowserNode.this.parent.bootSubProjectRemover();
                }
            });
        }
        if (items.size() != 0) {
            JMenuItem[] jitems = new JMenuItem[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                jitems[i] = (JMenuItem)items.elementAt(i);
            }
            return jitems;
        }
        return null;
    }

    public ProjectBrowser getProjectBrowser() {
        return this.panel;
    }

    public void setProjectBrowser(ProjectBrowser panel) {
        this.panel = panel;
    }
}

