/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements.bond;

import com.sun.j3d.utils.geometry.Cylinder;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class CylinderCreatorTG
extends TransformGroup {
    private static Logger logger = Logger.getLogger(CylinderCreatorTG.class.getName());
    private int edges;
    private double height;
    private double radius;
    private Appearance cylApp;
    private Point3d b;
    private Point3d a;

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Appearance cylApp) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = 7;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Appearance cylApp, int edges) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = edges;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        this.create();
    }

    public void setResolution(int e) {
        this.edges = e;
    }

    private void create() {
        this.b = this.b;
        this.a = this.a;
        this.radius = this.radius;
        this.cylApp = this.cylApp;
        this.setTransform(this.getTransMatrix());
        Cylinder cyl = new Cylinder((float)this.radius, (float)this.height, 1, this.edges, 1, this.cylApp);
        this.addChild((Node)cyl);
    }

    public void recreate(Point3d b, Point3d a, double radius, Appearance cylApp) {
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        this.setTransform(this.getTransMatrix());
    }

    public void recreate(Point3d b, Point3d a) {
        if (this.b.epsilonEquals((Tuple3d)b, 5.0E-5) && this.a.epsilonEquals((Tuple3d)a, 5.0E-5)) {
            logger.debug("no need to update this bond.");
            return;
        }
        this.b = b;
        this.a = a;
        this.setTransform(this.getTransMatrix());
    }

    private Transform3D getTransMatrix() {
        Vector3d center = new Vector3d();
        center.x = (this.a.x - this.b.x) / 2.0 + this.b.x;
        center.y = (this.a.y - this.b.y) / 2.0 + this.b.y;
        center.z = (this.a.z - this.b.z) / 2.0 + this.b.z;
        Vector3d unit = new Vector3d();
        unit.sub((Tuple3d)this.a, (Tuple3d)this.b);
        this.height = unit.length();
        unit.normalize();
        Vector3d uX = new Vector3d();
        Vector3d uY = new Vector3d();
        Vector3d uZ = new Vector3d();
        Transform3D rotateFix = new Transform3D();
        uY = new Vector3d(unit);
        uX.cross(unit, new Vector3d(0.0, 0.0, 1.0));
        double magX = uX.length();
        if (magX != 0.0) {
            uX.z /= magX;
            uX.x /= magX;
            uX.y /= magX;
            uZ.cross(uX, uY);
        } else {
            uX = new Vector3d(unit);
            uZ.cross(unit, new Vector3d(0.0, 1.0, 0.0));
            double magZ = uZ.length();
            uZ.x /= magZ;
            uZ.y /= magZ;
            uZ.z /= magZ;
            uY.cross(uZ, uX);
            rotateFix.rotZ(1.5707963267948966);
        }
        Transform3D transMatrix = new Transform3D();
        Transform3D rotateMatrix = new Transform3D(new Matrix4d(uX.x, uX.y, uX.z, 0.0, uY.x, uY.y, uY.z, 0.0, uZ.x, uZ.y, uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
        rotateMatrix.invert();
        transMatrix.mul(rotateMatrix);
        transMatrix.mul(rotateFix);
        transMatrix.setTranslation(center);
        return transMatrix;
    }

    public String toString() {
        return "edge coordinates: " + this.b.toString() + ", " + this.a.toString() + " radius: " + this.radius;
    }
}

