/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class JMFUtil {
    private static Locale locale;
    private static ListResourceBundle res;
    private static ListResourceBundle beanInfoRes;
    private static String lang;
    private static String ctry;

    public static String getString(String key) {
        if (res == null) {
            JMFUtil.setResourceBundle(null);
        }
        return res.getString(key);
    }

    public static String getLang() {
        return lang;
    }

    public static void setResourceBundle(Locale l) {
        locale = Locale.getDefault();
        try {
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", locale);
        }
        catch (MissingResourceException m) {
            locale = new Locale("en", "US");
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = locale.getLanguage();
        ctry = locale.getCountry();
    }

    public static String getBIString(String key) {
        if (beanInfoRes == null) {
            JMFUtil.setBIResourceBundle(null);
        }
        return beanInfoRes.getString(key);
    }

    public static void setBIResourceBundle(Locale l) {
        locale = Locale.getDefault();
        try {
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", locale);
        }
        catch (MissingResourceException m) {
            locale = new Locale("en", "US");
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = locale.getLanguage();
        ctry = locale.getCountry();
    }

    public static Locale getLocale(String l) {
        if (l == null) {
            return Locale.getDefault();
        }
        String local = l.trim().toUpperCase();
        if (local.compareTo("FRANCE") == 0) {
            return Locale.FRANCE;
        }
        if (local.compareTo("GERMANY") == 0) {
            return Locale.GERMANY;
        }
        if (local.compareTo("ITALY") == 0) {
            return Locale.ITALY;
        }
        if (local.compareTo("JAPAN") == 0) {
            return Locale.JAPAN;
        }
        if (local.compareTo("KOREA") == 0) {
            return Locale.KOREA;
        }
        if (local.compareTo("CHINA") == 0) {
            return Locale.CHINA;
        }
        if (local.compareTo("PRC") == 0) {
            return Locale.PRC;
        }
        if (local.compareTo("TAIWAN") == 0) {
            return Locale.TAIWAN;
        }
        if (local.compareTo("UK") == 0) {
            return Locale.UK;
        }
        if (local.compareTo("US") == 0) {
            return Locale.US;
        }
        if (local.compareTo("CANADA") == 0) {
            return Locale.CANADA;
        }
        if (local.compareTo("CANADA_FRENCH") == 0) {
            return Locale.CANADA_FRENCH;
        }
        return null;
    }

    public static Panel doGridbagLayout2(Component[] comp, int column, int stretch) {
        Panel pan = new Panel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pan.setLayout(gb);
        pan.setBackground(Color.lightGray);
        pan.setForeground(Color.black);
        c.insets = new Insets(1, 0, 0, 1);
        c.anchor = 17;
        int i = 0;
        while (i < comp.length) {
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.fill = 0;
            if (i % column - column + 1 == 0) {
                c.gridwidth = 0;
            }
            if (i % column - stretch + 1 == 0) {
                c.fill = 2;
                c.weighty = 1.0;
                c.weightx = 1.0;
            }
            gb.setConstraints(comp[i], c);
            pan.add(comp[i], c);
            ++i;
        }
        return pan;
    }

    public static void centerComponent(Panel pan, Component comp) {
        JMFUtil.doDebug("centerComponent");
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pan.setLayout(gb);
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 0;
        gb.setConstraints(comp, c);
        pan.add(comp, c);
    }

    public static float aspectRatio(float width, float height, int controllerHeight) {
        return width / (height - (float)controllerHeight);
    }

    public static void center(Panel parent, Component comp, boolean fit, int dheight) {
        int pwidth = parent.getSize().width;
        int pheight = parent.getSize().height;
        comp.setBounds(parent.getInsets().left, parent.getInsets().top, pwidth - parent.getInsets().left - parent.getInsets().right, pheight - parent.getInsets().top - parent.getInsets().bottom);
    }

    public static void setCenterLocation(Frame self, Frame parent, int width, int height) {
        Rectangle rect;
        JMFUtil.doDebug("setCenterLocation");
        if (parent != null) {
            rect = parent.getBounds();
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            rect = new Rectangle(new Point(0, 0), d);
        }
        ((Component)self).setSize(width, height);
        ((Component)self).setLocation(rect.x + (rect.width - width) / 2, rect.y + (rect.height - height) / 2);
    }

    public static void copyStringArray(String[] oldArray, String[] newArray) {
        if (oldArray == null | newArray == null) {
            return;
        }
        int i = 0;
        while (i < oldArray.length) {
            newArray[i] = oldArray[i];
            ++i;
        }
    }

    public static void copyShortenStringArray(String[] oldArray, String[] newArray, int index, int size) {
        if (oldArray == null | newArray == null) {
            return;
        }
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = i >= index ? oldArray[i + size] : oldArray[i];
            ++i;
        }
    }

    public static String parseArrayIntoString(String[] value) {
        StringBuffer property = new StringBuffer("");
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                property.append(value[i]);
                if (i != value.length - 1) {
                    property.append(",");
                }
                JMFUtil.doDebug(property.toString());
                ++i;
            }
        }
        return property.toString();
    }

    public static String[] parseStringIntoArray(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        String temp = value;
        String sub = "";
        String[] tempArray = null;
        int length = 0;
        Vector<String> strings = new Vector<String>();
        int index = -1;
        JMFUtil.doDebug("Value = " + value);
        index = temp.indexOf(",");
        length = temp.length();
        while (index != -1) {
            sub = temp.substring(0, index);
            strings.addElement(sub);
            if (index + 1 < length) {
                temp = temp.substring(index + 1, length);
            } else if (index + 1 == length) {
                temp = "";
                strings.addElement("");
            }
            index = temp.indexOf(",");
            length = temp.length();
        }
        if (temp != null & length != 0) {
            strings.addElement(temp.substring(0, length));
        }
        tempArray = new String[strings.size()];
        int i = 0;
        while (i < strings.size()) {
            tempArray[i] = (String)strings.elementAt(i);
            ++i;
        }
        return tempArray;
    }

    public static String convertString(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return s;
        }
        boolean count = false;
        int index = -1;
        StringBuffer newString = new StringBuffer(s);
        int i = 0;
        while (i < newString.length()) {
            if (newString.charAt(i) == '\\' || newString.charAt(i) == '\"') {
                newString.insert(i, "\\");
                ++i;
            }
            ++i;
        }
        return newString.toString();
    }

    public static boolean msVersion() {
        boolean msVersion;
        try {
            Class<?> sysVerMgr = Class.forName("com.ms.util.SystemVersionManager");
            msVersion = true;
        }
        catch (Throwable e) {
            msVersion = false;
        }
        return msVersion;
    }

    private static void doDebug(String s) {
    }

    static {
        lang = null;
        ctry = null;
    }
}

