/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.ref.plotter.AbstractStyleParameter;

public class DoubleStyleParameter
extends AbstractStyleParameter {
    private boolean hasLimits = false;
    private double min;
    private double max;

    DoubleStyleParameter(String name, double defaultValue) {
        super(name, String.valueOf(defaultValue));
    }

    DoubleStyleParameter(String name, double defaultValue, double min, double max) {
        super(name, String.valueOf(defaultValue));
        if (min >= max) {
            throw new IllegalArgumentException("Min value: " + min + " cannot be greater or equal to Max value: " + max);
        }
        this.hasLimits = true;
        this.min = min;
        this.max = max;
    }

    public boolean hasLimits() {
        return this.hasLimits;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double value() {
        try {
            return Double.parseDouble(this.parameterValue());
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public boolean setValue(double value) {
        return this.setParameter(String.valueOf(value));
    }

    protected boolean setParameter(String parValue) {
        boolean result = super.setParameter(parValue);
        try {
            double d = Double.parseDouble(parValue);
            if (!result || !this.hasLimits()) {
                return result;
            }
            return d < this.max && d > this.min;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public Class type() {
        return Double.TYPE;
    }
}

