/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.imp;

public class PrecompiledImporter
extends PyObject {
    public PyObject find_module(String name) {
        return this.find_module(name, Py.None);
    }

    public PyObject find_module(String name, PyObject path) {
        if (Py.frozenModules != null) {
            Class c = null;
            if (Py.frozenModules.get(name + ".__init__") != null) {
                Py.writeDebug("import", "trying " + name + " as precompiled package");
                c = this.findPyClass(name + ".__init__");
                if (c == null) {
                    return Py.None;
                }
                return new PrecompiledLoader(c, true);
            }
            if (Py.frozenModules.get(name) != null) {
                Py.writeDebug("import", "trying " + name + " as precompiled module");
                c = this.findPyClass(name);
                if (c == null) {
                    return Py.None;
                }
                return new PrecompiledLoader(c, false);
            }
        }
        return Py.None;
    }

    public String toString() {
        return this.getType().toString();
    }

    private Class findPyClass(String name) {
        if (Py.frozenPackage != null) {
            name = Py.frozenPackage + "." + name;
        }
        return Py.findClassEx(name + "$_PyInner", "precompiled");
    }

    public class PrecompiledLoader
    extends PyObject {
        private Class _class;
        private boolean _package;

        public PrecompiledLoader(Class class_, boolean package_) {
            this._class = class_;
            this._package = package_;
        }

        public PyObject load_module(String name) {
            if (this._package) {
                PyModule m = imp.addModule(name);
                m.__dict__.__setitem__("__path__", (PyObject)new PyList());
                m.__dict__.__setitem__("__loader__", (PyObject)this);
            }
            Py.writeComment("import", "'" + name + "' as precompiled " + (this._package ? "package" : "module"));
            return imp.createFromClass(name, this._class);
        }

        public String toString() {
            return this.getType().toString();
        }
    }
}

