/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class RecentFileList
implements ActionListener {
    private Vector files;
    private String type;
    private int size;
    private int used;
    private EventListenerList listenerList = new EventListenerList();

    public RecentFileList() {
        this(null);
    }

    public RecentFileList(int size) {
        this(null, size);
    }

    public RecentFileList(String type) {
        this(type, 4);
    }

    public RecentFileList(String type, int size) {
        this.files = new Vector(size);
        this.size = size;
        this.type = type;
        this.used = 0;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? RecentFileList.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireActionPerformed(e);
    }

    public void save(Properties props) {
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        for (int i = 0; i < this.used; ++i) {
            props.put(key + i, this.files.elementAt(i).toString());
        }
        props.put(key + "Used", String.valueOf(this.used));
    }

    public void load(Properties props) {
        String value;
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        this.files.removeAllElements();
        this.used = Integer.parseInt(props.getProperty(key + "Used", "0"));
        for (int i = 0; i < this.used && (value = props.getProperty(key + i)) != null; ++i) {
            this.files.addElement(value);
        }
    }

    public void add(File f) {
        try {
            this.add(f.getCanonicalPath());
        }
        catch (IOException x) {
            this.add(f.getAbsolutePath());
        }
    }

    public void remove(File f) {
        this.remove(f.getName());
    }

    public void add(String name) {
        int pos = this.files.indexOf(name);
        if (pos > 0) {
            this.files.removeElementAt(pos);
            this.files.insertElementAt(name, 0);
        } else if (pos != 0) {
            if (this.used == this.size) {
                this.files.removeElementAt(this.size - 1);
            } else {
                ++this.used;
            }
            this.files.insertElementAt(name, 0);
        }
    }

    public void remove(String name) {
        if (this.files.removeElement(name)) {
            --this.used;
        }
    }

    public void buildMenu(JMenu menu) {
        if (this.used > 0) {
            menu.addSeparator();
            for (int i = 0; i < this.used; ++i) {
                JMenuItem item = new JMenuItem(String.valueOf(i + 1) + " " + this.files.elementAt(i));
                item.setActionCommand(this.files.elementAt(i).toString());
                if (this.size < 9) {
                    item.setMnemonic(Character.forDigit(i + 1, 10));
                }
                item.addActionListener(this);
                menu.add(item);
            }
        }
    }
}

