/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.ColorData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.DisplayPreference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;

public class FilePreferenceWindow
extends BaseWindow {
    private MyButton[] buttons;
    private Vector modifyButtons = new Vector();
    private ColorData[] colorData;
    private AbinitMpViewer viewer;
    private int size;

    public FilePreferenceWindow(AbinitMpViewer abinitMpViewer, int n) {
        super(MyResourceBundle.getResourceString("FilePreferenceWindow.Title"));
        Serializable serializable;
        Object object;
        this.viewer = abinitMpViewer;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        if (n == 0) {
            this.setTitle(MyResourceBundle.getResourceString("FilePreferenceWindow.Title"));
            this.colorData = DisplayPreference.fileColor;
        } else if (n == 1) {
            this.setTitle(MyResourceBundle.getResourceString("ChainPreferenceWindow.Title"));
            this.colorData = DisplayPreference.chainColor;
        } else if (n == 5) {
            this.setTitle(MyResourceBundle.getResourceString("DNAPreferenceWindow.Title"));
            this.colorData = new ColorData[Constants.DNA_NAME.length];
            for (int i = 0; i < Constants.DNA_NAME.length; ++i) {
                this.colorData[i] = (ColorData)ResidueInfoTable.get(Constants.DNA_NAME[i]);
            }
        } else {
            this.setTitle(MyResourceBundle.getResourceString("FragmentPreferenceWindow.Title"));
            this.colorData = DisplayPreference.fragmentColor;
        }
        this.size = this.colorData.length;
        this.buttons = new MyButton[this.size];
        this.getJMenuBar().add(this.addMenuItem("FilePreferenceWindow.fileMenuTitle", "FilePreferenceWindow.fileMenu", (Action)new fileListener()));
        MyPanel myPanel = new MyPanel(new GridLayout(0, 1));
        buttonListener buttonListener2 = new buttonListener();
        for (int i = 0; i < this.size; ++i) {
            object = n == 5 ? Constants.DNA_NAME[i] : Integer.toString(i + 1);
            this.buttons[i] = serializable = new MyButton((String)object);
            serializable.addActionListener(buttonListener2);
            serializable.setBackground(this.colorData[i].color.get());
            serializable.setForeground(this.getLabelColor(this.colorData[i].color.get()));
            myPanel.add((Component)serializable);
        }
        MyPanel myPanel2 = new MyPanel(new FlowLayout(1));
        object = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel2.add((Component)object);
        ((AbstractButton)object).addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)myPanel, "Center");
        this.mainPanel.add((Component)myPanel2, "South");
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        if (((Dimension)serializable).width > 2000) {
            ((Dimension)serializable).width /= 2;
        }
        if (n == 5) {
            this.setBounds(((Dimension)serializable).width - 240, 350, 210, 205);
        } else {
            this.setBounds(((Dimension)serializable).width - 240, 350, 210, 320);
        }
    }

    public void closeProcess() {
        for (int i = 0; i < this.modifyButtons.size(); ++i) {
            MyButton myButton = (MyButton)this.modifyButtons.get(i);
            String string = myButton.getText();
            int n = Integer.parseInt(string) - 1;
            myButton.setBackground(this.colorData[n].color.get());
            myButton.setForeground(this.getLabelColor(this.colorData[i].color.get()));
        }
        this.modifyButtons.removeAllElements();
    }

    public void setPreference(ColorData[] colorDataArray) {
        this.colorData = colorDataArray;
        for (int i = 0; i < this.size; ++i) {
            this.buttons[i].setBackground(colorDataArray[i].color.get());
            this.buttons[i].setForeground(this.getLabelColor(colorDataArray[i].color.get()));
        }
    }

    public void setPreferenceDNA() {
        for (int i = 0; i < Constants.DNA_NAME.length; ++i) {
            this.colorData[i] = (ColorData)ResidueInfoTable.get(Constants.DNA_NAME[i]);
            this.buttons[i].setBackground(this.colorData[i].color.get());
            this.buttons[i].setForeground(this.getLabelColor(this.colorData[i].color.get()));
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < FilePreferenceWindow.this.modifyButtons.size(); ++i) {
                MyButton myButton = (MyButton)FilePreferenceWindow.this.modifyButtons.get(i);
                String string = myButton.getText();
                Color color = myButton.getBackground();
                if (string.equals("A")) {
                    FilePreferenceWindow.this.colorData[0].setColor(color);
                    continue;
                }
                if (string.equals("G")) {
                    FilePreferenceWindow.this.colorData[1].setColor(color);
                    continue;
                }
                if (string.equals("C")) {
                    FilePreferenceWindow.this.colorData[2].setColor(color);
                    continue;
                }
                if (string.equals("T")) {
                    FilePreferenceWindow.this.colorData[3].setColor(color);
                    continue;
                }
                FilePreferenceWindow.this.colorData[Integer.parseInt(string) - 1].setColor(color);
            }
            FilePreferenceWindow.this.setWaitCursor();
            FilePreferenceWindow.this.viewer.displayMoNode();
            FilePreferenceWindow.this.setDefaultCursor();
            FilePreferenceWindow.this.modifyButtons.removeAllElements();
        }
    }

    class buttonListener
    extends AbstractAction {
        buttonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            String string = myButton.getText();
            Color color = myButton.getBackground();
            if ((color = JColorChooser.showDialog(myButton, "Color", color)) != null) {
                myButton.setBackground(color);
                myButton.setForeground(FilePreferenceWindow.this.getLabelColor(color));
                FilePreferenceWindow.this.modifyButtons.add(myButton);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("FilePreferenceWindow.fileMenu");
            char c = string.charAt(0);
            if (FilePreferenceWindow.this.getNemonic(stringArray[0]) == c) {
                FilePreferenceWindow.this.closeProcess();
                FilePreferenceWindow.this.setVisible(false);
            }
        }
    }
}

