/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.ColorData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class DisplayResiduePanel
extends GridBagLayoutPanel {
    public boolean[] value;
    private MyCheckBox[] checkBox = new MyCheckBox[Constants.RESIDUE_FULL_NAME.length];

    public DisplayResiduePanel(boolean[] blArray) {
        Object object;
        this.setBorder(new TitledBorder(""));
        this.value = new boolean[blArray.length];
        this.setLayout(new GridLayout(0, 2));
        for (int i = 0; i < blArray.length; ++i) {
            this.value[i] = blArray[i];
            this.checkBox[i] = new MyCheckBox(Constants.RESIDUE_FULL_NAME[i], blArray[i]);
            object = (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[i]);
            if (object == null) {
                object = (ColorData)ResidueInfoTable.get("OTHER");
            }
            this.checkBox[i].setBackground(((ColorData)object).color.get());
            this.checkBox[i].setForeground(this.getLabelColor(((ColorData)object).color.get()));
            this.add(this.checkBox[i]);
        }
        this.add(new JLabel(" "));
        MyButton myButton = new MyButton("Select All");
        this.add(myButton);
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DisplayResiduePanel.this.checkBox.length; ++i) {
                    DisplayResiduePanel.this.checkBox[i].setSelected(true);
                }
            }
        });
        object = new MyButton("Unselect All");
        this.add((Component)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DisplayResiduePanel.this.checkBox.length; ++i) {
                    DisplayResiduePanel.this.checkBox[i].setSelected(false);
                }
            }
        });
    }

    public boolean[] getValue() {
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = this.checkBox[i].isSelected();
        }
        return this.value;
    }

    public void setValue(boolean[] blArray) {
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = blArray[i];
            this.checkBox[i].setSelected(blArray[i]);
        }
    }

    protected Color getLabelColor(Color color) {
        int n = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        if (n < 128) {
            return Color.white;
        }
        return Color.black;
    }
}

