/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.AtomTableElement;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.Constants;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;

public class AtomPreferenceWindow
extends BaseWindow {
    private MyButton[] buttons = new MyButton[Constants.ATOM_NAME.length];
    private Vector modifyButtons = new Vector();
    private AbinitMpViewer viewer;
    private int atomNo;
    private Font font = new Font("Monospaced", 0, 14);
    private Insets insets = new Insets(1, 3, 1, 3);
    private buttonListener bl = new buttonListener();

    public AtomPreferenceWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("AtomPreferenceWindow.Title"));
        int n;
        this.viewer = abinitMpViewer;
        this.atomNo = 1;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("AtomPreferenceWindow.fileMenuTitle", "AtomPreferenceWindow.fileMenu", (Action)new fileListener()));
        MyPanel myPanel = new MyPanel(new GridLayout(0, 18));
        myPanel.add(this.makeButton());
        for (n = 0; n < 16; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        myPanel.add(this.makeButton());
        myPanel.add(this.makeButton());
        myPanel.add(this.makeButton());
        for (n = 0; n < 10; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        for (n = 0; n < 6; ++n) {
            myPanel.add(this.makeButton());
        }
        myPanel.add(this.makeButton());
        myPanel.add(this.makeButton());
        for (n = 0; n < 10; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        for (n = 0; n < 6; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 18; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 18; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 18; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 3; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 15; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        for (n = 0; n < 4; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        for (n = 0; n < 14; ++n) {
            myPanel.add(this.makeButton());
        }
        for (n = 0; n < 4; ++n) {
            myPanel.add(new MyLabel(" "));
        }
        for (n = 0; n < 14; ++n) {
            myPanel.add(this.makeButton());
        }
        MyPanel myPanel2 = new MyPanel(new FlowLayout(1));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel2.add(myButton);
        myButton.addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)myPanel, "Center");
        this.mainPanel.add((Component)myPanel2, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        this.setBounds(dimension.width - 530, 350, 490, 340);
    }

    private MyButton makeButton() {
        String string = Constants.ATOM_NAME[this.atomNo];
        Color color = AtomInfoTable.getInfo((String)string).color.get();
        MyButton myButton = new MyButton(string);
        myButton.setFont(this.font);
        myButton.setMargin(this.insets);
        myButton.setBackground(color);
        myButton.setForeground(this.getLabelColor(color));
        myButton.addActionListener(this.bl);
        this.buttons[this.atomNo] = myButton;
        ++this.atomNo;
        return myButton;
    }

    public void closeProcess() {
        for (int i = 0; i < this.modifyButtons.size(); ++i) {
            MyButton myButton = (MyButton)this.modifyButtons.get(i);
            String string = myButton.getText();
            Color color = AtomInfoTable.getInfo((String)string).color.get();
            myButton.setBackground(color);
            myButton.setForeground(this.getLabelColor(color));
        }
        this.modifyButtons.removeAllElements();
    }

    public void setPreference() {
        for (int i = 1; i < Constants.ATOM_NAME.length; ++i) {
            Color color = AtomInfoTable.getInfo((String)Constants.ATOM_NAME[i]).color.get();
            this.buttons[i].setBackground(color);
            this.buttons[i].setForeground(this.getLabelColor(color));
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < AtomPreferenceWindow.this.modifyButtons.size(); ++i) {
                MyButton myButton = (MyButton)AtomPreferenceWindow.this.modifyButtons.get(i);
                String string = myButton.getText();
                Color color = myButton.getBackground();
                AtomTableElement atomTableElement = AtomInfoTable.getInfo(string);
                atomTableElement.setColor(color);
                AtomPreferenceWindow.this.setWaitCursor();
                AtomPreferenceWindow.this.viewer.displayMoNode();
                AtomPreferenceWindow.this.setDefaultCursor();
            }
            AtomPreferenceWindow.this.modifyButtons.removeAllElements();
        }
    }

    class buttonListener
    extends AbstractAction {
        buttonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            String string = myButton.getText();
            Color color = myButton.getBackground();
            if ((color = JColorChooser.showDialog(myButton, "Color", color)) != null) {
                myButton.setBackground(color);
                myButton.setForeground(AtomPreferenceWindow.this.getLabelColor(color));
                AtomPreferenceWindow.this.modifyButtons.add(myButton);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AtomPreferenceWindow.fileMenu");
            char c = string.charAt(0);
            if (AtomPreferenceWindow.this.getNemonic(stringArray[0]) == c) {
                AtomPreferenceWindow.this.closeProcess();
                AtomPreferenceWindow.this.setVisible(false);
            }
        }
    }
}

