/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Display;

import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Display.CrossPoint;
import AbinitMp.Display.CrossPointLinear;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class MarchingCube {
    public static final int LOG = 0;
    public static final int LINEAR = 1;
    private static final byte[][] PLYEDGES1 = new byte[][]{{1, 3, 6}};
    private static final byte[][] PLYEDGES2 = new byte[][]{{1, 2, 6}, {2, 6, 7}};
    private static final byte[][] PLYEDGES3 = new byte[][]{{1, 3, 6}, {0, 2, 5}};
    private static final byte[][] PLYEDGES4 = new byte[][]{{1, 3, 6}, {5, 8, 10}};
    private static final byte[][] PLYEDGES5 = new byte[][]{{2, 6, 9}, {2, 3, 6}, {2, 9, 10}};
    private static final byte[][] PLYEDGES6 = new byte[][]{{5, 8, 10}, {1, 2, 6}, {2, 6, 7}};
    private static final byte[][] PLYEDGES7 = new byte[][]{{0, 1, 4}, {5, 8, 10}, {2, 3, 7}};
    private static final byte[][] PLYEDGES8 = new byte[][]{{1, 9, 10}, {1, 2, 10}};
    private static final byte[][] PLYEDGES9 = new byte[][]{{1, 4, 8}, {1, 3, 8}, {3, 8, 10}, {3, 7, 10}};
    private static final byte[][] PLYEDGES10 = new byte[][]{{0, 4, 6}, {0, 3, 6}, {5, 8, 11}, {5, 7, 11}};
    private static final byte[][] PLYEDGES11 = new byte[][]{{1, 3, 9}, {5, 8, 9}, {3, 5, 9}, {3, 5, 7}};
    private static final byte[][] PLYEDGES12 = new byte[][]{{0, 1, 4}, {2, 6, 9}, {2, 9, 10}, {2, 3, 6}};
    private static final byte[][] PLYEDGES13 = new byte[][]{{4, 8, 9}, {1, 3, 6}, {0, 2, 5}, {7, 10, 11}};
    private static final byte[][] PLYEDGES14 = new byte[][]{{3, 4, 6}, {3, 4, 10}, {4, 8, 10}, {2, 3, 10}};
    private static final int PATNO = 256;
    private static final int PlyNo1 = PLYEDGES1.length;
    private static final int PlyNo2 = PLYEDGES2.length;
    private static final int PlyNo3 = PLYEDGES3.length;
    private static final int PlyNo4 = PLYEDGES4.length;
    private static final int PlyNo5 = PLYEDGES5.length;
    private static final int PlyNo6 = PLYEDGES6.length;
    private static final int PlyNo7 = PLYEDGES7.length;
    private static final int PlyNo8 = PLYEDGES8.length;
    private static final int PlyNo9 = PLYEDGES9.length;
    private static final int PlyNo10 = PLYEDGES10.length;
    private static final int PlyNo11 = PLYEDGES11.length;
    private static final int PlyNo12 = PLYEDGES12.length;
    private static final int PlyNo13 = PLYEDGES13.length;
    private static final int PlyNo14 = PLYEDGES14.length;
    private static final int[] CROSSEDGE = new int[]{0, 74, 198, 111, 1386, 1612, 1510, 1471, 1542, 1434, 2553, 938, 1631, 4095, 1372};
    private static final int[][] EDGETABLE = new int[][]{{-1, 0, 1, -1, 4, -1, -1, -1}, {0, -1, -1, 2, -1, 5, -1, -1}, {1, -1, -1, 3, -1, -1, 6, -1}, {-1, 2, 3, -1, -1, -1, -1, 7}, {4, -1, -1, -1, -1, 8, 9, -1}, {-1, 5, -1, -1, 8, -1, -1, 10}, {-1, -1, 6, -1, 9, -1, -1, 11}, {-1, -1, -1, 7, -1, 10, 11, -1}};
    private static final int[][] UEDGETABLE = new int[][]{{0, 1}, {0, 2}, {1, 3}, {2, 3}, {0, 4}, {1, 5}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};
    private static int[][] PAT0 = new int[][]{{0, 16434824}};
    private static int[][] PAT1 = new int[][]{{4, 33212040}, {1, 30659609}, {2, 32451168}, {8, 29254338}, {16, 22671629}, {32, 23400308}, {128, 21765605}, {64, 24958340}};
    private static int[][] PAT2 = new int[][]{{12, 49989256}, {68, 41735556}, {192, 38542821}, {136, 46796521}, {5, 47436825}, {10, 46031554}, {160, 43527115}, {80, 49650960}, {3, 40624684}, {34, 49228384}, {48, 35760958}, {17, 39448845}};
    private static int[][] PAT3 = new int[][]{{6, 66766472}, {9, 64214041}, {40, 63573737}, {130, 54740605}, {65, 58512772}, {20, 53407910}, {96, 56954740}, {144, 55320037}, {18, 56226061}, {33, 57401900}, {132, 58891451}, {72, 61902746}};
    private static int[][] PAT4 = new int[][]{{36, 83543688}, {24, 80350953}, {129, 72097253}, {66, 75289988}};
    private static int[][] PAT5 = new int[][]{{200, 100320904}, {140, 92067204}, {76, 88874469}, {196, 97128169}, {11, 86962342}, {14, 90956332}, {13, 88295037}, {7, 84301047}, {138, 90509172}, {42, 87312342}, {162, 96363202}, {168, 99560032}, {21, 84457903}, {81, 92445883}, {84, 97768473}, {69, 89780493}, {19, 85025631}, {49, 93810771}, {50, 94877746}, {35, 86092606}, {208, 98384193}, {112, 93858763}, {176, 95457178}, {224, 99982608}};
    private static int[][] PAT6 = new int[][]{{44, 117098120}, {70, 108844420}, {193, 105651685}, {152, 113905385}, {161, 110635979}, {38, 101802847}, {74, 105072253}, {133, 114545689}, {67, 110587987}, {88, 116759824}, {56, 102869822}, {145, 111654962}, {28, 101078263}, {100, 109223099}, {194, 112234394}, {137, 104089558}, {164, 107286388}, {37, 103739558}, {131, 107733548}, {82, 101235119}, {52, 115161409}, {25, 106557709}, {98, 116337248}, {26, 113140418}};
    private static int[][] PAT7 = new int[][]{{41, 133875336}, {146, 130682601}, {134, 129011610}, {104, 126000315}, {148, 117855479}, {73, 120866774}, {97, 133114464}, {22, 125621636}};
    private static int[][] PAT8 = new int[][]{{204, 150652552}, {15, 141287980}, {51, 136424254}, {240, 145788826}, {170, 140840820}, {85, 140112141}};
    private static int[][] PAT9 = new int[][]{{212, 167429768}, {232, 159176068}, {142, 155983333}, {77, 164237033}, {113, 162566042}, {178, 154421206}, {43, 151409911}, {23, 159554747}};
    private static int[][] PAT10 = new int[][]{{165, 184206984}, {90, 175953284}, {102, 179343258}, {195, 171198422}, {153, 168187127}, {60, 176331963}};
    private static int[][] PAT11 = new int[][]{{228, 200984200}, {202, 192730500}, {141, 189537765}, {92, 197791465}, {114, 196120474}, {163, 187975638}, {27, 184964343}, {53, 193109179}, {46, 191172468}, {71, 185121199}, {209, 194522059}, {184, 197026498}};
    private static int[][] PAT12 = new int[][]{{201, 217761416}, {156, 209507716}, {108, 206314981}, {198, 214568681}, {86, 215208985}, {101, 207221005}, {149, 201898415}, {89, 209886395}, {30, 208396844}, {45, 205735549}, {135, 201741559}, {75, 204402854}, {169, 217000544}, {154, 207949684}, {106, 204752854}, {166, 213803714}, {210, 215824705}, {120, 211299275}, {180, 212897690}, {225, 217423120}, {57, 211251283}, {54, 212318258}, {99, 203533118}, {147, 202466143}};
    private static int[][] PAT13 = new int[][]{{150, 234538632}, {105, 226284932}};
    private static int[][] PAT14 = new int[][]{{216, 251315848}, {172, 243062148}, {78, 239869413}, {197, 248123113}, {58, 238307286}, {39, 235295991}, {83, 243440827}, {177, 246452122}, {139, 237957286}, {226, 250977552}, {29, 235452847}, {116, 244853707}};
    private static final int XTRACED = 594;
    private static final int YTRACED = 305;
    private static final int ZTRACED = 15;
    private int[] pattab = new int[256];
    private int dim0;
    private int dim1;
    private int dim2;
    private int dim01;
    private int dim012;
    private int dim_01;
    private float[] xp;
    private float[] yp;
    private float[] zp;
    private Point3f[] b0;
    private Point3f[] f0;
    private Point3f[] m0;
    private Point3f[] b;
    private Point3f[] f;
    private Point3f[] m;
    private Point3f[] tbf;
    private Vector3f[] b0n;
    private Vector3f[] f0n;
    private Vector3f[] m0n;
    private Vector3f[] bn;
    private Vector3f[] fn;
    private Vector3f[] mn;
    private Vector3f[] tbfn;
    private int[] pno = new int[15];
    private int xtraced;
    private int ytraced;
    private int ztraced;
    private int traced;
    private int logOrLinear;
    private boolean hanten;
    private GaussianCubeFile gaussianCubeFile;

    private int BOUND(float f, float f2) {
        return f >= f2 ? 1 : 0;
    }

    private int EXTRACT(int n, int n2) {
        return n >> n2 * 3 & 7;
    }

    private int EXTRACT1(int n, int n2) {
        return n >> n2 & 1;
    }

    public void create_isosurf(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, float[] fArray4, float f, Vector vector, Vector vector2, int n4) {
        int n5;
        int[] nArray = new int[15];
        this.logOrLinear = n4;
        this.init_pattab();
        this.dim0 = n;
        this.dim1 = n2;
        this.dim2 = n3;
        this.dim01 = this.dim0 * this.dim1;
        this.dim012 = this.dim01 * this.dim2;
        try {
            this.b0 = new Point3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (n5 = 0; n5 < this.b0.length; ++n5) {
                this.b0[n5] = new Point3f();
            }
            this.f0 = new Point3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (n5 = 0; n5 < this.f0.length; ++n5) {
                this.f0[n5] = new Point3f();
            }
            this.m0 = new Point3f[this.dim01];
            for (n5 = 0; n5 < this.m0.length; ++n5) {
                this.m0[n5] = new Point3f();
            }
            this.b0n = new Vector3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (n5 = 0; n5 < this.b0n.length; ++n5) {
                this.b0n[n5] = new Vector3f();
            }
            this.f0n = new Vector3f[2 * this.dim01 - this.dim0 - this.dim1];
            for (n5 = 0; n5 < this.f0n.length; ++n5) {
                this.f0n[n5] = new Vector3f();
            }
            this.m0n = new Vector3f[this.dim01];
            for (n5 = 0; n5 < this.m0n.length; ++n5) {
                this.m0n[n5] = new Vector3f();
            }
        }
        catch (Exception exception) {
            System.err.println("MarchingCube/create_isosurf: " + exception);
            return;
        }
        this.xp = fArray;
        this.yp = fArray2;
        this.zp = fArray3;
        for (n5 = 0; n5 < 15; ++n5) {
            this.pno[n5] = 0;
        }
        int n6 = 0;
        this.b = this.b0;
        this.m = this.m0;
        this.f = this.f0;
        this.bn = this.b0n;
        this.mn = this.m0n;
        this.fn = this.f0n;
        int n7 = 0;
        for (n5 = 0; n5 < this.dim2 - 1; ++n5) {
            int n8 = n6;
            n6 = n8 + this.dim01;
            this.read1plane(fArray4, f, n8, n5, vector, vector2);
            this.tbf = this.f;
            this.f = this.b;
            this.b = this.tbf;
            this.tbfn = this.fn;
            this.fn = this.bn;
            this.bn = this.tbfn;
            n7 = 15;
        }
    }

    private void read1plane(float[] fArray, float f, int n, int n2, Vector vector, Vector vector2) {
        int n3;
        float f2 = 0.0f;
        float f3 = 0.0f;
        byte[][] byArray = null;
        int[] nArray = new int[12];
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        int n4 = n;
        int n5 = n4 + this.dim01;
        int n6 = 0;
        Point3f[] point3fArray = new Point3f[12];
        Vector3f[] vector3fArray = new Vector3f[12];
        for (n3 = 0; n3 < point3fArray.length; ++n3) {
            point3fArray[n3] = new Point3f();
            vector3fArray[n3] = new Vector3f();
        }
        n3 = 0;
        int n7 = this.ztraced;
        while (n3 < this.dim1 - 1) {
            int n8 = n6;
            n6 = n8 + this.dim0;
            int n9 = 0;
            int n10 = n7;
            while (n9 < this.dim0 - 1) {
                int n11;
                int n12 = n11 = this.getpcode(fArray, n4, n8, n9, f);
                int n13 = n12 = n12 >> 24 & 0x3F;
                this.pno[n13] = this.pno[n13] + 1;
                if (n12 > 14) {
                    System.out.println("error ");
                } else {
                    int n14 = CROSSEDGE[n12];
                    if (n14 != 0) {
                        int n15;
                        int n16;
                        for (n16 = 0; n16 < 12; ++n16) {
                            if ((n14 & 1) == 1) {
                                int n17;
                                int n18 = this.EXTRACT(n11, UEDGETABLE[n16][0]);
                                int n19 = this.EXTRACT(n11, UEDGETABLE[n16][1]);
                                nArray[n16] = n17 = EDGETABLE[n18][n19];
                                if (this.EXTRACT1(n10, n17) != 0) {
                                    switch (n17) {
                                        case 0: {
                                            this.copyPoint3f(point3fArray[n17], this.f[n8 + n8 - n3 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.fn[n8 + n8 - n3 + n9]);
                                            break;
                                        }
                                        case 1: {
                                            this.copyPoint3f(point3fArray[n17], this.f[this.dim0 - 1 + n8 + n8 - n3 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.fn[this.dim0 - 1 + n8 + n8 - n3 + n9]);
                                            break;
                                        }
                                        case 2: {
                                            this.copyPoint3f(point3fArray[n17], this.f[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1]);
                                            this.copyVector3f(vector3fArray[n17], this.fn[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1]);
                                            break;
                                        }
                                        case 3: {
                                            this.copyPoint3f(point3fArray[n17], this.f[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.fn[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9]);
                                            break;
                                        }
                                        case 4: {
                                            this.copyPoint3f(point3fArray[n17], this.m[n8 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.m0n[n8 + n9]);
                                            break;
                                        }
                                        case 5: {
                                            this.copyPoint3f(point3fArray[n17], this.m[n8 + n9 + 1]);
                                            this.copyVector3f(vector3fArray[n17], this.m0n[n8 + n9 + 1]);
                                            break;
                                        }
                                        case 6: {
                                            this.copyPoint3f(point3fArray[n17], this.m[n6 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.mn[n6 + n9]);
                                            break;
                                        }
                                        case 8: {
                                            this.copyPoint3f(point3fArray[n17], this.b[n8 + n8 - n3 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.bn[n8 + n8 - n3 + n9]);
                                            break;
                                        }
                                        case 9: {
                                            this.copyPoint3f(point3fArray[n17], this.b[this.dim0 - 1 + n8 + n8 - n3 + n9]);
                                            this.copyVector3f(vector3fArray[n17], this.bn[this.dim0 - 1 + n8 + n8 - n3 + n9]);
                                            break;
                                        }
                                    }
                                } else {
                                    f2 = this.find_offset(fArray, n18, n4, n8, n9, n3, n2, point3f, vector3f);
                                    f3 = this.find_offset(fArray, n19, n4, n8, n9, n3, n2, point3f2, vector3f2);
                                    this.interpolate(point3f, point3f2, f2, f3, f, point3fArray[n17]);
                                    this.interpolateNormal(vector3f, vector3f2, f2, f3, f, vector3fArray[n17]);
                                    switch (n17) {
                                        case 0: {
                                            this.copyPoint3f(this.f[n8 + n8 - n3 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.fn[n8 + n8 - n3 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 1: {
                                            this.copyPoint3f(this.f[this.dim0 - 1 + n8 + n8 - n3 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.fn[this.dim0 - 1 + n8 + n8 - n3 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 2: {
                                            this.copyPoint3f(this.f[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1], point3fArray[n17]);
                                            this.copyVector3f(this.fn[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1], vector3fArray[n17]);
                                            break;
                                        }
                                        case 3: {
                                            this.copyPoint3f(this.f[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.fn[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 4: {
                                            this.copyPoint3f(this.m[n8 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.mn[n8 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 5: {
                                            this.copyPoint3f(this.m[n8 + n9 + 1], point3fArray[n17]);
                                            this.copyVector3f(this.mn[n8 + n9 + 1], vector3fArray[n17]);
                                            break;
                                        }
                                        case 6: {
                                            this.copyPoint3f(this.m[n6 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.mn[n6 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 8: {
                                            this.copyPoint3f(this.b[n8 + n8 - n3 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.bn[n8 + n8 - n3 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 9: {
                                            this.copyPoint3f(this.b[this.dim0 - 1 + n8 + n8 - n3 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.bn[this.dim0 - 1 + n8 + n8 - n3 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                        case 7: {
                                            this.copyPoint3f(this.m[n6 + n9 + 1], point3fArray[n17]);
                                            this.copyVector3f(this.mn[n6 + n9 + 1], vector3fArray[n17]);
                                            break;
                                        }
                                        case 10: {
                                            this.copyPoint3f(this.b[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1], point3fArray[n17]);
                                            this.copyVector3f(this.bn[this.dim0 - 1 + n8 + n8 - n3 + n9 + 1], vector3fArray[n17]);
                                            break;
                                        }
                                        case 11: {
                                            this.copyPoint3f(this.b[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9], point3fArray[n17]);
                                            this.copyVector3f(this.bn[n8 + this.dim0 + n8 + this.dim0 - n3 - 1 + n9], vector3fArray[n17]);
                                            break;
                                        }
                                    }
                                }
                            }
                            n14 >>= 1;
                        }
                        switch (n12) {
                            case 1: {
                                n15 = PlyNo1;
                                byArray = PLYEDGES1;
                                break;
                            }
                            case 2: {
                                n15 = (byte)PlyNo2;
                                byArray = PLYEDGES2;
                                break;
                            }
                            case 3: {
                                n15 = (byte)PlyNo3;
                                byArray = PLYEDGES3;
                                break;
                            }
                            case 4: {
                                n15 = (byte)PlyNo4;
                                byArray = PLYEDGES4;
                                break;
                            }
                            case 5: {
                                n15 = (byte)PlyNo5;
                                byArray = PLYEDGES5;
                                break;
                            }
                            case 6: {
                                n15 = (byte)PlyNo6;
                                byArray = PLYEDGES6;
                                break;
                            }
                            case 7: {
                                n15 = (byte)PlyNo7;
                                byArray = PLYEDGES7;
                                break;
                            }
                            case 8: {
                                n15 = (byte)PlyNo8;
                                byArray = PLYEDGES8;
                                break;
                            }
                            case 9: {
                                n15 = (byte)PlyNo9;
                                byArray = PLYEDGES9;
                                break;
                            }
                            case 10: {
                                n15 = (byte)PlyNo10;
                                byArray = PLYEDGES10;
                                break;
                            }
                            case 11: {
                                n15 = (byte)PlyNo11;
                                byArray = PLYEDGES11;
                                break;
                            }
                            case 12: {
                                n15 = (byte)PlyNo12;
                                byArray = PLYEDGES12;
                                break;
                            }
                            case 13: {
                                n15 = (byte)PlyNo13;
                                byArray = PLYEDGES13;
                                break;
                            }
                            case 14: {
                                n15 = (byte)PlyNo14;
                                byArray = PLYEDGES14;
                                break;
                            }
                            default: {
                                n15 = 0;
                            }
                        }
                        for (n16 = 0; n16 < n15; ++n16) {
                            this.addPolygon(byArray[n16][0], byArray[n16][1], byArray[n16][2], f, nArray, point3fArray, vector3fArray, vector, vector2);
                        }
                        n16 = this.hanten ? 1 : 0;
                        if (this.hanten && n12 == 3 || n12 == 6 || n12 == 7) {
                            int n20;
                            int n21;
                            int n22;
                            int n23 = n9;
                            int n24 = n8;
                            int n25 = n4;
                            int n26 = n23 + n24 + n25;
                            if (n12 == 3) {
                                n22 = nArray[0];
                                n21 = nArray[1];
                                n20 = nArray[2];
                            } else {
                                n22 = nArray[2];
                                n21 = nArray[5];
                                n20 = nArray[7];
                            }
                            if (this.sameValue(point3fArray[n22].x, point3fArray[n21].x) && this.sameValue(point3fArray[n21].x, point3fArray[n20].x) && this.sameValue(point3fArray[n22].x, point3fArray[n20].x)) {
                                n23 = this.sameValue(point3fArray[n21].x, this.xp[n26]) ? --n23 : ++n23;
                            } else if (this.sameValue(point3fArray[n22].y, point3fArray[n21].y) && this.sameValue(point3fArray[n21].y, point3fArray[n20].y) && this.sameValue(point3fArray[n22].y, point3fArray[n20].y)) {
                                n24 = this.sameValue(point3fArray[n21].y, this.yp[n26]) ? n8 - this.dim0 : n8 + this.dim0;
                            } else {
                                n25 = this.sameValue(point3fArray[n21].z, this.zp[n26]) ? n4 - this.dim01 : n4 + this.dim01;
                            }
                            int n27 = this.getpcode(fArray, n25, n24, n23, f);
                            n27 = n27 >> 24 & 0x3F;
                            if (!(this.hanten || n27 != 3 && n27 != 6 && n27 != 7 && n27 != 10 && n27 != 12 && n27 != 13)) {
                                if (n12 == 3) {
                                    this.addPolygon(0, 1, 3, f, nArray, point3fArray, vector3fArray, vector, vector2);
                                    this.addPolygon(0, 3, 2, f, nArray, point3fArray, vector3fArray, vector, vector2);
                                } else {
                                    this.addPolygon(2, 5, 7, f, nArray, point3fArray, vector3fArray, vector, vector2);
                                    this.addPolygon(7, 5, 10, f, nArray, point3fArray, vector3fArray, vector, vector2);
                                }
                            }
                        }
                    }
                }
                ++n9;
                n10 = n7;
                n10 |= 0x252;
            }
            ++n3;
            n7 = this.ztraced;
            n7 |= 0x131;
        }
    }

    private void addPolygon(int n, int n2, int n3, float f, int[] nArray, Point3f[] point3fArray, Vector3f[] vector3fArray, Vector vector, Vector vector2) {
        int n4 = nArray[n];
        int n5 = nArray[n2];
        int n6 = nArray[n3];
        Vector3f vector3f = new Vector3f(vector3fArray[n4]);
        Vector3f vector3f2 = new Vector3f(vector3fArray[n5]);
        Vector3f vector3f3 = new Vector3f(vector3fArray[n6]);
        if (f > 0.0f) {
            vector3f.negate();
            vector3f2.negate();
            vector3f3.negate();
        }
        Vector3f vector3f4 = new Vector3f((Tuple3f)point3fArray[n4]);
        Vector3f vector3f5 = new Vector3f((Tuple3f)point3fArray[n5]);
        Vector3f vector3f6 = new Vector3f((Tuple3f)point3fArray[n6]);
        vector3f6.sub((Tuple3f)vector3f5);
        vector3f5.sub((Tuple3f)vector3f4);
        vector3f4.cross(vector3f6, vector3f5);
        int n7 = 0;
        if (vector3f4.angle(vector3f) < 1.2566371f) {
            ++n7;
        }
        if (vector3f4.angle(vector3f2) < 1.2566371f) {
            ++n7;
        }
        if (vector3f4.angle(vector3f3) < 1.2566371f) {
            ++n7;
        }
        if (vector3f4.angle(vector3f) > 1.8849558f) {
            --n7;
        }
        if (vector3f4.angle(vector3f2) > 1.8849558f) {
            --n7;
        }
        if (vector3f4.angle(vector3f3) > 1.8849558f) {
            --n7;
        }
        if (n7 >= 1) {
            vector.addElement(new Point3f(point3fArray[n4]));
            vector.addElement(new Point3f(point3fArray[n6]));
            vector.addElement(new Point3f(point3fArray[n5]));
            vector2.addElement(vector3f);
            vector2.addElement(vector3f3);
            vector2.addElement(vector3f2);
        } else {
            vector.addElement(new Point3f(point3fArray[n4]));
            vector.addElement(new Point3f(point3fArray[n5]));
            vector.addElement(new Point3f(point3fArray[n6]));
            vector2.addElement(vector3f);
            vector2.addElement(vector3f2);
            vector2.addElement(vector3f3);
        }
    }

    private boolean sameValue(float f, float f2) {
        return Math.abs(f - f2) < 1.0E-5f;
    }

    private boolean isEdge(Point3f point3f) {
        if (this.sameValue(point3f.x, this.xp[0]) || this.sameValue(point3f.x, this.xp[this.xp.length - 1]) || this.sameValue(point3f.y, this.yp[0]) || this.sameValue(point3f.y, this.yp[this.yp.length - 1]) || this.sameValue(point3f.z, this.zp[0]) || this.sameValue(point3f.z, this.zp[this.zp.length - 1])) {
            System.out.println(point3f);
            return true;
        }
        return false;
    }

    private Vector3f calcFaceNormal(Point3f[] point3fArray, int n) {
        float f = point3fArray[n + 2].x - point3fArray[n + 1].x;
        float f2 = point3fArray[n + 2].y - point3fArray[n + 1].y;
        float f3 = point3fArray[n + 2].z - point3fArray[n + 1].z;
        float f4 = point3fArray[n + 0].x - point3fArray[n + 1].x;
        float f5 = point3fArray[n + 0].y - point3fArray[n + 1].y;
        float f6 = point3fArray[n + 0].z - point3fArray[n + 1].z;
        float f7 = f2 * f6 - f3 * f5;
        float f8 = f3 * f4 - f * f6;
        float f9 = f * f5 - f2 * f4;
        Vector3f vector3f = new Vector3f(f7, f8, f9);
        vector3f.normalize();
        return vector3f;
    }

    private float find_offset(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, Point3f point3f, Vector3f vector3f) {
        int n7 = 0;
        int n8 = n2 + this.dim01;
        int n9 = n3 + this.dim0;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        switch (n) {
            case 0: {
                n7 = n2 + n3 + n4;
                break;
            }
            case 1: {
                n7 = n2 + n3 + n4 + 1;
                ++n10;
                break;
            }
            case 2: {
                n7 = n2 + n9 + n4;
                ++n11;
                break;
            }
            case 3: {
                n7 = n2 + n9 + n4 + 1;
                ++n10;
                ++n11;
                break;
            }
            case 4: {
                n7 = n8 + n3 + n4;
                ++n12;
                break;
            }
            case 5: {
                n7 = n8 + n3 + n4 + 1;
                ++n12;
                ++n10;
                break;
            }
            case 6: {
                n7 = n8 + n9 + n4;
                ++n12;
                ++n11;
                break;
            }
            case 7: {
                n7 = n8 + n9 + n4 + 1;
                ++n12;
                ++n11;
                ++n10;
                break;
            }
        }
        point3f.x = this.xp[n7];
        point3f.y = this.yp[n7];
        point3f.z = this.zp[n7];
        vector3f.x = n10 == 0 ? (fArray[n7 + 1] - fArray[n7]) * 2.0f : (n10 == this.dim0 - 1 ? (fArray[n7] - fArray[n7 - 1]) * 2.0f : fArray[n7 + 1] - fArray[n7 - 1]);
        vector3f.y = n11 == 0 ? (fArray[n7 + this.dim0] - fArray[n7]) * 2.0f : (n11 == this.dim1 - 1 ? (fArray[n7] - fArray[n7 - this.dim0]) * 2.0f : fArray[n7 + this.dim0] - fArray[n7 - this.dim0]);
        vector3f.z = n12 == 0 ? (fArray[n7 + this.dim01] - fArray[n7]) * 2.0f : (n12 == this.dim2 - 1 ? (fArray[n7] - fArray[n7 - this.dim01]) * 2.0f : fArray[n7 + this.dim01] - fArray[n7 - this.dim01]);
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 > 0.0) {
            float f5 = (float)Math.sqrt(f4);
            vector3f.x = f / f5;
            vector3f.y = f2 / f5;
            vector3f.z = f3 / f5;
        }
        return fArray[n7];
    }

    private void interpolate(Point3f point3f, Point3f point3f2, float f, float f2, float f3, Point3f point3f3) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        fArray[0] = point3f.x;
        fArray[1] = point3f.y;
        fArray[2] = point3f.z;
        fArray2[0] = point3f2.x;
        fArray2[1] = point3f2.y;
        fArray2[2] = point3f2.z;
        if (this.logOrLinear == 0) {
            CrossPoint.get(f, f2, f3, fArray, fArray2, fArray3);
        } else {
            CrossPointLinear.get(f, f2, f3, fArray, fArray2, fArray3);
        }
        point3f3.x = fArray3[0];
        point3f3.y = fArray3[1];
        point3f3.z = fArray3[2];
    }

    private void interpolate(Vector3f vector3f, Vector3f vector3f2, float f, float f2, float f3, Vector3f vector3f3) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        fArray[0] = vector3f.x;
        fArray[1] = vector3f.y;
        fArray[2] = vector3f.z;
        fArray2[0] = vector3f2.x;
        fArray2[1] = vector3f2.y;
        fArray2[2] = vector3f2.z;
        if (this.logOrLinear == 0) {
            CrossPoint.get(f, f2, f3, fArray, fArray2, fArray3);
        } else {
            CrossPointLinear.get(f, f2, f3, fArray, fArray2, fArray3);
        }
        vector3f3.x = fArray3[0];
        vector3f3.y = fArray3[1];
        vector3f3.z = fArray3[2];
    }

    private void interpolateNormal(Vector3f vector3f, Vector3f vector3f2, float f, float f2, float f3, Vector3f vector3f3) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        fArray[0] = vector3f.x;
        fArray[1] = vector3f.y;
        fArray[2] = vector3f.z;
        fArray2[0] = vector3f2.x;
        fArray2[1] = vector3f2.y;
        fArray2[2] = vector3f2.z;
        if (this.logOrLinear == 0) {
            CrossPoint.get(f, f2, f3, fArray, fArray2, fArray3);
        } else {
            CrossPointLinear.get(f, f2, f3, fArray, fArray2, fArray3);
        }
        if (this.gaussianCubeFile != null) {
            vector3f3.x = fArray3[0] * this.gaussianCubeFile.deltaX[0] + fArray3[1] * this.gaussianCubeFile.deltaX[1] + fArray3[2] * this.gaussianCubeFile.deltaX[2];
            vector3f3.y = fArray3[0] * this.gaussianCubeFile.deltaY[0] + fArray3[1] * this.gaussianCubeFile.deltaY[1] + fArray3[2] * this.gaussianCubeFile.deltaY[2];
            vector3f3.z = fArray3[0] * this.gaussianCubeFile.deltaZ[0] + fArray3[1] * this.gaussianCubeFile.deltaZ[1] + fArray3[2] * this.gaussianCubeFile.deltaZ[2];
            vector3f3.x *= 5.0f;
            vector3f3.y *= 5.0f;
            vector3f3.z *= 5.0f;
        } else {
            vector3f3.x = fArray3[0];
            vector3f3.y = fArray3[1];
            vector3f3.z = fArray3[2];
        }
    }

    private int getpcode(float[] fArray, int n, int n2, int n3, float f) {
        try {
            int n4 = 0;
            int n5 = 0;
            int n6 = n + this.dim01;
            int n7 = n2 + this.dim0;
            int n8 = this.BOUND(fArray[n6 + n7 + n3 + 1], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n6 + n7 + n3], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n6 + n2 + n3 + 1], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n6 + n2 + n3], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n + n7 + n3 + 1], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n + n7 + n3], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n + n2 + n3 + 1], f);
            n4 |= n8;
            n4 <<= 1;
            n5 += n8;
            n8 = this.BOUND(fArray[n + n2 + n3], f);
            n4 |= n8;
            this.hanten = false;
            if ((n5 += n8) > 4) {
                n4 = 255 - n4;
                this.hanten = true;
            }
            return this.pattab[n4];
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void init_pattab() {
        int n;
        for (n = 0; n <= 255; ++n) {
            this.pattab[n] = 0xF000000;
        }
        for (n = 0; n < PAT0.length; ++n) {
            this.pattab[MarchingCube.PAT0[n][0]] = PAT0[n][1];
        }
        for (n = 0; n < PAT1.length; ++n) {
            this.pattab[MarchingCube.PAT1[n][0]] = PAT1[n][1];
        }
        for (n = 0; n < PAT2.length; ++n) {
            this.pattab[MarchingCube.PAT2[n][0]] = PAT2[n][1];
        }
        for (n = 0; n < PAT3.length; ++n) {
            this.pattab[MarchingCube.PAT3[n][0]] = PAT3[n][1];
        }
        for (n = 0; n < PAT4.length; ++n) {
            this.pattab[MarchingCube.PAT4[n][0]] = PAT4[n][1];
        }
        for (n = 0; n < PAT5.length; ++n) {
            this.pattab[MarchingCube.PAT5[n][0]] = PAT5[n][1];
        }
        for (n = 0; n < PAT6.length; ++n) {
            this.pattab[MarchingCube.PAT6[n][0]] = PAT6[n][1];
        }
        for (n = 0; n < PAT7.length; ++n) {
            this.pattab[MarchingCube.PAT7[n][0]] = PAT7[n][1];
        }
        for (n = 0; n < PAT8.length; ++n) {
            this.pattab[MarchingCube.PAT8[n][0]] = PAT8[n][1];
        }
        for (n = 0; n < PAT9.length; ++n) {
            this.pattab[MarchingCube.PAT9[n][0]] = PAT9[n][1];
        }
        for (n = 0; n < PAT10.length; ++n) {
            this.pattab[MarchingCube.PAT10[n][0]] = PAT10[n][1];
        }
        for (n = 0; n < PAT11.length; ++n) {
            this.pattab[MarchingCube.PAT11[n][0]] = PAT11[n][1];
        }
        for (n = 0; n < PAT12.length; ++n) {
            this.pattab[MarchingCube.PAT12[n][0]] = PAT12[n][1];
        }
        for (n = 0; n < PAT13.length; ++n) {
            this.pattab[MarchingCube.PAT13[n][0]] = PAT13[n][1];
        }
        for (n = 0; n < PAT14.length; ++n) {
            this.pattab[MarchingCube.PAT14[n][0]] = PAT14[n][1];
        }
    }

    private void copyPoint3f(Point3f point3f, Point3f point3f2) {
        point3f.x = point3f2.x;
        point3f.y = point3f2.y;
        point3f.z = point3f2.z;
    }

    private void copyVector3f(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.x = vector3f2.x;
        vector3f.y = vector3f2.y;
        vector3f.z = vector3f2.z;
    }

    public void setGaussianCubeFile(GaussianCubeFile gaussianCubeFile) {
        this.gaussianCubeFile = gaussianCubeFile;
    }
}

