/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Display;

import AbinitMp.AbinitMpFile.GridFile;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Display.ColorMap;
import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Display.MarchingCube;
import AbinitMp.Display.NormalRender;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.DisplayPreference;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Isosurface
extends TransformGroup {
    private TransparencyAttributes tattr = new TransparencyAttributes();
    private PolygonAttributes pattr;
    private ColoringAttributes cattr;
    private int shading = 0;
    private GaussianCubeFile gaussianCubeFile;

    public Isosurface(int n) {
        this.tattr.setCapability(3);
        if (MyResourceBundle.getResourceString("Transparency").equals("Nice")) {
            this.tattr.setTransparencyMode(1);
        } else {
            this.tattr.setTransparencyMode(3);
        }
        this.pattr = new PolygonAttributes();
        String string = MyResourceBundle.getResourceString("Cull");
        if (string.equals("None")) {
            this.pattr.setCullFace(0);
        } else if (string.equals("Front")) {
            this.pattr.setCullFace(2);
        } else {
            this.pattr.setCullFace(1);
        }
        if (DisplayPreference.isPoligonLine) {
            this.pattr.setPolygonMode(1);
        } else {
            this.pattr.setPolygonMode(2);
        }
        this.pattr.setBackFaceNormalFlip(true);
        this.cattr = new ColoringAttributes();
        this.cattr.setShadeModel(3);
    }

    public TransformGroup createNode(GridFile gridFile, IsosurfaceValue isosurfaceValue, CoordInfo coordInfo) {
        Shape3D shape3D;
        this.tattr.setTransparency((float)isosurfaceValue.transparency / 100.0f);
        if (gridFile.type == 0 || gridFile.type == 2 || gridFile.type == 8) {
            shape3D = this.createIsosurfaecNode(gridFile, isosurfaceValue, coordInfo, isosurfaceValue.value, isosurfaceValue.colorMinus, 0);
            if (shape3D != null) {
                this.addChild((Node)shape3D);
            }
        } else if (gridFile.type == 3 || gridFile.type == 10 || gridFile.type == 14) {
            shape3D = this.createIsosurfaecNode(gridFile, isosurfaceValue, coordInfo, isosurfaceValue.value, isosurfaceValue.colorPlus, 0);
            if (shape3D != null) {
                this.addChild((Node)shape3D);
            }
            if ((shape3D = this.createIsosurfaecNode(gridFile, isosurfaceValue, coordInfo, -isosurfaceValue.value, isosurfaceValue.colorMinus, 0)) != null) {
                this.addChild((Node)shape3D);
            }
        } else if (gridFile.type == 1 || gridFile.type == 9) {
            shape3D = this.createIsosurfaecNode(gridFile, isosurfaceValue, coordInfo, isosurfaceValue.value, isosurfaceValue.colorMinus, 1);
            if (shape3D != null) {
                this.addChild((Node)shape3D);
            }
            if ((shape3D = this.createIsosurfaecNode(gridFile, isosurfaceValue, coordInfo, -isosurfaceValue.value, isosurfaceValue.colorMinus, 1)) != null) {
                this.addChild((Node)shape3D);
            }
        }
        if (isosurfaceValue.boundingBox) {
            int n;
            shape3D = isosurfaceValue.bboxColor;
            LineArray lineArray = new LineArray(24, 5);
            Point3f[] point3fArray = new Point3f[8];
            Point3f point3f = new Point3f(coordInfo.xcenter, coordInfo.ycenter, coordInfo.zcenter);
            int n2 = gridFile.nx - 1;
            int n3 = gridFile.ny - 1;
            int n4 = gridFile.nz - 1;
            int n5 = gridFile.nx;
            int n6 = gridFile.ny;
            int n7 = gridFile.nz;
            if (gridFile.type == 0 || gridFile.type == 2 || gridFile.type == 1 || gridFile.type == 3) {
                point3fArray[0] = new Point3f(gridFile.xx[0], gridFile.yy[0], gridFile.zz[0]);
                point3fArray[1] = new Point3f(gridFile.xx[n2], gridFile.yy[0], gridFile.zz[0]);
                point3fArray[2] = new Point3f(gridFile.xx[n2], gridFile.yy[n3], gridFile.zz[0]);
                point3fArray[3] = new Point3f(gridFile.xx[0], gridFile.yy[n3], gridFile.zz[0]);
                point3fArray[4] = new Point3f(gridFile.xx[0], gridFile.yy[0], gridFile.zz[n4]);
                point3fArray[5] = new Point3f(gridFile.xx[n2], gridFile.yy[0], gridFile.zz[n4]);
                point3fArray[6] = new Point3f(gridFile.xx[n2], gridFile.yy[n3], gridFile.zz[n4]);
                point3fArray[7] = new Point3f(gridFile.xx[0], gridFile.yy[n3], gridFile.zz[n4]);
            } else {
                n = 0;
                point3fArray[0] = new Point3f(gridFile.x[n], gridFile.y[n], gridFile.z[n]);
                n = n2;
                point3fArray[1] = new Point3f(gridFile.x[n], gridFile.y[n], gridFile.z[n]);
                n = n5 * n6 - 1;
                point3fArray[2] = new Point3f(gridFile.x[n], gridFile.y[n], gridFile.z[n]);
                point3fArray[3] = new Point3f(gridFile.x[n -= n2], gridFile.y[n], gridFile.z[n]);
                n = n5 * n6 * (n7 - 1);
                point3fArray[4] = new Point3f(gridFile.x[n], gridFile.y[n], gridFile.z[n]);
                point3fArray[5] = new Point3f(gridFile.x[n += n2], gridFile.y[n], gridFile.z[n]);
                n = n5 * n6 * n7 - 1;
                point3fArray[6] = new Point3f(gridFile.x[n], gridFile.y[n], gridFile.z[n]);
                point3fArray[7] = new Point3f(gridFile.x[n -= n2], gridFile.y[n], gridFile.z[n]);
            }
            for (n = 0; n < 8; ++n) {
                point3fArray[n].sub((Tuple3f)point3f);
            }
            lineArray.setCoordinate(0, point3fArray[0]);
            lineArray.setCoordinate(1, point3fArray[1]);
            lineArray.setCoordinate(2, point3fArray[1]);
            lineArray.setCoordinate(3, point3fArray[2]);
            lineArray.setCoordinate(4, point3fArray[2]);
            lineArray.setCoordinate(5, point3fArray[3]);
            lineArray.setCoordinate(6, point3fArray[3]);
            lineArray.setCoordinate(7, point3fArray[0]);
            lineArray.setCoordinate(8, point3fArray[4]);
            lineArray.setCoordinate(9, point3fArray[5]);
            lineArray.setCoordinate(10, point3fArray[5]);
            lineArray.setCoordinate(11, point3fArray[6]);
            lineArray.setCoordinate(12, point3fArray[6]);
            lineArray.setCoordinate(13, point3fArray[7]);
            lineArray.setCoordinate(14, point3fArray[7]);
            lineArray.setCoordinate(15, point3fArray[4]);
            lineArray.setCoordinate(16, point3fArray[2]);
            lineArray.setCoordinate(17, point3fArray[6]);
            lineArray.setCoordinate(18, point3fArray[1]);
            lineArray.setCoordinate(19, point3fArray[5]);
            lineArray.setCoordinate(20, point3fArray[3]);
            lineArray.setCoordinate(21, point3fArray[7]);
            lineArray.setCoordinate(22, point3fArray[0]);
            lineArray.setCoordinate(23, point3fArray[4]);
            for (n = 0; n < 24; ++n) {
                lineArray.setColor(n, (Color3f)shape3D);
            }
            Appearance appearance = new Appearance();
            LineAttributes lineAttributes = new LineAttributes(2.0f, 0, true);
            appearance.setLineAttributes(lineAttributes);
            Shape3D shape3D2 = new Shape3D((Geometry)lineArray, appearance);
            shape3D2.setPickable(false);
            this.addChild((Node)shape3D2);
        }
        return this;
    }

    private Shape3D createIsosurfaecNode(GridFile gridFile, IsosurfaceValue isosurfaceValue, CoordInfo coordInfo, float f, Color3f color3f, int n) {
        Object object;
        TriangleArray triangleArray;
        Object object2;
        float[] fArray = gridFile.x;
        float[] fArray2 = gridFile.y;
        float[] fArray3 = gridFile.z;
        int n2 = gridFile.nx;
        int n3 = gridFile.ny;
        int n4 = gridFile.nz;
        float[] fArray4 = gridFile.densityValue.length != 0 ? gridFile.densityValue : gridFile.potentialValue;
        Point3f point3f = new Point3f(coordInfo.xcenter, coordInfo.ycenter, coordInfo.zcenter);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        MarchingCube marchingCube = new MarchingCube();
        if (this.gaussianCubeFile != null) {
            marchingCube.setGaussianCubeFile(this.gaussianCubeFile);
        }
        marchingCube.create_isosurf(fArray, fArray2, fArray3, n2, n3, n4, fArray4, f, vector, vector2, n);
        if (vector.size() == 0) {
            return null;
        }
        Point3f[] point3fArray = new Point3f[vector.size()];
        Vector3f[] vector3fArray = new Vector3f[vector2.size()];
        for (int i = 0; i < vector.size(); ++i) {
            point3fArray[i] = (Point3f)vector.get(i);
            point3fArray[i].sub((Tuple3f)point3f);
            vector3fArray[i] = (Vector3f)vector2.get(i);
        }
        Appearance appearance = new Appearance();
        appearance.setCapability(11);
        appearance.setTransparencyAttributes(this.tattr);
        appearance.setPolygonAttributes(this.pattr);
        appearance.setColoringAttributes(this.cattr);
        if (gridFile.type == 2) {
            object2 = new Material();
            object2.setShininess(128.0f);
            object2.setAmbientColor(new Color3f(0.2f, 0.2f, 0.2f));
            object2.setSpecularColor(new Color3f(0.0f, 0.0f, 0.0f));
            appearance.setMaterial((Material)object2);
            triangleArray = new TriangleArray(point3fArray.length, 7);
            object = new ColorMap(isosurfaceValue.minValue, isosurfaceValue.maxValue, isosurfaceValue.potentialColor);
            for (int i = 0; i < point3fArray.length; ++i) {
                int n5;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (n5 = 0; n5 < gridFile.nx; ++n5) {
                    if (!(point3fArray[i].x <= gridFile.xx[n5] - coordInfo.xcenter)) continue;
                    n6 = n5;
                    if (!(Math.abs(point3fArray[i].x - (gridFile.xx[n5] - coordInfo.xcenter)) > 1.0E-7f)) break;
                    n9 = 0;
                    break;
                }
                for (n5 = 0; n5 < gridFile.ny; ++n5) {
                    if (!(point3fArray[i].y <= gridFile.yy[n5] - coordInfo.ycenter)) continue;
                    n7 = n5;
                    if (!(Math.abs(point3fArray[i].y - (gridFile.yy[n5] - coordInfo.ycenter)) > 1.0E-7f)) break;
                    n9 = 1;
                    break;
                }
                for (n5 = 0; n5 < gridFile.nz; ++n5) {
                    if (!(point3fArray[i].z <= gridFile.zz[n5] - coordInfo.zcenter)) continue;
                    n8 = n5;
                    if (!(Math.abs(point3fArray[i].z - (gridFile.zz[n5] - coordInfo.zcenter)) > 1.0E-7f)) break;
                    n9 = 2;
                    break;
                }
                float f2 = 0.0f;
                f2 = n9 == 0 ? (gridFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - gridFile.potentialValue[n6 - 1 + n7 * n2 + n8 * n2 * n3]) * (point3fArray[i].x - (gridFile.xx[n6 - 1] - coordInfo.xcenter)) / (gridFile.xx[n6] - gridFile.xx[n6 - 1]) + gridFile.potentialValue[n6 - 1 + n7 * n2 + n8 * n2 * n3] : (n9 == 1 ? (gridFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - gridFile.potentialValue[n6 + (n7 - 1) * n2 + n8 * n2 * n3]) * (point3fArray[i].y - (gridFile.yy[n7 - 1] - coordInfo.ycenter)) / (gridFile.yy[n7] - gridFile.yy[n7 - 1]) + gridFile.potentialValue[n6 + (n7 - 1) * n2 + n8 * n2 * n3] : (gridFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - gridFile.potentialValue[n6 + n7 * n2 + (n8 - 1) * n2 * n3]) * (point3fArray[i].z - (gridFile.zz[n8 - 1] - coordInfo.zcenter)) / (gridFile.zz[n8] - gridFile.zz[n8 - 1]) + gridFile.potentialValue[n6 + n7 * n2 + (n8 - 1) * n2 * n3]);
                float[] fArray5 = ((ColorMap)object).getRgb(f2);
                triangleArray.setColors(i, fArray5);
            }
        } else {
            if (gridFile.type == 1 || gridFile.type == 9) {
                object2 = new ColorMap(isosurfaceValue.minValue, isosurfaceValue.maxValue, isosurfaceValue.potentialColor);
                color3f = new Color3f(((ColorMap)object2).getRgb(f));
            } else if (!(gridFile.type != 0 && gridFile.type != 8 || isosurfaceValue.userOrValueColor)) {
                object2 = new ColorMap(isosurfaceValue.minValue, isosurfaceValue.maxValue, 1, 2);
                color3f = new Color3f(((ColorMap)object2).getRgb(f));
            }
            object2 = new Material();
            object2.setShininess(128.0f);
            object2.setSpecularColor(color3f);
            object2.setDiffuseColor(color3f);
            object2.setAmbientColor(new Color3f(0.2f, 0.2f, 0.2f));
            appearance.setMaterial((Material)object2);
            triangleArray = new TriangleArray(point3fArray.length, 3);
        }
        if (this.shading == 0) {
            triangleArray.setCoordinates(0, point3fArray);
            triangleArray.setNormals(0, vector3fArray);
            object2 = new Shape3D((Geometry)triangleArray, appearance);
        } else {
            object = new GeometryInfo(1);
            object.setCoordinates(point3fArray);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals((GeometryInfo)object);
            object2 = new Shape3D((Geometry)object.getGeometryArray(), appearance);
        }
        object2.setPickable(false);
        if (DisplayPreference.isNormalLine) {
            object = new NormalRender((GeometryArray)triangleArray, 0.5f);
            Shape3D shape3D = new Shape3D((Geometry)((NormalRender)object).getLineArray());
            this.addChild((Node)shape3D);
            shape3D.setPickable(false);
        }
        return object2;
    }

    public void setTransparency(float f) {
        this.tattr.setTransparency(f);
    }

    public void setShading(int n) {
        this.shading = n;
    }

    public void setGaussianCubeFile(GaussianCubeFile gaussianCubeFile) {
        this.gaussianCubeFile = gaussianCubeFile;
    }
}

