/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.PdbFile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MOL2File {
    public String filename = null;
    public int numberOfAtom;
    public float[] x;
    public float[] y;
    public float[] z;
    public int[] atomNo;
    public String[] atomName;
    public int[] residueNo;
    public String[] residueName;
    public int gridFile = 0;
    public int[][] connect;
    public PdbFile pdbFile;

    public MOL2File(String string) {
        this.readFile(string);
        if (this.filename != null) {
            this.pdbFile = new PdbFile(this);
        }
    }

    public void readFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine().trim();
            while (!string2.equals("@<TRIPOS>MOLECULE")) {
                string2 = bufferedReader.readLine().trim();
            }
            bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.numberOfAtom = Integer.parseInt(stringTokenizer.nextToken());
            bufferedReader.readLine();
            bufferedReader.readLine();
            string2 = bufferedReader.readLine().trim();
            if (string2.equalsIgnoreCase("Grid File")) {
                this.gridFile = 1;
                string2 = bufferedReader.readLine();
            } else {
                string2 = bufferedReader.readLine().trim();
                if (string2.equalsIgnoreCase("Grid File")) {
                    this.gridFile = 1;
                }
            }
            while (!string2.equals("@<TRIPOS>ATOM")) {
                string2 = bufferedReader.readLine().trim();
            }
            this.x = new float[this.numberOfAtom];
            this.y = new float[this.numberOfAtom];
            this.z = new float[this.numberOfAtom];
            this.atomNo = new int[this.numberOfAtom];
            this.atomName = new String[this.numberOfAtom];
            this.residueNo = new int[this.numberOfAtom];
            this.residueName = new String[this.numberOfAtom];
            for (int i = 0; i < this.numberOfAtom; ++i) {
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                this.atomNo[i] = Integer.parseInt(stringTokenizer.nextToken());
                this.atomName[i] = new String(stringTokenizer.nextToken());
                this.x[i] = Float.parseFloat(stringTokenizer.nextToken());
                this.y[i] = Float.parseFloat(stringTokenizer.nextToken());
                this.z[i] = Float.parseFloat(stringTokenizer.nextToken());
                if (this.gridFile == 0) {
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        this.residueNo[i] = Integer.parseInt(stringTokenizer.nextToken());
                        this.residueName[i] = new String(stringTokenizer.nextToken());
                        continue;
                    }
                    this.residueNo[i] = 1;
                    this.residueName[i] = "UKN";
                    continue;
                }
                this.residueNo[i] = 1;
                this.residueName[i] = "UKN";
            }
            if (this.gridFile == 1) {
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                string2 = bufferedReader.readLine().trim();
                while (!string2.equals("@<TRIPOS>BOND")) {
                    string2 = bufferedReader.readLine().trim();
                }
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    vector.add(stringTokenizer.nextToken());
                    vector2.add(stringTokenizer.nextToken());
                    string2 = bufferedReader.readLine();
                }
                this.connect = new int[vector.size()][2];
                for (int i = 0; i < vector.size(); ++i) {
                    this.connect[i][0] = Integer.parseInt((String)vector.get(i));
                    this.connect[i][1] = Integer.parseInt((String)vector2.get(i));
                }
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "MOL2 File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void debugPrint(PrintStream printStream) {
        int n;
        printStream.println("MOL2 File (" + this.filename + ")");
        printStream.println("Number of atom " + this.numberOfAtom);
        for (n = 0; n < this.numberOfAtom; ++n) {
            printStream.println(this.x[n] + " " + this.y[n] + " " + this.z[n] + " " + this.atomName[n] + " " + this.residueName[n] + " " + this.residueNo[n]);
        }
        if (this.gridFile == 1) {
            printStream.println("grid data");
            for (n = 0; n < 8; ++n) {
                printStream.println(this.connect[n][0] + " " + this.connect[n][1]);
            }
        }
    }

    public static void main(String[] stringArray) {
        MOL2File mOL2File = new MOL2File(stringArray[0]);
        mOL2File.debugPrint(System.out);
    }
}

