/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.AbinitMpFile.MoFile;
import AbinitMp.Common.PdbFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.vecmath.Vector3f;

public class GaussianCubeFile
extends MoFile {
    public String filename = null;
    public PdbFile pdbFile;
    private int numberOfAtom;
    private int[] atomNo;
    private float[] charge;
    private float[] coordX;
    private float[] coordY;
    private float[] coordZ;
    public float originX;
    public float originY;
    public float originZ;
    public float[] deltaX = new float[3];
    public float[] deltaY = new float[3];
    public float[] deltaZ = new float[3];
    public float xmin;
    public float ymin;
    public float zmin;
    public float xmax;
    public float ymax;
    public float zmax;
    public float cubeXmin;
    public float cubeYmin;
    public float cubeZmin;
    public float cubeXmax;
    public float cubeYmax;
    public float cubeZmax;
    private boolean atomPeriodic;
    private boolean gridInterpolate;
    private GaussianCubeFile originalFile;

    public GaussianCubeFile() {
    }

    public GaussianCubeFile(String string, int n, boolean bl, boolean bl2) {
        this.type = n;
        this.atomPeriodic = bl;
        this.gridInterpolate = bl2;
        this.readHeader(string);
        if (this.filename != null) {
            this.pdbFile = new PdbFile(this);
            this.putOriginal();
        }
    }

    public void readHeader(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            float f;
            File file = new File(string);
            long l = file.length();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream), (int)l);
            bufferedReader.readLine();
            bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.numberOfAtom = Math.abs(Integer.parseInt(stringTokenizer.nextToken()));
            this.originX = Float.parseFloat(stringTokenizer.nextToken());
            this.originY = Float.parseFloat(stringTokenizer.nextToken());
            this.originZ = Float.parseFloat(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.nx = Integer.parseInt(stringTokenizer.nextToken());
            if (this.gridInterpolate) {
                ++this.nx;
            }
            if (this.nx < 0) {
                f = 1.0f;
                this.nx = -this.nx;
            } else {
                f = 0.5291772f;
                this.originX *= f;
                this.originY *= f;
                this.originZ *= f;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.deltaX[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
            }
            this.xx = new float[this.nx];
            stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.ny = Integer.parseInt(stringTokenizer.nextToken());
            if (this.gridInterpolate) {
                ++this.ny;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.deltaY[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
            }
            this.yy = new float[this.ny];
            stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.nz = Integer.parseInt(stringTokenizer.nextToken());
            if (this.gridInterpolate) {
                ++this.nz;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.deltaZ[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
            }
            this.zz = new float[this.nz];
            this.atomNo = new int[this.numberOfAtom];
            this.charge = new float[this.numberOfAtom];
            this.coordX = new float[this.numberOfAtom];
            this.coordY = new float[this.numberOfAtom];
            this.coordZ = new float[this.numberOfAtom];
            for (n4 = 0; n4 < this.numberOfAtom; ++n4) {
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                this.atomNo[n4] = Integer.parseInt(stringTokenizer.nextToken());
                this.charge[n4] = Float.parseFloat(stringTokenizer.nextToken());
                this.coordX[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
                this.coordY[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
                this.coordZ[n4] = Float.parseFloat(stringTokenizer.nextToken()) * f;
            }
            this.nxyz = this.nx * this.ny * this.nz;
            this.x = new float[this.nxyz];
            this.y = new float[this.nxyz];
            this.z = new float[this.nxyz];
            this.densityValue = new float[this.nxyz];
            this.cubeXmin = this.originX;
            this.cubeXmax = this.originX;
            this.cubeYmin = this.originY;
            this.cubeYmax = this.originY;
            this.cubeZmin = this.originZ;
            this.cubeZmax = this.originZ;
            for (n4 = 0; n4 < this.nz; ++n4) {
                for (n3 = 0; n3 < this.ny; ++n3) {
                    for (n2 = 0; n2 < this.nx; ++n2) {
                        n = n2 + n3 * this.nx + n4 * this.nx * this.ny;
                        this.x[n] = this.originX + this.deltaX[0] * (float)n2 + this.deltaY[0] * (float)n3 + this.deltaZ[0] * (float)n4;
                        this.y[n] = this.originY + this.deltaX[1] * (float)n2 + this.deltaY[1] * (float)n3 + this.deltaZ[1] * (float)n4;
                        this.z[n] = this.originZ + this.deltaX[2] * (float)n2 + this.deltaY[2] * (float)n3 + this.deltaZ[2] * (float)n4;
                        if (this.cubeXmin > this.x[n]) {
                            this.cubeXmin = this.x[n];
                        } else if (this.cubeXmax < this.x[n]) {
                            this.cubeXmax = this.x[n];
                        }
                        if (this.cubeYmin > this.y[n]) {
                            this.cubeYmin = this.y[n];
                        } else if (this.cubeYmax < this.y[n]) {
                            this.cubeYmax = this.y[n];
                        }
                        if (this.cubeZmin > this.z[n]) {
                            this.cubeZmin = this.z[n];
                            continue;
                        }
                        if (!(this.cubeZmax < this.z[n])) continue;
                        this.cubeZmax = this.z[n];
                    }
                }
            }
            if (this.type == 9 || this.type == 8) {
                bufferedReader.mark((int)l);
                bufferedReader.reset();
                char[] cArray = new char[(int)l];
                bufferedReader.read(cArray);
                String string2 = new String(cArray);
                stringTokenizer = new StringTokenizer(string2);
                n3 = 0;
                if (this.gridInterpolate) {
                    n3 = 1;
                }
                for (n2 = 0; n2 < this.nx - n3; ++n2) {
                    for (n = 0; n < this.ny - n3; ++n) {
                        for (int i = 0; i < this.nz - n3; ++i) {
                            float f2;
                            this.densityValue[n2 + n * this.nx + i * this.nx * this.ny] = f2 = Float.parseFloat(stringTokenizer.nextToken());
                        }
                    }
                }
            } else {
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                this.moNum = Integer.parseInt(stringTokenizer.nextToken());
                this.moNumber = new int[this.moNum];
                this.energy = new double[this.moNum];
                for (n4 = 0; n4 < this.moNum; ++n4) {
                    this.moNumber[n4] = Integer.parseInt(stringTokenizer.nextToken());
                    this.energy[n4] = n4 + 1;
                }
                this.minEnergy = 0.5001;
                this.maxEnergy = this.energy[this.moNum - 1];
            }
            if (this.gridInterpolate) {
                int n5 = this.nx - 1;
                for (n3 = 0; n3 < this.ny - 1; ++n3) {
                    for (n2 = 0; n2 < this.nz - 1; ++n2) {
                        this.densityValue[n5 + n3 * this.nx + n2 * this.nx * this.ny] = this.densityValue[n3 * this.nx + n2 * this.nx * this.ny];
                    }
                }
                n5 = this.ny - 1;
                for (n3 = 0; n3 < this.nx - 1; ++n3) {
                    for (n2 = 0; n2 < this.nz - 1; ++n2) {
                        this.densityValue[n3 + n5 * this.nx + n2 * this.nx * this.ny] = this.densityValue[n3 + n2 * this.nx * this.ny];
                    }
                }
                n5 = this.nz - 1;
                for (n3 = 0; n3 < this.nx - 1; ++n3) {
                    for (n2 = 0; n2 < this.ny - 1; ++n2) {
                        this.densityValue[n3 + n2 * this.nx + n5 * this.nx * this.ny] = this.densityValue[n3 + n2 * this.nx];
                    }
                }
                for (n5 = 0; n5 < this.nx - 1; ++n5) {
                    this.densityValue[n5 + (this.ny - 1) * this.nx + (this.nz - 1) * this.nx * this.ny] = this.densityValue[n5];
                }
                for (n5 = 0; n5 < this.ny - 1; ++n5) {
                    this.densityValue[this.nx - 1 + n5 * this.nx + (this.nz - 1) * this.nx * this.ny] = this.densityValue[n5 * this.nx];
                }
                for (n5 = 0; n5 < this.nz - 1; ++n5) {
                    this.densityValue[this.nx - 1 + (this.ny - 1) * this.nx + n5 * this.nx * this.ny] = this.densityValue[n5 * this.nx * this.ny];
                }
                this.densityValue[this.nz * this.nx * this.ny - 1] = this.densityValue[0];
            }
            this.xmin = this.x[0];
            this.ymin = this.y[0];
            this.zmin = this.z[0];
            this.xmax = this.x[this.nx - 1];
            this.ymax = this.y[this.nx * this.ny - 1];
            this.zmax = this.z[this.nx * this.ny * this.nz - 1];
            for (int i = 0; i < this.numberOfAtom; ++i) {
                if (this.xmin > this.coordX[i]) {
                    this.xmin = this.coordX[i];
                } else if (this.xmax < this.coordX[i]) {
                    this.xmax = this.coordX[i];
                }
                if (this.ymin > this.coordY[i]) {
                    this.ymin = this.coordY[i];
                } else if (this.ymax < this.coordY[i]) {
                    this.ymax = this.coordY[i];
                }
                if (this.zmin > this.coordZ[i]) {
                    this.zmin = this.coordZ[i];
                    continue;
                }
                if (!(this.zmax < this.coordZ[i])) continue;
                this.zmax = this.coordZ[i];
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Gaussian cube File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void readMoData(int n) {
        if (this.readMoNum == n) {
            return;
        }
        this.readMoNum = n;
        try {
            int n2;
            int n3;
            File file = new File(this.filename);
            long l = file.length();
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream), (int)l);
            for (int i = 0; i < 7 + this.numberOfAtom; ++i) {
                bufferedReader.readLine();
            }
            bufferedReader.mark((int)l);
            bufferedReader.reset();
            char[] cArray = new char[(int)l];
            bufferedReader.read(cArray);
            String string = new String(cArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            for (n3 = 0; n3 < this.moNum && n != this.moNumber[n3]; ++n3) {
            }
            int n4 = 0;
            if (this.gridInterpolate) {
                n4 = 1;
            }
            for (n2 = 0; n2 < (this.nx - n4) * (this.ny - n4) * (this.nz - n4) * n3; ++n2) {
                stringTokenizer.nextToken();
            }
            for (n2 = 0; n2 < this.nx - n4; ++n2) {
                for (int i = 0; i < this.ny - n4; ++i) {
                    for (int j = 0; j < this.nz - n4; ++j) {
                        float f;
                        this.densityValue[n2 + i * this.nx + j * this.nx * this.ny] = f = Float.parseFloat(stringTokenizer.nextToken());
                    }
                }
            }
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new JFrame(), "Gaussian Cube File read error (" + this.filename + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void debugPrint(PrintStream printStream) {
        int n;
        printStream.println("Gaussian cube File (" + this.filename + ")");
        printStream.println("No  " + this.nx + " " + this.ny + " " + this.nz);
        printStream.println("origin " + this.originX + " " + this.originY + " " + this.originZ);
        printStream.println("delta X " + this.deltaX[0] + " " + this.deltaX[1] + " " + this.deltaX[2]);
        printStream.println("delta Y " + this.deltaY[0] + " " + this.deltaY[1] + " " + this.deltaY[2]);
        printStream.println("delta Z " + this.deltaZ[0] + " " + this.deltaZ[1] + " " + this.deltaZ[2]);
        printStream.println("Number of atom " + this.numberOfAtom);
        for (n = 0; n < this.numberOfAtom; ++n) {
            printStream.println(this.atomNo[n] + " " + this.charge[n] + " " + this.coordX[n] + " " + this.coordY[n] + " " + this.coordZ[n]);
        }
        printStream.print("Number of mo " + this.moNum + ":");
        for (n = 0; n < this.moNum; ++n) {
            printStream.print(" " + this.moNumber[n]);
        }
        printStream.print("\n");
        this.pdbFile.debugPrint(printStream);
    }

    private void putOriginal() {
        this.originalFile = new GaussianCubeFile();
        this.originalFile.setNumberOfAtom(this.numberOfAtom);
        this.originalFile.setAtomNo(this.atomNo);
        this.originalFile.setCoordX(this.coordX);
        this.originalFile.setCoordY(this.coordY);
        this.originalFile.setCoordZ(this.coordZ);
        this.originalFile.xmax = this.xmax;
        this.originalFile.ymax = this.ymax;
        this.originalFile.zmax = this.zmax;
        this.originalFile.cubeXmax = this.cubeXmax;
        this.originalFile.cubeYmax = this.cubeYmax;
        this.originalFile.cubeZmax = this.cubeZmax;
        this.originalFile.nx = this.nx;
        this.originalFile.ny = this.ny;
        this.originalFile.nz = this.nz;
        this.originalFile.nxyz = this.nxyz;
        this.originalFile.x = this.x;
        this.originalFile.y = this.y;
        this.originalFile.z = this.z;
        this.originalFile.xx = this.xx;
        this.originalFile.yy = this.yy;
        this.originalFile.zz = this.zz;
        this.originalFile.densityValue = this.densityValue;
    }

    private void setOriginal() {
        this.numberOfAtom = this.originalFile.getNumberOfAtom();
        this.atomNo = this.originalFile.getAtomNo();
        this.coordX = this.originalFile.getCoordX();
        this.coordY = this.originalFile.getCoordY();
        this.coordZ = this.originalFile.getCoordZ();
        this.xmax = this.originalFile.xmax;
        this.ymax = this.originalFile.ymax;
        this.zmax = this.originalFile.zmax;
        this.cubeXmax = this.originalFile.cubeXmax;
        this.cubeYmax = this.originalFile.cubeYmax;
        this.cubeZmax = this.originalFile.cubeZmax;
        this.nx = this.originalFile.nx;
        this.ny = this.originalFile.ny;
        this.nz = this.originalFile.nz;
        this.nxyz = this.originalFile.nxyz;
        this.x = this.originalFile.x;
        this.y = this.originalFile.y;
        this.z = this.originalFile.z;
        this.xx = this.originalFile.xx;
        this.yy = this.originalFile.yy;
        this.zz = this.originalFile.zz;
        this.densityValue = this.originalFile.densityValue;
    }

    public void createPeriodicData(int n, int n2, int n3) {
        int n4;
        this.xmax = this.originalFile.xmax;
        this.ymax = this.originalFile.ymax;
        this.zmax = this.originalFile.zmax;
        this.cubeXmax = this.originalFile.cubeXmax;
        this.cubeYmax = this.originalFile.cubeYmax;
        this.cubeZmax = this.originalFile.cubeZmax;
        this.nx = this.originalFile.nx * n;
        this.ny = this.originalFile.ny * n2;
        this.nz = this.originalFile.nz * n3;
        this.nxyz = this.nx * this.ny * this.nz;
        this.x = new float[this.nxyz];
        this.y = new float[this.nxyz];
        this.z = new float[this.nxyz];
        this.densityValue = new float[this.nxyz];
        this.xx = new float[this.nx];
        this.yy = new float[this.ny];
        this.zz = new float[this.nz];
        this.cubeXmin = this.originX;
        this.cubeXmax = this.originX;
        this.cubeYmin = this.originY;
        this.cubeYmax = this.originY;
        this.cubeZmin = this.originZ;
        this.cubeZmax = this.originZ;
        for (int i = 0; i < this.nz; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                for (int k = 0; k < this.nx; ++k) {
                    int n5 = k + j * this.nx + i * this.nx * this.ny;
                    n4 = k % this.originalFile.nx + j % this.originalFile.ny * this.originalFile.nx + i % this.originalFile.nz * this.originalFile.nx * this.originalFile.ny;
                    this.x[n5] = this.originX + this.deltaX[0] * (float)k + this.deltaY[0] * (float)j + this.deltaZ[0] * (float)i;
                    this.y[n5] = this.originY + this.deltaX[1] * (float)k + this.deltaY[1] * (float)j + this.deltaZ[1] * (float)i;
                    this.z[n5] = this.originZ + this.deltaX[2] * (float)k + this.deltaY[2] * (float)j + this.deltaZ[2] * (float)i;
                    this.densityValue[n5] = this.originalFile.densityValue[n4];
                    if (this.cubeXmin > this.x[n5]) {
                        this.cubeXmin = this.x[n5];
                    } else if (this.cubeXmax < this.x[n5]) {
                        this.cubeXmax = this.x[n5];
                    }
                    if (this.cubeYmin > this.y[n5]) {
                        this.cubeYmin = this.y[n5];
                    } else if (this.cubeYmax < this.y[n5]) {
                        this.cubeYmax = this.y[n5];
                    }
                    if (this.cubeZmin > this.z[n5]) {
                        this.cubeZmin = this.z[n5];
                        continue;
                    }
                    if (!(this.cubeZmax < this.z[n5])) continue;
                    this.cubeZmax = this.z[n5];
                }
            }
        }
        if (this.atomPeriodic) {
            this.numberOfAtom = this.originalFile.numberOfAtom * n * n2 * n3;
            this.atomNo = new int[this.numberOfAtom];
            this.coordX = new float[this.numberOfAtom];
            this.coordY = new float[this.numberOfAtom];
            this.coordZ = new float[this.numberOfAtom];
            Vector3f vector3f = new Vector3f(this.deltaX[0], this.deltaX[1], this.deltaX[2]);
            Vector3f vector3f2 = new Vector3f(this.deltaY[0], this.deltaY[1], this.deltaY[2]);
            Vector3f vector3f3 = new Vector3f(this.deltaZ[0], this.deltaZ[1], this.deltaZ[2]);
            Vector3f vector3f4 = new Vector3f(this.originX, this.originY, this.originZ);
            n4 = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        float f = this.deltaX[0] * (float)this.originalFile.nx * (float)k + this.deltaY[0] * (float)this.originalFile.ny * (float)j + this.deltaZ[0] * (float)this.originalFile.nz * (float)i;
                        float f2 = this.deltaX[1] * (float)this.originalFile.nx * (float)k + this.deltaY[1] * (float)this.originalFile.ny * (float)j + this.deltaZ[1] * (float)this.originalFile.nz * (float)i;
                        float f3 = this.deltaX[2] * (float)this.originalFile.nx * (float)k + this.deltaY[2] * (float)this.originalFile.ny * (float)j + this.deltaZ[2] * (float)this.originalFile.nz * (float)i;
                        for (int i2 = 0; i2 < this.originalFile.numberOfAtom; ++i2) {
                            this.atomNo[n4] = this.originalFile.atomNo[i2];
                            this.coordX[n4] = this.originalFile.coordX[i2] + f;
                            this.coordY[n4] = this.originalFile.coordY[i2] + f2;
                            this.coordZ[n4] = this.originalFile.coordZ[i2] + f3;
                            ++n4;
                        }
                    }
                }
            }
        } else {
            this.numberOfAtom = this.originalFile.numberOfAtom;
            this.atomNo = this.originalFile.atomNo;
            this.charge = this.originalFile.charge;
            this.coordX = this.originalFile.coordX;
            this.coordY = this.originalFile.coordY;
            this.coordZ = this.originalFile.coordZ;
        }
        this.pdbFile = new PdbFile(this);
        this.xmax = this.x[this.nx - 1];
        this.ymax = this.y[this.nx * this.ny - 1];
        this.zmax = this.z[this.nx * this.ny * this.nz - 1];
        for (int i = 0; i < this.numberOfAtom; ++i) {
            if (this.xmax < this.coordX[i]) {
                this.xmax = this.coordX[i];
            }
            if (this.ymax < this.coordY[i]) {
                this.ymax = this.coordY[i];
            }
            if (!(this.zmax < this.coordZ[i])) continue;
            this.zmax = this.coordZ[i];
        }
    }

    public void setNumberOfAtom(int n) {
        this.numberOfAtom = n;
    }

    public void setAtomNo(int[] nArray) {
        this.atomNo = nArray;
    }

    public void setCoordX(float[] fArray) {
        this.coordX = fArray;
    }

    public void setCoordY(float[] fArray) {
        this.coordY = fArray;
    }

    public void setCoordZ(float[] fArray) {
        this.coordZ = fArray;
    }

    public int getNumberOfAtom() {
        return this.numberOfAtom;
    }

    public int[] getAtomNo() {
        return this.atomNo;
    }

    public float[] getCoordX() {
        return this.coordX;
    }

    public float[] getCoordY() {
        return this.coordY;
    }

    public float[] getCoordZ() {
        return this.coordZ;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        GaussianCubeFile gaussianCubeFile = new GaussianCubeFile(stringArray[0], n, true, true);
        gaussianCubeFile.debugPrint(System.out);
        if (n == 10) {
            gaussianCubeFile.readMoData(gaussianCubeFile.moNumber[0]);
        }
    }
}

