/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : HelpViewer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.textviewer;

import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;

import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JEditorPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.PropertiesManager;

public class HelpViewer extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(HelpViewer.class.getName());

    private Container container;

    private String helpPath;

    private JEditorPane pane;

    private JButton backButton;

    public HelpViewer() {
        super("help", true, true, true, true, new Dimension(800, 600));
        this.container = getContentPane();
        String help = PropertiesManager.getGlobalProperties(
                PropertiesManager.PROPERTIES_PVIEWER)
                .getProperty("htmlhelpdir");
        String helphs = System.getProperty("pviewer.home");
        if (help != null && help.trim().length() != 0) {
            // helphs +=
            // System.getProperty("file.separator")+help+System.getProperty("file.separator")+"help.jar";
            helphs += System.getProperty("file.separator") + "lib"
                    + System.getProperty("file.separator") + "help.jar";
            logger.debug("helpset: " + helphs);
        }
        if (!new File(helphs).exists()) {
            logger.error("couldn't find helpset.");
            dispose();
            return;
        }
        // this.container.setLayout(new FlowLayout());
        this.helpPath = helphs;

        URL url = null;
        HelpSet set = null;
        try {
            // url = new File(helpPath).toURL();
            url = new URL("jar:file:" + helpPath + "!/help.hs");
            set = new HelpSet(HelpViewer.class.getClassLoader(), url);
        } catch (Exception exc) {
        }

        JHelp jhelp = new JHelp(set);
        container.add(jhelp);
    }

}
