/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PhaseInputItems.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

public abstract class PhaseInputItems extends JPanel implements ActionListener,
        CaretListener, TableModelListener, ItemListener, PopupMenuListener {

    protected InputInterface inputInterface;

    protected String NO_SELECTION = ConstParameters.NO_SELECTION;
    protected String ON_OFF[] = { NO_SELECTION, "on", "off" };
    protected Vector ON_OFF_DUPLI = new Vector();
    protected ProjectInfo projectInfo;

    /**
     * Default Constructor; setInputInterfaceȂsetProjectInfoƂ,
     * createGUI()\bh蓮ŃR[.
     */
    protected PhaseInputItems() {
        ON_OFF_DUPLI.addElement(new String[] { "1", "yes" });
        ON_OFF_DUPLI.addElement(new String[] { "1", "1" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "no" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "0" });
    }

    public void setInputInterface(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.inputInterface = projectInfo.getInputInterface();
    }

    protected PhaseInputItems(InputInterface inputInterface) {
        ON_OFF_DUPLI.addElement(new String[] { "1", "yes" });
        ON_OFF_DUPLI.addElement(new String[] { "1", "1" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "no" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "0" });
        this.inputInterface = inputInterface;
        this.createGUI();
    }

    protected PhaseInputItems(ProjectInfo projectInfo) {
        ON_OFF_DUPLI.addElement(new String[] { "1", "yes" });
        ON_OFF_DUPLI.addElement(new String[] { "1", "1" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "no" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "0" });
        this.inputInterface = projectInfo.getInputInterface();
        this.projectInfo = projectInfo;
        this.createGUI();
    }

    public abstract void createGUI();

    public void caretUpdate(CaretEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void tableChanged(TableModelEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void itemStateChanged(ItemEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        // do nothing...
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        // do nothing...
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    protected void fromFile(String parentTag, String tag) {
        ChaseFileChooser chooser = new ChaseFileChooser(ChaseFileChooser.input,
                true);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

        if (chooser.showDialog(this, "open") != JFileChooser.APPROVE_OPTION) {
            return;
        }

        String path = chooser.getSelectedFile().getAbsolutePath();
        DataManager manager = new DataManager(path, PhaseConstants.TABLESPEC,
                false);
        manager.parse();
        InputInterface inputFrom = manager.getInputInterface();
        inputFrom.selectRoot();
        inputInterface.swapBlock(parentTag, tag, inputFrom);
        recreate();
    }

    protected void recreate() {
        removeAll();
        createGUI();
        revalidate();
    }

}
